/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.ApiFunction;
import com.google.api.core.ApiFuture;
import com.google.api.core.BetaApi;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.GaxProperties;
import com.google.api.gax.core.GoogleCredentialsProvider;
import com.google.api.gax.core.InstantiatingExecutorProvider;
import com.google.api.gax.httpjson.GaxHttpJsonProperties;
import com.google.api.gax.httpjson.HttpJsonTransportChannel;
import com.google.api.gax.httpjson.InstantiatingHttpJsonChannelProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.ApiCallContext;
import com.google.api.gax.rpc.ApiClientHeaderProvider;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.PageContext;
import com.google.api.gax.rpc.PagedCallSettings;
import com.google.api.gax.rpc.PagedListDescriptor;
import com.google.api.gax.rpc.PagedListResponseFactory;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.api.gax.rpc.UnaryCallSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.cloud.compute.v1.AggregatedListGlobalOperationsHttpRequest;
import com.google.cloud.compute.v1.DeleteGlobalOperationHttpRequest;
import com.google.cloud.compute.v1.GetGlobalOperationHttpRequest;
import com.google.cloud.compute.v1.GlobalOperationClient;
import com.google.cloud.compute.v1.ListGlobalOperationsHttpRequest;
import com.google.cloud.compute.v1.Operation;
import com.google.cloud.compute.v1.OperationAggregatedList;
import com.google.cloud.compute.v1.OperationList;
import com.google.cloud.compute.v1.OperationsScopedList;
import com.google.cloud.compute.v1.stub.GlobalOperationStub;
import com.google.cloud.compute.v1.stub.HttpJsonGlobalOperationStub;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import org.threeten.bp.Duration;

@BetaApi
public class GlobalOperationStubSettings
extends StubSettings<GlobalOperationStubSettings> {
    private static final ImmutableList<String> DEFAULT_SERVICE_SCOPES = ImmutableList.builder().add((Object)"https://www.googleapis.com/auth/cloud-platform").add((Object)"https://www.googleapis.com/auth/compute").add((Object)"https://www.googleapis.com/auth/compute.readonly").add((Object)"https://www.googleapis.com/auth/devstorage.full_control").add((Object)"https://www.googleapis.com/auth/devstorage.read_only").add((Object)"https://www.googleapis.com/auth/devstorage.read_write").build();
    private final PagedCallSettings<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, GlobalOperationClient.AggregatedListGlobalOperationsPagedResponse> aggregatedListGlobalOperationsSettings;
    private final UnaryCallSettings<DeleteGlobalOperationHttpRequest, Void> deleteGlobalOperationSettings;
    private final UnaryCallSettings<GetGlobalOperationHttpRequest, Operation> getGlobalOperationSettings;
    private final PagedCallSettings<ListGlobalOperationsHttpRequest, OperationList, GlobalOperationClient.ListGlobalOperationsPagedResponse> listGlobalOperationsSettings;
    private static final PagedListDescriptor<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, OperationsScopedList> AGGREGATED_LIST_GLOBAL_OPERATIONS_PAGE_STR_DESC = new PagedListDescriptor<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, OperationsScopedList>(){

        public String emptyToken() {
            return "";
        }

        public AggregatedListGlobalOperationsHttpRequest injectToken(AggregatedListGlobalOperationsHttpRequest payload, String token) {
            return AggregatedListGlobalOperationsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public AggregatedListGlobalOperationsHttpRequest injectPageSize(AggregatedListGlobalOperationsHttpRequest payload, int pageSize) {
            return AggregatedListGlobalOperationsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(AggregatedListGlobalOperationsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(OperationAggregatedList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<OperationsScopedList> extractResources(OperationAggregatedList payload) {
            return payload.getItemsMap() != null ? payload.getItemsMap().values() : ImmutableList.of();
        }
    };
    private static final PagedListDescriptor<ListGlobalOperationsHttpRequest, OperationList, Operation> LIST_GLOBAL_OPERATIONS_PAGE_STR_DESC = new PagedListDescriptor<ListGlobalOperationsHttpRequest, OperationList, Operation>(){

        public String emptyToken() {
            return "";
        }

        public ListGlobalOperationsHttpRequest injectToken(ListGlobalOperationsHttpRequest payload, String token) {
            return ListGlobalOperationsHttpRequest.newBuilder(payload).setPageToken(token).build();
        }

        public ListGlobalOperationsHttpRequest injectPageSize(ListGlobalOperationsHttpRequest payload, int pageSize) {
            return ListGlobalOperationsHttpRequest.newBuilder(payload).setMaxResults(pageSize).build();
        }

        public Integer extractPageSize(ListGlobalOperationsHttpRequest payload) {
            return payload.getMaxResults();
        }

        public String extractNextToken(OperationList payload) {
            return payload.getNextPageToken();
        }

        public Iterable<Operation> extractResources(OperationList payload) {
            return payload.getItemsList() != null ? payload.getItemsList() : ImmutableList.of();
        }
    };
    private static final PagedListResponseFactory<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, GlobalOperationClient.AggregatedListGlobalOperationsPagedResponse> AGGREGATED_LIST_GLOBAL_OPERATIONS_PAGE_STR_FACT = new PagedListResponseFactory<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, GlobalOperationClient.AggregatedListGlobalOperationsPagedResponse>(){

        public ApiFuture<GlobalOperationClient.AggregatedListGlobalOperationsPagedResponse> getFuturePagedResponse(UnaryCallable<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList> callable, AggregatedListGlobalOperationsHttpRequest request, ApiCallContext context, ApiFuture<OperationAggregatedList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)AGGREGATED_LIST_GLOBAL_OPERATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GlobalOperationClient.AggregatedListGlobalOperationsPagedResponse.createAsync((PageContext<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, OperationsScopedList>)pageContext, futureResponse);
        }
    };
    private static final PagedListResponseFactory<ListGlobalOperationsHttpRequest, OperationList, GlobalOperationClient.ListGlobalOperationsPagedResponse> LIST_GLOBAL_OPERATIONS_PAGE_STR_FACT = new PagedListResponseFactory<ListGlobalOperationsHttpRequest, OperationList, GlobalOperationClient.ListGlobalOperationsPagedResponse>(){

        public ApiFuture<GlobalOperationClient.ListGlobalOperationsPagedResponse> getFuturePagedResponse(UnaryCallable<ListGlobalOperationsHttpRequest, OperationList> callable, ListGlobalOperationsHttpRequest request, ApiCallContext context, ApiFuture<OperationList> futureResponse) {
            PageContext pageContext = PageContext.create(callable, (PagedListDescriptor)LIST_GLOBAL_OPERATIONS_PAGE_STR_DESC, (Object)request, (ApiCallContext)context);
            return GlobalOperationClient.ListGlobalOperationsPagedResponse.createAsync((PageContext<ListGlobalOperationsHttpRequest, OperationList, Operation>)pageContext, futureResponse);
        }
    };

    public PagedCallSettings<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, GlobalOperationClient.AggregatedListGlobalOperationsPagedResponse> aggregatedListGlobalOperationsSettings() {
        return this.aggregatedListGlobalOperationsSettings;
    }

    public UnaryCallSettings<DeleteGlobalOperationHttpRequest, Void> deleteGlobalOperationSettings() {
        return this.deleteGlobalOperationSettings;
    }

    public UnaryCallSettings<GetGlobalOperationHttpRequest, Operation> getGlobalOperationSettings() {
        return this.getGlobalOperationSettings;
    }

    public PagedCallSettings<ListGlobalOperationsHttpRequest, OperationList, GlobalOperationClient.ListGlobalOperationsPagedResponse> listGlobalOperationsSettings() {
        return this.listGlobalOperationsSettings;
    }

    @BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
    public GlobalOperationStub createStub() throws IOException {
        if (this.getTransportChannelProvider().getTransportName().equals(HttpJsonTransportChannel.getHttpJsonTransportName())) {
            return HttpJsonGlobalOperationStub.create(this);
        }
        throw new UnsupportedOperationException("Transport not supported: " + this.getTransportChannelProvider().getTransportName());
    }

    public static InstantiatingExecutorProvider.Builder defaultExecutorProviderBuilder() {
        return InstantiatingExecutorProvider.newBuilder();
    }

    public static String getDefaultEndpoint() {
        return "https://www.googleapis.com/compute/v1/projects/";
    }

    public static int getDefaultServicePort() {
        return 443;
    }

    public static List<String> getDefaultServiceScopes() {
        return DEFAULT_SERVICE_SCOPES;
    }

    public static GoogleCredentialsProvider.Builder defaultCredentialsProviderBuilder() {
        return GoogleCredentialsProvider.newBuilder().setScopesToApply(DEFAULT_SERVICE_SCOPES);
    }

    public static InstantiatingHttpJsonChannelProvider.Builder defaultHttpJsonTransportProviderBuilder() {
        return InstantiatingHttpJsonChannelProvider.newBuilder();
    }

    public static TransportChannelProvider defaultTransportChannelProvider() {
        return GlobalOperationStubSettings.defaultHttpJsonTransportProviderBuilder().build();
    }

    @BetaApi(value="The surface for customizing headers is not stable yet and may change in the future.")
    public static ApiClientHeaderProvider.Builder defaultApiClientHeaderProviderBuilder() {
        return ApiClientHeaderProvider.newBuilder().setGeneratedLibToken("gapic", GaxProperties.getLibraryVersion(GlobalOperationStubSettings.class)).setTransportToken(GaxHttpJsonProperties.getHttpJsonTokenName(), GaxHttpJsonProperties.getHttpJsonVersion());
    }

    public static Builder newBuilder() {
        return Builder.createDefault();
    }

    public static Builder newBuilder(ClientContext clientContext) {
        return new Builder(clientContext);
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    protected GlobalOperationStubSettings(Builder settingsBuilder) throws IOException {
        super((StubSettings.Builder)settingsBuilder);
        this.aggregatedListGlobalOperationsSettings = settingsBuilder.aggregatedListGlobalOperationsSettings().build();
        this.deleteGlobalOperationSettings = settingsBuilder.deleteGlobalOperationSettings().build();
        this.getGlobalOperationSettings = settingsBuilder.getGlobalOperationSettings().build();
        this.listGlobalOperationsSettings = settingsBuilder.listGlobalOperationsSettings().build();
    }

    public static class Builder
    extends StubSettings.Builder<GlobalOperationStubSettings, Builder> {
        private final ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders;
        private final PagedCallSettings.Builder<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, GlobalOperationClient.AggregatedListGlobalOperationsPagedResponse> aggregatedListGlobalOperationsSettings;
        private final UnaryCallSettings.Builder<DeleteGlobalOperationHttpRequest, Void> deleteGlobalOperationSettings;
        private final UnaryCallSettings.Builder<GetGlobalOperationHttpRequest, Operation> getGlobalOperationSettings;
        private final PagedCallSettings.Builder<ListGlobalOperationsHttpRequest, OperationList, GlobalOperationClient.ListGlobalOperationsPagedResponse> listGlobalOperationsSettings;
        private static final ImmutableMap<String, ImmutableSet<StatusCode.Code>> RETRYABLE_CODE_DEFINITIONS;
        private static final ImmutableMap<String, RetrySettings> RETRY_PARAM_DEFINITIONS;

        protected Builder() {
            this((ClientContext)null);
        }

        protected Builder(ClientContext clientContext) {
            super(clientContext);
            this.aggregatedListGlobalOperationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)AGGREGATED_LIST_GLOBAL_OPERATIONS_PAGE_STR_FACT);
            this.deleteGlobalOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.getGlobalOperationSettings = UnaryCallSettings.newUnaryCallSettingsBuilder();
            this.listGlobalOperationsSettings = PagedCallSettings.newBuilder((PagedListResponseFactory)LIST_GLOBAL_OPERATIONS_PAGE_STR_FACT);
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListGlobalOperationsSettings, this.deleteGlobalOperationSettings, this.getGlobalOperationSettings, this.listGlobalOperationsSettings);
            Builder.initDefaults(this);
        }

        private static Builder createDefault() {
            Builder builder = new Builder((ClientContext)null);
            builder.setTransportChannelProvider(GlobalOperationStubSettings.defaultTransportChannelProvider());
            builder.setCredentialsProvider((CredentialsProvider)GlobalOperationStubSettings.defaultCredentialsProviderBuilder().build());
            builder.setInternalHeaderProvider((HeaderProvider)GlobalOperationStubSettings.defaultApiClientHeaderProviderBuilder().build());
            builder.setEndpoint(GlobalOperationStubSettings.getDefaultEndpoint());
            return Builder.initDefaults(builder);
        }

        private static Builder initDefaults(Builder builder) {
            builder.aggregatedListGlobalOperationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.deleteGlobalOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.getGlobalOperationSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            builder.listGlobalOperationsSettings().setRetryableCodes((Set)RETRYABLE_CODE_DEFINITIONS.get((Object)"idempotent")).setRetrySettings((RetrySettings)RETRY_PARAM_DEFINITIONS.get((Object)"default"));
            return builder;
        }

        protected Builder(GlobalOperationStubSettings settings) {
            super((StubSettings)settings);
            this.aggregatedListGlobalOperationsSettings = settings.aggregatedListGlobalOperationsSettings.toBuilder();
            this.deleteGlobalOperationSettings = settings.deleteGlobalOperationSettings.toBuilder();
            this.getGlobalOperationSettings = settings.getGlobalOperationSettings.toBuilder();
            this.listGlobalOperationsSettings = settings.listGlobalOperationsSettings.toBuilder();
            this.unaryMethodSettingsBuilders = ImmutableList.of(this.aggregatedListGlobalOperationsSettings, this.deleteGlobalOperationSettings, this.getGlobalOperationSettings, this.listGlobalOperationsSettings);
        }

        public Builder applyToAllUnaryMethods(ApiFunction<UnaryCallSettings.Builder<?, ?>, Void> settingsUpdater) throws Exception {
            StubSettings.Builder.applyToAllUnaryMethods(this.unaryMethodSettingsBuilders, settingsUpdater);
            return this;
        }

        public ImmutableList<UnaryCallSettings.Builder<?, ?>> unaryMethodSettingsBuilders() {
            return this.unaryMethodSettingsBuilders;
        }

        public PagedCallSettings.Builder<AggregatedListGlobalOperationsHttpRequest, OperationAggregatedList, GlobalOperationClient.AggregatedListGlobalOperationsPagedResponse> aggregatedListGlobalOperationsSettings() {
            return this.aggregatedListGlobalOperationsSettings;
        }

        public UnaryCallSettings.Builder<DeleteGlobalOperationHttpRequest, Void> deleteGlobalOperationSettings() {
            return this.deleteGlobalOperationSettings;
        }

        public UnaryCallSettings.Builder<GetGlobalOperationHttpRequest, Operation> getGlobalOperationSettings() {
            return this.getGlobalOperationSettings;
        }

        public PagedCallSettings.Builder<ListGlobalOperationsHttpRequest, OperationList, GlobalOperationClient.ListGlobalOperationsPagedResponse> listGlobalOperationsSettings() {
            return this.listGlobalOperationsSettings;
        }

        public GlobalOperationStubSettings build() throws IOException {
            return new GlobalOperationStubSettings(this);
        }

        static {
            ImmutableMap.Builder definitions = ImmutableMap.builder();
            definitions.put((Object)"idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList((Object[])new StatusCode.Code[]{StatusCode.Code.DEADLINE_EXCEEDED, StatusCode.Code.UNAVAILABLE})));
            definitions.put((Object)"non_idempotent", (Object)ImmutableSet.copyOf((Collection)Lists.newArrayList()));
            RETRYABLE_CODE_DEFINITIONS = definitions.build();
            definitions = ImmutableMap.builder();
            RetrySettings settings = null;
            settings = RetrySettings.newBuilder().setInitialRetryDelay(Duration.ofMillis((long)100L)).setRetryDelayMultiplier(1.3).setMaxRetryDelay(Duration.ofMillis((long)60000L)).setInitialRpcTimeout(Duration.ofMillis((long)20000L)).setRpcTimeoutMultiplier(1.0).setMaxRpcTimeout(Duration.ofMillis((long)20000L)).setTotalTimeout(Duration.ofMillis((long)600000L)).build();
            definitions.put((Object)"default", (Object)settings);
            RETRY_PARAM_DEFINITIONS = definitions.build();
        }
    }
}

