/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1.stub;

import com.google.api.core.BetaApi;
import com.google.api.core.InternalApi;
import com.google.api.gax.core.BackgroundResource;
import com.google.api.gax.core.BackgroundResourceAggregation;
import com.google.api.gax.httpjson.ApiMessage;
import com.google.api.gax.httpjson.ApiMessageHttpRequestFormatter;
import com.google.api.gax.httpjson.ApiMessageHttpResponseParser;
import com.google.api.gax.httpjson.ApiMethodDescriptor;
import com.google.api.gax.httpjson.HttpJsonCallSettings;
import com.google.api.gax.httpjson.HttpJsonStubCallableFactory;
import com.google.api.gax.httpjson.HttpRequestFormatter;
import com.google.api.gax.httpjson.HttpResponseParser;
import com.google.api.gax.rpc.ClientContext;
import com.google.api.gax.rpc.StubSettings;
import com.google.api.gax.rpc.UnaryCallable;
import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.compute.v1.GetZoneHttpRequest;
import com.google.cloud.compute.v1.ListZonesHttpRequest;
import com.google.cloud.compute.v1.ProjectName;
import com.google.cloud.compute.v1.ProjectZoneName;
import com.google.cloud.compute.v1.Zone;
import com.google.cloud.compute.v1.ZoneClient;
import com.google.cloud.compute.v1.ZoneList;
import com.google.cloud.compute.v1.stub.HttpJsonZoneCallableFactory;
import com.google.cloud.compute.v1.stub.ZoneStub;
import com.google.cloud.compute.v1.stub.ZoneStubSettings;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.util.Set;
import java.util.concurrent.TimeUnit;

@BetaApi(value="A restructuring of stub classes is planned, so this may break in the future")
public class HttpJsonZoneStub
extends ZoneStub {
    @InternalApi
    public static final ApiMethodDescriptor<GetZoneHttpRequest, Zone> getZoneMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.zones.get").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones/{zone}")).setQueryParams((Set)Sets.newHashSet()).setResourceNameFactory(ProjectZoneName.newFactory()).setResourceNameField("zone").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)Zone.getDefaultInstance()).build()).build();
    @InternalApi
    public static final ApiMethodDescriptor<ListZonesHttpRequest, ZoneList> listZonesMethodDescriptor = ApiMethodDescriptor.newBuilder().setFullMethodName("compute.zones.list").setHttpMethod("GET").setRequestFormatter((HttpRequestFormatter)ApiMessageHttpRequestFormatter.newBuilder().setPathTemplate(PathTemplate.create((String)"{project}/zones")).setQueryParams((Set)Sets.newHashSet((Object[])new String[]{"filter", "maxResults", "orderBy", "pageToken"})).setResourceNameFactory(ProjectName.newFactory()).setResourceNameField("project").build()).setResponseParser((HttpResponseParser)ApiMessageHttpResponseParser.newBuilder().setResponseInstance((ApiMessage)ZoneList.getDefaultInstance()).build()).build();
    private final BackgroundResource backgroundResources;
    private final UnaryCallable<GetZoneHttpRequest, Zone> getZoneCallable;
    private final UnaryCallable<ListZonesHttpRequest, ZoneList> listZonesCallable;
    private final UnaryCallable<ListZonesHttpRequest, ZoneClient.ListZonesPagedResponse> listZonesPagedCallable;
    private final HttpJsonStubCallableFactory callableFactory;

    public static final HttpJsonZoneStub create(ZoneStubSettings settings) throws IOException {
        return new HttpJsonZoneStub(settings, ClientContext.create((StubSettings)settings));
    }

    public static final HttpJsonZoneStub create(ClientContext clientContext) throws IOException {
        return new HttpJsonZoneStub(ZoneStubSettings.newBuilder().build(), clientContext);
    }

    public static final HttpJsonZoneStub create(ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        return new HttpJsonZoneStub(ZoneStubSettings.newBuilder().build(), clientContext, callableFactory);
    }

    protected HttpJsonZoneStub(ZoneStubSettings settings, ClientContext clientContext) throws IOException {
        this(settings, clientContext, new HttpJsonZoneCallableFactory());
    }

    protected HttpJsonZoneStub(ZoneStubSettings settings, ClientContext clientContext, HttpJsonStubCallableFactory callableFactory) throws IOException {
        this.callableFactory = callableFactory;
        HttpJsonCallSettings getZoneTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(getZoneMethodDescriptor).build();
        HttpJsonCallSettings listZonesTransportSettings = HttpJsonCallSettings.newBuilder().setMethodDescriptor(listZonesMethodDescriptor).build();
        this.getZoneCallable = callableFactory.createUnaryCallable(getZoneTransportSettings, settings.getZoneSettings(), clientContext);
        this.listZonesCallable = callableFactory.createUnaryCallable(listZonesTransportSettings, settings.listZonesSettings(), clientContext);
        this.listZonesPagedCallable = callableFactory.createPagedCallable(listZonesTransportSettings, settings.listZonesSettings(), clientContext);
        this.backgroundResources = new BackgroundResourceAggregation(clientContext.getBackgroundResources());
    }

    @Override
    @BetaApi
    public UnaryCallable<GetZoneHttpRequest, Zone> getZoneCallable() {
        return this.getZoneCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListZonesHttpRequest, ZoneClient.ListZonesPagedResponse> listZonesPagedCallable() {
        return this.listZonesPagedCallable;
    }

    @Override
    @BetaApi
    public UnaryCallable<ListZonesHttpRequest, ZoneList> listZonesCallable() {
        return this.listZonesCallable;
    }

    @Override
    public final void close() {
        this.shutdown();
    }

    public void shutdown() {
        this.backgroundResources.shutdown();
    }

    public boolean isShutdown() {
        return this.backgroundResources.isShutdown();
    }

    public boolean isTerminated() {
        return this.backgroundResources.isTerminated();
    }

    public void shutdownNow() {
        this.backgroundResources.shutdownNow();
    }

    public boolean awaitTermination(long duration, TimeUnit unit) throws InterruptedException {
        return this.backgroundResources.awaitTermination(duration, unit);
    }
}

