/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.spring.pubsub.support;

import com.google.api.core.ApiClock;
import com.google.api.gax.batching.FlowControlSettings;
import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.ExecutorProvider;
import com.google.api.gax.retrying.RetrySettings;
import com.google.api.gax.rpc.HeaderProvider;
import com.google.api.gax.rpc.StatusCode;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.MessageReceiver;
import com.google.cloud.pubsub.v1.Subscriber;
import com.google.cloud.pubsub.v1.stub.GrpcSubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStub;
import com.google.cloud.pubsub.v1.stub.SubscriberStubSettings;
import com.google.cloud.spring.core.GcpProjectIdProvider;
import com.google.cloud.spring.pubsub.core.PubSubConfiguration;
import com.google.cloud.spring.pubsub.core.PubSubException;
import com.google.cloud.spring.pubsub.core.health.HealthTrackerRegistry;
import com.google.cloud.spring.pubsub.support.PubSubSubscriptionUtils;
import com.google.cloud.spring.pubsub.support.SubscriberFactory;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.PullRequest;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nullable;
import org.springframework.util.Assert;
import org.threeten.bp.Duration;

public class DefaultSubscriberFactory
implements SubscriberFactory {
    private final String projectId;
    private ExecutorProvider executorProvider;
    private TransportChannelProvider channelProvider;
    private CredentialsProvider credentialsProvider;
    private HeaderProvider headerProvider;
    private ExecutorProvider systemExecutorProvider;
    private FlowControlSettings flowControlSettings;
    private Duration maxAckExtensionPeriod;
    private Duration minDurationPerAckExtension;
    private Duration maxDurationPerAckExtension;
    private Integer parallelPullCount;
    private String pullEndpoint;
    private String universeDomain;
    private ApiClock apiClock;
    private RetrySettings subscriberStubRetrySettings;
    private HealthTrackerRegistry healthTrackerRegistry;
    private PubSubConfiguration pubSubConfiguration;
    private Map<ProjectSubscriptionName, FlowControlSettings> flowControlSettingsMap = new HashMap<ProjectSubscriptionName, FlowControlSettings>();
    private Map<ProjectSubscriptionName, RetrySettings> retrySettingsMap = new ConcurrentHashMap<ProjectSubscriptionName, RetrySettings>();
    private FlowControlSettings globalFlowControlSettings;
    private RetrySettings globalRetrySettings;
    private Map<ProjectSubscriptionName, ExecutorProvider> executorProviderMap = new ConcurrentHashMap<ProjectSubscriptionName, ExecutorProvider>();
    private ExecutorProvider globalExecutorProvider;
    private StatusCode.Code[] retryableCodes;

    public DefaultSubscriberFactory(GcpProjectIdProvider projectIdProvider, PubSubConfiguration pubSubConfiguration) {
        Assert.notNull((Object)projectIdProvider, (String)"The project ID provider can't be null.");
        this.projectId = projectIdProvider.getProjectId();
        Assert.hasText((String)this.projectId, (String)"The project ID can't be null or empty.");
        Assert.notNull((Object)pubSubConfiguration, (String)"The pub/sub configuration can't be null.");
        this.pubSubConfiguration = pubSubConfiguration;
    }

    @Override
    public String getProjectId() {
        return this.projectId;
    }

    public void setExecutorProvider(ExecutorProvider executorProvider) {
        this.executorProvider = executorProvider;
    }

    public void setChannelProvider(TransportChannelProvider channelProvider) {
        this.channelProvider = channelProvider;
    }

    public void setCredentialsProvider(CredentialsProvider credentialsProvider) {
        this.credentialsProvider = credentialsProvider;
    }

    public void setHeaderProvider(HeaderProvider headerProvider) {
        this.headerProvider = headerProvider;
    }

    public void setSystemExecutorProvider(ExecutorProvider systemExecutorProvider) {
        this.systemExecutorProvider = systemExecutorProvider;
    }

    public void setFlowControlSettings(FlowControlSettings flowControlSettings) {
        this.flowControlSettings = flowControlSettings;
    }

    public void setMaxAckExtensionPeriod(Duration maxAckExtensionPeriod) {
        this.maxAckExtensionPeriod = maxAckExtensionPeriod;
    }

    public void setParallelPullCount(Integer parallelPullCount) {
        this.parallelPullCount = parallelPullCount;
    }

    public void setPullEndpoint(String pullEndpoint) {
        this.pullEndpoint = pullEndpoint;
    }

    public void setApiClock(ApiClock apiClock) {
        this.apiClock = apiClock;
    }

    public void setSubscriberStubRetrySettings(RetrySettings subscriberStubRetrySettings) {
        this.subscriberStubRetrySettings = subscriberStubRetrySettings;
    }

    public void setRetryableCodes(StatusCode.Code[] retryableCodes) {
        this.retryableCodes = retryableCodes;
    }

    public void setHealthTrackerRegistry(HealthTrackerRegistry healthTrackerRegistry) {
        this.healthTrackerRegistry = healthTrackerRegistry;
    }

    @Override
    public Subscriber createSubscriber(String subscriptionName, MessageReceiver receiver) {
        String universeDomain;
        Integer pullCount;
        Duration durationPerAckExtension;
        Duration ackExtensionPeriod;
        FlowControlSettings flowControl;
        String endpoint;
        ExecutorProvider executor;
        ProjectSubscriptionName projectSubscriptionName = PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, this.projectId);
        boolean shouldAddToHealthCheck = this.shouldAddToHealthCheck(subscriptionName);
        if (shouldAddToHealthCheck) {
            receiver = this.healthTrackerRegistry.wrap(projectSubscriptionName, receiver);
        }
        Subscriber.Builder subscriberBuilder = Subscriber.newBuilder((ProjectSubscriptionName)projectSubscriptionName, (MessageReceiver)receiver);
        if (this.channelProvider != null) {
            subscriberBuilder.setChannelProvider(this.channelProvider);
        }
        if ((executor = this.getExecutorProvider(subscriptionName)) != null) {
            subscriberBuilder.setExecutorProvider(executor);
        }
        if (this.credentialsProvider != null) {
            subscriberBuilder.setCredentialsProvider(this.credentialsProvider);
        }
        if (this.headerProvider != null) {
            subscriberBuilder.setHeaderProvider(this.headerProvider);
        }
        if (this.systemExecutorProvider != null) {
            subscriberBuilder.setSystemExecutorProvider(this.systemExecutorProvider);
        }
        if ((endpoint = this.getPullEndpoint(subscriptionName)) != null) {
            subscriberBuilder.setEndpoint(endpoint);
        }
        if ((flowControl = this.getFlowControlSettings(subscriptionName)) != null) {
            subscriberBuilder.setFlowControlSettings(flowControl);
        }
        if ((ackExtensionPeriod = this.getMaxAckExtensionPeriod(subscriptionName)) != null) {
            subscriberBuilder.setMaxAckExtensionPeriod(ackExtensionPeriod);
        }
        if ((durationPerAckExtension = this.getMinDurationPerAckExtension(subscriptionName)) != null) {
            subscriberBuilder.setMinDurationPerAckExtension(durationPerAckExtension);
        }
        if ((durationPerAckExtension = this.getMaxDurationPerAckExtension(subscriptionName)) != null) {
            subscriberBuilder.setMaxDurationPerAckExtension(durationPerAckExtension);
        }
        if ((pullCount = this.getPullCount(subscriptionName)) != null) {
            subscriberBuilder.setParallelPullCount(pullCount.intValue());
        }
        if ((universeDomain = this.getUniverseDomain(subscriptionName)) != null) {
            subscriberBuilder.setUniverseDomain(universeDomain);
        }
        Subscriber subscriber = subscriberBuilder.build();
        if (shouldAddToHealthCheck) {
            this.healthTrackerRegistry.addListener(subscriber);
        }
        return subscriber;
    }

    @Override
    public PullRequest createPullRequest(String subscriptionName, Integer maxMessages, Boolean returnImmediately) {
        Assert.hasLength((String)subscriptionName, (String)"The subscription name must be provided.");
        if (maxMessages == null) {
            maxMessages = Integer.MAX_VALUE;
        }
        Assert.isTrue((maxMessages > 0 ? 1 : 0) != 0, (String)"The maxMessages must be greater than 0.");
        PullRequest.Builder pullRequestBuilder = PullRequest.newBuilder().setSubscription(PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, this.projectId).toString()).setMaxMessages(maxMessages.intValue());
        if (returnImmediately != null) {
            pullRequestBuilder.setReturnImmediately(returnImmediately.booleanValue());
        }
        return pullRequestBuilder.build();
    }

    @Override
    public SubscriberStub createSubscriberStub(String subscriptionName) {
        try {
            return GrpcSubscriberStub.create((SubscriberStubSettings)this.buildSubscriberStubSettings(subscriptionName));
        }
        catch (IOException ex) {
            throw new PubSubException("Error creating the SubscriberStub", ex);
        }
    }

    SubscriberStubSettings buildGlobalSubscriberStubSettings() throws IOException {
        StatusCode.Code[] codes;
        RetrySettings retrySettings;
        ExecutorProvider executor;
        String endpoint;
        SubscriberStubSettings.Builder subscriberStubSettings = this.buildStubSettingsWithoutConfigurations();
        String string = endpoint = this.pullEndpoint != null ? this.pullEndpoint : this.pubSubConfiguration.getSubscriber().getPullEndpoint();
        if (endpoint != null) {
            subscriberStubSettings.setEndpoint(endpoint);
        }
        ExecutorProvider executorProvider = executor = this.executorProvider != null ? this.executorProvider : this.globalExecutorProvider;
        if (executor != null) {
            subscriberStubSettings.setBackgroundExecutorProvider(executor);
        }
        RetrySettings retrySettings2 = retrySettings = this.subscriberStubRetrySettings != null ? this.subscriberStubRetrySettings : this.globalRetrySettings;
        if (retrySettings != null) {
            subscriberStubSettings.pullSettings().setRetrySettings(retrySettings);
        }
        StatusCode.Code[] codeArray = codes = this.retryableCodes != null ? this.retryableCodes : this.pubSubConfiguration.getSubscriber().getRetryableCodes();
        if (codes != null) {
            subscriberStubSettings.pullSettings().setRetryableCodes(codes);
        }
        return subscriberStubSettings.build();
    }

    SubscriberStubSettings buildSubscriberStubSettings(String subscriptionName) throws IOException {
        StatusCode.Code[] codes;
        RetrySettings retrySettings;
        ExecutorProvider executor;
        SubscriberStubSettings.Builder subscriberStubSettings = this.buildStubSettingsWithoutConfigurations();
        String endpoint = this.getPullEndpoint(subscriptionName);
        if (endpoint != null) {
            subscriberStubSettings.setEndpoint(endpoint);
        }
        if ((executor = this.getExecutorProvider(subscriptionName)) != null) {
            subscriberStubSettings.setBackgroundExecutorProvider(executor);
        }
        if ((retrySettings = this.getRetrySettings(subscriptionName)) != null) {
            subscriberStubSettings.pullSettings().setRetrySettings(retrySettings);
        }
        if ((codes = this.getRetryableCodes(subscriptionName)) != null) {
            subscriberStubSettings.pullSettings().setRetryableCodes(codes);
        }
        return subscriberStubSettings.build();
    }

    SubscriberStubSettings.Builder buildStubSettingsWithoutConfigurations() {
        SubscriberStubSettings.Builder subscriberStubSettings = SubscriberStubSettings.newBuilder();
        if (this.credentialsProvider != null) {
            subscriberStubSettings.setCredentialsProvider(this.credentialsProvider);
        }
        if (this.headerProvider != null) {
            subscriberStubSettings.setHeaderProvider(this.headerProvider);
        }
        if (this.channelProvider != null) {
            subscriberStubSettings.setTransportChannelProvider(this.channelProvider);
        }
        if (this.apiClock != null) {
            subscriberStubSettings.setClock(this.apiClock);
        }
        return subscriberStubSettings;
    }

    public ExecutorProvider getExecutorProvider(String subscriptionName) {
        if (this.executorProvider != null) {
            return this.executorProvider;
        }
        ProjectSubscriptionName projectSubscriptionName = PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, this.projectId);
        if (this.executorProviderMap.containsKey(projectSubscriptionName)) {
            return this.executorProviderMap.get(projectSubscriptionName);
        }
        return this.globalExecutorProvider;
    }

    public RetrySettings getRetrySettings(String subscriptionName) {
        if (this.subscriberStubRetrySettings != null) {
            return this.subscriberStubRetrySettings;
        }
        ProjectSubscriptionName projectSubscriptionName = PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, this.projectId);
        if (this.retrySettingsMap.containsKey(projectSubscriptionName)) {
            return this.retrySettingsMap.get(projectSubscriptionName);
        }
        return this.globalRetrySettings;
    }

    public FlowControlSettings getFlowControlSettings(String subscriptionName) {
        ProjectSubscriptionName projectSubscriptionName = PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, this.projectId);
        if (this.flowControlSettings != null) {
            return this.flowControlSettings;
        }
        if (this.flowControlSettingsMap.containsKey(projectSubscriptionName)) {
            return this.flowControlSettingsMap.get(projectSubscriptionName);
        }
        return this.globalFlowControlSettings;
    }

    Duration getMaxAckExtensionPeriod(String subscriptionName) {
        if (this.maxAckExtensionPeriod != null) {
            return this.maxAckExtensionPeriod;
        }
        return Duration.ofSeconds((long)this.pubSubConfiguration.computeMaxAckExtensionPeriod(subscriptionName, this.projectId));
    }

    @Nullable
    Duration getMinDurationPerAckExtension(String subscriptionName) {
        if (this.minDurationPerAckExtension != null) {
            return this.minDurationPerAckExtension;
        }
        Long extension = this.pubSubConfiguration.computeMinDurationPerAckExtension(subscriptionName, this.projectId);
        return extension == null ? null : Duration.ofSeconds((long)extension);
    }

    public void setMinDurationPerAckExtension(@Nullable Duration minDurationPerAckExtension) {
        this.minDurationPerAckExtension = minDurationPerAckExtension;
    }

    @Nullable
    Duration getMaxDurationPerAckExtension(String subscriptionName) {
        if (this.maxDurationPerAckExtension != null) {
            return this.maxDurationPerAckExtension;
        }
        Long extension = this.pubSubConfiguration.computeMaxDurationPerAckExtension(subscriptionName, this.projectId);
        return extension == null ? null : Duration.ofSeconds((long)extension);
    }

    public void setMaxDurationPerAckExtension(@Nullable Duration maxDurationPerAckExtension) {
        this.maxDurationPerAckExtension = maxDurationPerAckExtension;
    }

    Integer getPullCount(String subscriptionName) {
        if (this.parallelPullCount != null) {
            return this.parallelPullCount;
        }
        return this.pubSubConfiguration.computeParallelPullCount(subscriptionName, this.projectId);
    }

    String getPullEndpoint(String subscriptionName) {
        if (this.pullEndpoint != null) {
            return this.pullEndpoint;
        }
        return this.pubSubConfiguration.computePullEndpoint(subscriptionName, this.projectId);
    }

    public StatusCode.Code[] getRetryableCodes(String subscriptionName) {
        if (this.retryableCodes != null) {
            return this.retryableCodes;
        }
        return this.pubSubConfiguration.computeRetryableCodes(subscriptionName, this.projectId);
    }

    String getUniverseDomain(String subscriptionName) {
        if (this.universeDomain != null) {
            return this.universeDomain;
        }
        return this.pubSubConfiguration.computeSubscriberUniverseDomain(subscriptionName, this.projectId);
    }

    public void setExecutorProviderMap(Map<ProjectSubscriptionName, ExecutorProvider> executorProviderMap) {
        this.executorProviderMap = executorProviderMap;
    }

    public void setGlobalExecutorProvider(ExecutorProvider executorProvider) {
        this.globalExecutorProvider = executorProvider;
    }

    public ExecutorProvider getGlobalExecutorProvider() {
        return this.globalExecutorProvider;
    }

    public void setFlowControlSettingsMap(Map<ProjectSubscriptionName, FlowControlSettings> flowControlSettingsMap) {
        this.flowControlSettingsMap = flowControlSettingsMap;
    }

    public void setGlobalFlowControlSettings(FlowControlSettings flowControlSettings) {
        this.globalFlowControlSettings = flowControlSettings;
    }

    public void setRetrySettingsMap(Map<ProjectSubscriptionName, RetrySettings> retrySettingsMap) {
        this.retrySettingsMap = retrySettingsMap;
    }

    public void setUniverseDomain(String universeDomain) {
        this.universeDomain = universeDomain;
    }

    public void setGlobalRetrySettings(RetrySettings retrySettings) {
        this.globalRetrySettings = retrySettings;
    }

    private boolean shouldAddToHealthCheck(String subscriptionName) {
        if (this.healthTrackerRegistry == null) {
            return false;
        }
        ProjectSubscriptionName projectSubscriptionName = PubSubSubscriptionUtils.toProjectSubscriptionName(subscriptionName, this.projectId);
        return !this.healthTrackerRegistry.isTracked(projectSubscriptionName);
    }
}

