/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.api;

public abstract class CircuitBreaker {
    private CircuitBreaker() {
    }

    public static CircuitBreaker none() {
        return NamedCircuitBreaker.NONE;
    }

    public static CircuitBreaker perNode() {
        return NamedCircuitBreaker.PER_NODE;
    }

    public static CircuitBreaker perService() {
        return NamedCircuitBreaker.PER_SERVICE;
    }

    public static CircuitBreaker identifiedBy(String string) {
        return new CircuitBreakerId(string);
    }

    public static final class CircuitBreakerId
    extends CircuitBreaker {
        private final String id;

        private CircuitBreakerId(String string) {
            this.id = string;
        }

        public String id() {
            return this.id;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            CircuitBreakerId circuitBreakerId = (CircuitBreakerId)object;
            return this.id.equals(circuitBreakerId.id);
        }

        public int hashCode() {
            return this.id.hashCode();
        }

        public String toString() {
            return "CircuitBreakerId{id='" + this.id + '\'' + '}';
        }
    }

    public static final class NamedCircuitBreaker
    extends CircuitBreaker {
        public static final CircuitBreaker NONE = new NamedCircuitBreaker("NONE");
        public static final CircuitBreaker PER_NODE = new NamedCircuitBreaker("PER_NODE");
        public static final CircuitBreaker PER_SERVICE = new NamedCircuitBreaker("PER_SERVICE");
        private final String name;

        private NamedCircuitBreaker(String string) {
            this.name = string;
        }

        public String name() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            NamedCircuitBreaker namedCircuitBreaker = (NamedCircuitBreaker)object;
            return this.name.equals(namedCircuitBreaker.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "NamedCircuitBreaker{name='" + this.name + '\'' + '}';
        }
    }
}

