/*
 * Decompiled with CFR 0.152.
 */
package com.lightbend.lagom.javadsl.api;

import akka.NotUsed;
import akka.util.ByteString;
import com.lightbend.lagom.javadsl.api.CircuitBreaker;
import com.lightbend.lagom.javadsl.api.ServiceAcl;
import com.lightbend.lagom.javadsl.api.broker.Topic;
import com.lightbend.lagom.javadsl.api.deser.ExceptionSerializer;
import com.lightbend.lagom.javadsl.api.deser.MessageSerializer;
import com.lightbend.lagom.javadsl.api.deser.MessageSerializers;
import com.lightbend.lagom.javadsl.api.deser.PathParamSerializer;
import com.lightbend.lagom.javadsl.api.deser.SerializerFactory;
import com.lightbend.lagom.javadsl.api.security.UserAgentHeaderFilter;
import com.lightbend.lagom.javadsl.api.transport.HeaderFilter;
import com.lightbend.lagom.javadsl.api.transport.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.Optional;
import org.pcollections.HashTreePMap;
import org.pcollections.PMap;
import org.pcollections.PSequence;
import org.pcollections.TreePVector;

public final class Descriptor {
    private final String name;
    private final PSequence<Call<?, ?>> calls;
    private final PMap<Type, PathParamSerializer<?>> pathParamSerializers;
    private final PMap<Type, MessageSerializer<?, ?>> messageSerializers;
    private final SerializerFactory serializerFactory;
    private final ExceptionSerializer exceptionSerializer;
    private final boolean autoAcl;
    private final PSequence<ServiceAcl> acls;
    private final HeaderFilter headerFilter;
    private final boolean locatableService;
    private final CircuitBreaker circuitBreaker;
    private final PSequence<TopicCall<?>> topicCalls;

    Descriptor(String string) {
        this(string, (PSequence<Call<?, ?>>)TreePVector.empty(), (PMap<Type, PathParamSerializer<?>>)HashTreePMap.empty(), (PMap<Type, MessageSerializer<?, ?>>)HashTreePMap.empty(), SerializerFactory.DEFAULT, ExceptionSerializer.DEFAULT, false, (PSequence<ServiceAcl>)TreePVector.empty(), new UserAgentHeaderFilter(), true, CircuitBreaker.perNode(), (PSequence<TopicCall<?>>)TreePVector.empty());
    }

    Descriptor(String string, PSequence<Call<?, ?>> pSequence, PMap<Type, PathParamSerializer<?>> pMap, PMap<Type, MessageSerializer<?, ?>> pMap2, SerializerFactory serializerFactory, ExceptionSerializer exceptionSerializer, boolean bl, PSequence<ServiceAcl> pSequence2, HeaderFilter headerFilter, boolean bl2, CircuitBreaker circuitBreaker, PSequence<TopicCall<?>> pSequence3) {
        this.name = string;
        this.calls = pSequence;
        this.pathParamSerializers = pMap;
        this.messageSerializers = pMap2;
        this.serializerFactory = serializerFactory;
        this.exceptionSerializer = exceptionSerializer;
        this.autoAcl = bl;
        this.acls = pSequence2;
        this.headerFilter = headerFilter;
        this.locatableService = bl2;
        this.circuitBreaker = circuitBreaker;
        this.topicCalls = pSequence3;
    }

    public String name() {
        return this.name;
    }

    public PSequence<Call<?, ?>> calls() {
        return this.calls;
    }

    public PMap<Type, PathParamSerializer<?>> pathParamSerializers() {
        return this.pathParamSerializers;
    }

    public PMap<Type, MessageSerializer<?, ?>> messageSerializers() {
        return this.messageSerializers;
    }

    public SerializerFactory serializerFactory() {
        return this.serializerFactory;
    }

    public ExceptionSerializer exceptionSerializer() {
        return this.exceptionSerializer;
    }

    public boolean autoAcl() {
        return this.autoAcl;
    }

    public PSequence<ServiceAcl> acls() {
        return this.acls;
    }

    public HeaderFilter headerFilter() {
        return this.headerFilter;
    }

    public boolean locatableService() {
        return this.locatableService;
    }

    public CircuitBreaker circuitBreaker() {
        return this.circuitBreaker;
    }

    public PSequence<TopicCall<?>> topicCalls() {
        return this.topicCalls;
    }

    public <T> Descriptor withPathParamSerializer(Class<T> clazz, PathParamSerializer<T> pathParamSerializer) {
        return this.withPathParamSerializer((Type)clazz, (PathParamSerializer<?>)pathParamSerializer);
    }

    public Descriptor withPathParamSerializer(Type type, PathParamSerializer<?> pathParamSerializer) {
        return this.replaceAllPathParamSerializers(this.pathParamSerializers.plus((Object)type, pathParamSerializer));
    }

    public <T> Descriptor withMessageSerializer(Class<T> clazz, MessageSerializer<T, ?> messageSerializer) {
        return this.withMessageSerializer((Type)clazz, (MessageSerializer<?, ?>)messageSerializer);
    }

    public Descriptor withMessageSerializer(Type type, MessageSerializer<?, ?> messageSerializer) {
        return this.replaceAllMessageSerializers(this.messageSerializers.plus((Object)type, messageSerializer));
    }

    public Descriptor withCalls(Call<?, ?> ... callArray) {
        return this.replaceAllCalls(this.calls.plusAll(Arrays.asList(callArray)));
    }

    public Descriptor replaceAllCalls(PSequence<Call<?, ?>> pSequence) {
        return new Descriptor(this.name, pSequence, this.pathParamSerializers, this.messageSerializers, this.serializerFactory, this.exceptionSerializer, this.autoAcl, this.acls, this.headerFilter, this.locatableService, this.circuitBreaker, this.topicCalls);
    }

    public Descriptor replaceAllPathParamSerializers(PMap<Type, PathParamSerializer<?>> pMap) {
        return new Descriptor(this.name, this.calls, pMap, this.messageSerializers, this.serializerFactory, this.exceptionSerializer, this.autoAcl, this.acls, this.headerFilter, this.locatableService, this.circuitBreaker, this.topicCalls);
    }

    public Descriptor replaceAllMessageSerializers(PMap<Type, MessageSerializer<?, ?>> pMap) {
        return new Descriptor(this.name, this.calls, this.pathParamSerializers, pMap, this.serializerFactory, this.exceptionSerializer, this.autoAcl, this.acls, this.headerFilter, this.locatableService, this.circuitBreaker, this.topicCalls);
    }

    public Descriptor replaceAllTopicCalls(PSequence<TopicCall<?>> pSequence) {
        return new Descriptor(this.name, this.calls, this.pathParamSerializers, this.messageSerializers, this.serializerFactory, this.exceptionSerializer, this.autoAcl, this.acls, this.headerFilter, this.locatableService, this.circuitBreaker, pSequence);
    }

    public Descriptor withExceptionSerializer(ExceptionSerializer exceptionSerializer) {
        return new Descriptor(this.name, this.calls, this.pathParamSerializers, this.messageSerializers, this.serializerFactory, exceptionSerializer, this.autoAcl, this.acls, this.headerFilter, this.locatableService, this.circuitBreaker, this.topicCalls);
    }

    public Descriptor withSerializerFactory(SerializerFactory serializerFactory) {
        return new Descriptor(this.name, this.calls, this.pathParamSerializers, this.messageSerializers, serializerFactory, this.exceptionSerializer, this.autoAcl, this.acls, this.headerFilter, this.locatableService, this.circuitBreaker, this.topicCalls);
    }

    public Descriptor withAutoAcl(boolean bl) {
        return new Descriptor(this.name, this.calls, this.pathParamSerializers, this.messageSerializers, this.serializerFactory, this.exceptionSerializer, bl, this.acls, this.headerFilter, this.locatableService, this.circuitBreaker, this.topicCalls);
    }

    public Descriptor withServiceAcls(ServiceAcl ... serviceAclArray) {
        return this.replaceAllAcls((PSequence<ServiceAcl>)this.acls.plusAll(Arrays.asList(serviceAclArray)));
    }

    public Descriptor replaceAllAcls(PSequence<ServiceAcl> pSequence) {
        return new Descriptor(this.name, this.calls, this.pathParamSerializers, this.messageSerializers, this.serializerFactory, this.exceptionSerializer, this.autoAcl, pSequence, this.headerFilter, this.locatableService, this.circuitBreaker, this.topicCalls);
    }

    public Descriptor withHeaderFilter(HeaderFilter headerFilter) {
        return new Descriptor(this.name, this.calls, this.pathParamSerializers, this.messageSerializers, this.serializerFactory, this.exceptionSerializer, this.autoAcl, this.acls, headerFilter, this.locatableService, this.circuitBreaker, this.topicCalls);
    }

    public Descriptor withLocatableService(boolean bl) {
        return new Descriptor(this.name, this.calls, this.pathParamSerializers, this.messageSerializers, this.serializerFactory, this.exceptionSerializer, this.autoAcl, this.acls, this.headerFilter, bl, this.circuitBreaker, this.topicCalls);
    }

    public Descriptor withCircuitBreaker(CircuitBreaker circuitBreaker) {
        return new Descriptor(this.name, this.calls, this.pathParamSerializers, this.messageSerializers, this.serializerFactory, this.exceptionSerializer, this.autoAcl, this.acls, this.headerFilter, this.locatableService, circuitBreaker, this.topicCalls);
    }

    @Deprecated
    public Descriptor publishing(TopicCall<?> ... topicCallArray) {
        return this.withTopics(topicCallArray);
    }

    public Descriptor withTopics(TopicCall<?> ... topicCallArray) {
        return new Descriptor(this.name, this.calls, this.pathParamSerializers, this.messageSerializers, this.serializerFactory, this.exceptionSerializer, this.autoAcl, this.acls, this.headerFilter, this.locatableService, this.circuitBreaker, this.topicCalls.plusAll(Arrays.asList(topicCallArray)));
    }

    public static final class Properties<Message> {
        private final PMap<Property<?, ?>, Object> properties;

        Properties(PMap<Property<?, ?>, Object> pMap) {
            this.properties = pMap;
        }

        public <T> T getValueOf(Property<Message, T> property) {
            return (T)this.properties.get(property);
        }

        public <T> Properties<Message> withProperty(Property<Message, T> property, T t) {
            return new Properties<Message>(this.properties.plus(property, t));
        }

        public static final class Property<Message, T> {
            private final Class<T> valueClass;
            private final String name;

            public Property(Class<T> clazz, String string) {
                this.valueClass = clazz;
                this.name = string;
            }

            public Class<T> valueClass() {
                return this.valueClass;
            }

            public String name() {
                return this.name;
            }

            public boolean equals(Object object) {
                if (this == object) {
                    return true;
                }
                if (object == null || this.getClass() != object.getClass()) {
                    return false;
                }
                Property property = (Property)object;
                if (!this.valueClass.equals(property.valueClass)) {
                    return false;
                }
                return this.name.equals(property.name);
            }

            public int hashCode() {
                int n = this.valueClass.hashCode();
                n = 31 * n + this.name.hashCode();
                return n;
            }

            public String toString() {
                return "Property{valueClass=" + this.valueClass + ", name='" + this.name + '\'' + '}';
            }
        }
    }

    public static final class TopicCall<Message> {
        private final Topic.TopicId topicId;
        private final TopicHolder topicHolder;
        private final MessageSerializer<Message, ByteString> messageSerializer;
        private final Properties<Message> properties;

        TopicCall(Topic.TopicId topicId, TopicHolder topicHolder, MessageSerializer<Message, ByteString> messageSerializer, Properties<Message> properties) {
            this.topicId = topicId;
            this.topicHolder = topicHolder;
            this.messageSerializer = messageSerializer;
            this.properties = properties;
        }

        public Topic.TopicId topicId() {
            return this.topicId;
        }

        public TopicHolder topicHolder() {
            return this.topicHolder;
        }

        public MessageSerializer<Message, ByteString> messageSerializer() {
            return this.messageSerializer;
        }

        public Properties<Message> properties() {
            return this.properties;
        }

        public TopicCall<Message> withTopicHolder(TopicHolder topicHolder) {
            return new TopicCall<Message>(this.topicId, topicHolder, this.messageSerializer, this.properties);
        }

        public TopicCall<Message> withMessageSerializer(MessageSerializer<Message, ByteString> messageSerializer) {
            return new TopicCall<Message>(this.topicId, this.topicHolder, messageSerializer, this.properties);
        }

        public <T> TopicCall<Message> withProperty(Properties.Property<Message, T> property, T t) {
            return new TopicCall<Message>(this.topicId, this.topicHolder, this.messageSerializer, this.properties.withProperty(property, t));
        }
    }

    public static final class NamedCallId
    extends CallId {
        private final String name;

        public NamedCallId(String string) {
            this.name = string;
        }

        public String name() {
            return this.name;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof NamedCallId)) {
                return false;
            }
            NamedCallId namedCallId = (NamedCallId)object;
            return this.name.equals(namedCallId.name);
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public String toString() {
            return "NamedCallId{name='" + this.name + '\'' + '}';
        }
    }

    public static final class PathCallId
    extends CallId {
        private final String pathPattern;

        public PathCallId(String string) {
            this.pathPattern = string;
        }

        public String pathPattern() {
            return this.pathPattern;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof PathCallId)) {
                return false;
            }
            PathCallId pathCallId = (PathCallId)object;
            return this.pathPattern.equals(pathCallId.pathPattern);
        }

        public int hashCode() {
            return this.pathPattern.hashCode();
        }

        public String toString() {
            return "PathCallId{pathPattern='" + this.pathPattern + '\'' + '}';
        }
    }

    public static final class RestCallId
    extends CallId {
        private final Method method;
        private final String pathPattern;

        public RestCallId(Method method, String string) {
            this.method = method;
            this.pathPattern = string;
        }

        public Method method() {
            return this.method;
        }

        public String pathPattern() {
            return this.pathPattern;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof RestCallId)) {
                return false;
            }
            RestCallId restCallId = (RestCallId)object;
            if (!this.method.equals(restCallId.method)) {
                return false;
            }
            return this.pathPattern.equals(restCallId.pathPattern);
        }

        public int hashCode() {
            int n = this.method.hashCode();
            n = 31 * n + this.pathPattern.hashCode();
            return n;
        }

        public String toString() {
            return "RestCallId{method=" + this.method + ", pathPattern='" + this.pathPattern + '\'' + '}';
        }
    }

    public static abstract class CallId {
        private CallId() {
        }
    }

    public static final class Call<Request, Response> {
        public static final Call<NotUsed, NotUsed> NONE = new Call(new NamedCallId("none"), new ServiceCallHolder(){}, MessageSerializers.NOT_USED, MessageSerializers.NOT_USED, Optional.empty(), Optional.empty());
        private final CallId callId;
        private final ServiceCallHolder serviceCallHolder;
        private final MessageSerializer<Request, ?> requestSerializer;
        private final MessageSerializer<Response, ?> responseSerializer;
        private final Optional<CircuitBreaker> circuitBreaker;
        private final Optional<Boolean> autoAcl;

        Call(CallId callId, ServiceCallHolder serviceCallHolder, MessageSerializer<Request, ?> messageSerializer, MessageSerializer<Response, ?> messageSerializer2, Optional<CircuitBreaker> optional, Optional<Boolean> optional2) {
            this.callId = callId;
            this.serviceCallHolder = serviceCallHolder;
            this.requestSerializer = messageSerializer;
            this.responseSerializer = messageSerializer2;
            this.circuitBreaker = optional;
            this.autoAcl = optional2;
        }

        public CallId callId() {
            return this.callId;
        }

        public ServiceCallHolder serviceCallHolder() {
            return this.serviceCallHolder;
        }

        public MessageSerializer<Request, ?> requestSerializer() {
            return this.requestSerializer;
        }

        public MessageSerializer<Response, ?> responseSerializer() {
            return this.responseSerializer;
        }

        public Optional<CircuitBreaker> circuitBreaker() {
            return this.circuitBreaker;
        }

        public Optional<Boolean> autoAcl() {
            return this.autoAcl;
        }

        public Call<Request, Response> withCallId(CallId callId) {
            return new Call<Request, Response>(callId, this.serviceCallHolder, this.requestSerializer, this.responseSerializer, this.circuitBreaker, this.autoAcl);
        }

        public Call<Request, Response> withServiceCallHolder(ServiceCallHolder serviceCallHolder) {
            return new Call<Request, Response>(this.callId, serviceCallHolder, this.requestSerializer, this.responseSerializer, this.circuitBreaker, this.autoAcl);
        }

        public Call<Request, Response> withRequestSerializer(MessageSerializer<Request, ?> messageSerializer) {
            return new Call<Request, Response>(this.callId, this.serviceCallHolder, messageSerializer, this.responseSerializer, this.circuitBreaker, this.autoAcl);
        }

        public Call<Request, Response> withResponseSerializer(MessageSerializer<Response, ?> messageSerializer) {
            return new Call<Request, Response>(this.callId, this.serviceCallHolder, this.requestSerializer, messageSerializer, this.circuitBreaker, this.autoAcl);
        }

        public Call<Request, Response> withCircuitBreaker(CircuitBreaker circuitBreaker) {
            return new Call<Request, Response>(this.callId, this.serviceCallHolder, this.requestSerializer, this.responseSerializer, Optional.of(circuitBreaker), this.autoAcl);
        }

        public Call<Request, Response> withAutoAcl(boolean bl) {
            return new Call<Request, Response>(this.callId, this.serviceCallHolder, this.requestSerializer, this.responseSerializer, this.circuitBreaker, Optional.of(bl));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Call)) {
                return false;
            }
            Call call = (Call)object;
            return this.callId.equals(call.callId);
        }

        public int hashCode() {
            return this.callId.hashCode();
        }

        public String toString() {
            return "Call{callId=" + this.callId + ", serviceCallHolder=" + this.serviceCallHolder + ", requestSerializer=" + this.requestSerializer + ", responseSerializer=" + this.responseSerializer + ", circuitBreaker=" + this.circuitBreaker + ", autoAcl=" + this.autoAcl + '}';
        }
    }

    public static interface TopicHolder {
    }

    public static interface ServiceCallHolder {
    }
}

