/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.entitystore;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.Iterables;
import com.netflix.astyanax.ColumnListMutation;
import com.netflix.astyanax.MutationBatch;
import com.netflix.astyanax.entitystore.CompositeColumnEntityMapper;
import com.netflix.astyanax.entitystore.FieldMapper;
import com.netflix.astyanax.entitystore.MappingUtils;
import com.netflix.astyanax.entitystore.TTL;
import com.netflix.astyanax.model.Column;
import com.netflix.astyanax.model.ColumnFamily;
import com.netflix.astyanax.model.ColumnList;
import com.netflix.astyanax.query.ColumnPredicate;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.util.Collection;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.OneToMany;
import javax.persistence.PersistenceException;

public class CompositeEntityMapper<T, K> {
    private final Class<T> clazz;
    private final Integer ttl;
    private final Method ttlMethod;
    private final FieldMapper<?> idMapper;
    private final String entityName;
    private final CompositeColumnEntityMapper embeddedEntityMapper;

    public CompositeEntityMapper(Class<T> clazz, Integer ttl) {
        TTL ttlAnnotation;
        this.clazz = clazz;
        Entity entityAnnotation = clazz.getAnnotation(Entity.class);
        if (entityAnnotation == null) {
            throw new IllegalArgumentException("class is NOT annotated with @java.persistence.Entity: " + clazz.getName());
        }
        this.entityName = MappingUtils.getEntityName(entityAnnotation, clazz);
        Integer tmpTtlValue = ttl;
        if (tmpTtlValue == null && (ttlAnnotation = clazz.getAnnotation(TTL.class)) != null) {
            int ttlAnnotationValue = ttlAnnotation.value();
            Preconditions.checkState((ttlAnnotationValue > 0 ? 1 : 0) != 0, (Object)("cannot define non-positive value for TTL annotation at class level: " + ttlAnnotationValue));
            tmpTtlValue = ttlAnnotationValue;
        }
        this.ttl = tmpTtlValue;
        Method tmpTtlMethod = null;
        for (Method method : this.clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(TTL.class)) continue;
            Preconditions.checkState((tmpTtlMethod == null ? 1 : 0) != 0, (Object)("Duplicate TTL method annotation on " + method.getName()));
            tmpTtlMethod = method;
            tmpTtlMethod.setAccessible(true);
        }
        this.ttlMethod = tmpTtlMethod;
        Field[] declaredFields = clazz.getDeclaredFields();
        FieldMapper tempIdMapper = null;
        CompositeColumnEntityMapper tempEmbeddedEntityMapper = null;
        for (Field field : declaredFields) {
            OneToMany oneToManyAnnotation;
            Id idAnnotation = field.getAnnotation(Id.class);
            if (idAnnotation != null) {
                Preconditions.checkArgument((tempIdMapper == null ? 1 : 0) != 0, (Object)"there are multiple fields with @Id annotation");
                field.setAccessible(true);
                tempIdMapper = new FieldMapper(field);
            }
            if ((oneToManyAnnotation = field.getAnnotation(OneToMany.class)) == null) continue;
            Preconditions.checkArgument((tempEmbeddedEntityMapper == null ? 1 : 0) != 0, (Object)"there are multiple fields with @OneToMany annotation");
            tempEmbeddedEntityMapper = new CompositeColumnEntityMapper(field);
        }
        Preconditions.checkNotNull(tempIdMapper, (Object)"there are no field with @Id annotation");
        this.idMapper = tempIdMapper;
        Preconditions.checkNotNull(tempEmbeddedEntityMapper, (Object)"there are no embedded entities using @OneToMany annotation");
        this.embeddedEntityMapper = tempEmbeddedEntityMapper;
    }

    public void fillMutationBatch(MutationBatch mb, ColumnFamily<K, ByteBuffer> columnFamily, T entity) {
        try {
            ColumnListMutation clm = mb.withRow(columnFamily, this.idMapper.getValue(entity));
            clm.setDefaultTtl(this.getTtl(entity));
            this.embeddedEntityMapper.fillMutationBatch((ColumnListMutation<ByteBuffer>)clm, entity);
        }
        catch (Exception e) {
            throw new PersistenceException("failed to fill mutation batch", (Throwable)e);
        }
    }

    void fillMutationBatchForDelete(MutationBatch mb, ColumnFamily<K, ByteBuffer> columnFamily, T entity) {
        try {
            ByteBuffer id = this.idMapper.toByteBuffer(entity);
            ColumnListMutation clm = mb.withRow(columnFamily, this.idMapper.getValue(entity));
            this.embeddedEntityMapper.fillMutationBatchForDelete((ColumnListMutation<ByteBuffer>)clm, entity);
        }
        catch (Exception e) {
            throw new PersistenceException("failed to fill mutation batch", (Throwable)e);
        }
    }

    private Integer getTtl(T entity) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        Integer retTtl = this.ttl;
        if (this.ttlMethod != null) {
            Object retobj = this.ttlMethod.invoke(entity, new Object[0]);
            retTtl = (Integer)retobj;
        }
        return retTtl;
    }

    public T constructEntity(K id, ColumnList<ByteBuffer> cl) {
        try {
            T entity = this.clazz.newInstance();
            this.idMapper.setValue(entity, id);
            this.embeddedEntityMapper.setField(entity, cl);
            return entity;
        }
        catch (Exception e) {
            throw new PersistenceException("failed to construct entity", (Throwable)e);
        }
    }

    public T constructEntityFromCql(T candidateEntity, ColumnList<ByteBuffer> cl) {
        try {
            Object id = this.idMapper.fromByteBuffer(((Column)Iterables.getFirst(cl, null)).getByteBufferValue());
            T entity = candidateEntity != null && this.idMapper.getValue(candidateEntity).equals(id) ? candidateEntity : this.clazz.newInstance();
            this.idMapper.setValue(entity, id);
            this.embeddedEntityMapper.setFieldFromCql(entity, cl);
            return entity;
        }
        catch (Exception e) {
            throw new PersistenceException("failed to construct entity", (Throwable)e);
        }
    }

    public String getComparatorType() {
        return this.embeddedEntityMapper.getComparatorType();
    }

    public K getEntityId(T entity) throws Exception {
        return (K)this.idMapper.getValue(entity);
    }

    @VisibleForTesting
    Field getId() {
        return this.idMapper.field;
    }

    public String getEntityName() {
        return this.entityName;
    }

    public String toString() {
        return String.format("EntityMapper(%s)", this.clazz);
    }

    public String getKeyType() {
        return this.idMapper.getSerializer().getComparatorType().getClassName();
    }

    public String getValueType() {
        return this.embeddedEntityMapper.getValueType();
    }

    public ByteBuffer[] getQueryEndpoints(Collection<ColumnPredicate> predicates) {
        return this.embeddedEntityMapper.getQueryEndpoints(predicates);
    }
}

