/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.entitystore;

import com.netflix.astyanax.Serializer;
import com.netflix.astyanax.entitystore.MappingUtils;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import javax.persistence.Column;

public class FieldMapper<T> {
    final Serializer<T> serializer;
    final Field field;
    final String name;

    public FieldMapper(Field field) {
        this.serializer = MappingUtils.getSerializerForField(field);
        this.field = field;
        Column columnAnnotation = field.getAnnotation(Column.class);
        this.name = columnAnnotation == null || columnAnnotation.name().isEmpty() ? field.getName() : columnAnnotation.name();
    }

    public Serializer<?> getSerializer() {
        return this.serializer;
    }

    public ByteBuffer toByteBuffer(Object entity) throws IllegalArgumentException, IllegalAccessException {
        return this.serializer.toByteBuffer(this.getValue(entity));
    }

    public T fromByteBuffer(ByteBuffer buffer) {
        return (T)this.serializer.fromByteBuffer(buffer);
    }

    public T getValue(Object entity) throws IllegalArgumentException, IllegalAccessException {
        return (T)this.field.get(entity);
    }

    public ByteBuffer valueToByteBuffer(Object value) {
        return this.serializer.toByteBuffer(value);
    }

    public void setValue(Object entity, Object value) throws IllegalArgumentException, IllegalAccessException {
        this.field.set(entity, value);
    }

    public void setField(Object entity, ByteBuffer buffer) throws IllegalArgumentException, IllegalAccessException {
        this.field.set(entity, this.fromByteBuffer(buffer));
    }

    public String getName() {
        return this.name;
    }
}

