/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.astyanax.entitystore;

import com.google.common.collect.Lists;
import com.netflix.astyanax.model.Equality;
import com.netflix.astyanax.query.ColumnPredicate;
import java.util.Collection;
import java.util.List;

public abstract class NativeQuery<T, K> {
    protected List<K> ids = Lists.newArrayList();
    protected Collection<Object> columnNames;
    protected List<ColumnPredicate> predicates;
    protected Integer columnLimit = null;

    public NativeIdQuery whereId() {
        return new NativeIdQuery();
    }

    public NativeColumnQuery whereColumn(String name) {
        return new NativeColumnQuery(name);
    }

    public NativeQuery<T, K> limit(int columnLimit) {
        this.columnLimit = columnLimit;
        return this;
    }

    private NativeQuery<T, K> addPredicate(ColumnPredicate predicate) {
        if (this.predicates == null) {
            this.predicates = Lists.newArrayList();
        }
        this.predicates.add(predicate);
        return this;
    }

    public abstract T getSingleResult() throws Exception;

    public abstract Collection<T> getResultSet() throws Exception;

    public class NativeColumnQuery {
        private ColumnPredicate predicate = new ColumnPredicate();

        public NativeColumnQuery(String name) {
            this.predicate.setName(name);
        }

        public NativeQuery<T, K> in(Collection<Object> names) {
            NativeQuery.this.columnNames = names;
            return NativeQuery.this;
        }

        public NativeQuery<T, K> equal(Object value) {
            return NativeQuery.this.addPredicate(this.predicate.setOp(Equality.EQUAL).setValue(value));
        }

        public NativeQuery<T, K> greaterThan(Object value) {
            return NativeQuery.this.addPredicate(this.predicate.setOp(Equality.GREATER_THAN).setValue(value));
        }

        public NativeQuery<T, K> lessThan(Object value) {
            return NativeQuery.this.addPredicate(this.predicate.setOp(Equality.LESS_THAN).setValue(value));
        }

        public NativeQuery<T, K> greaterThanEqual(Object value) {
            return NativeQuery.this.addPredicate(this.predicate.setOp(Equality.GREATER_THAN_EQUALS).setValue(value));
        }

        public NativeQuery<T, K> lessThanEqual(Object value) {
            return NativeQuery.this.addPredicate(this.predicate.setOp(Equality.LESS_THAN_EQUALS).setValue(value));
        }
    }

    public class NativeIdQuery {
        public NativeQuery<T, K> in(Collection<K> keys) {
            NativeQuery.this.ids.addAll(keys);
            return NativeQuery.this;
        }

        public NativeQuery<T, K> in(K ... keys) {
            NativeQuery.this.ids.addAll(Lists.newArrayList((Object[])keys));
            return NativeQuery.this;
        }

        public NativeQuery<T, K> equal(K key) {
            NativeQuery.this.ids.add(key);
            return NativeQuery.this;
        }
    }
}

