/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.metrics3;

import com.codahale.metrics.Meter;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import java.util.Collections;

class MetricsCounter
implements Counter {
    private final Clock clock;
    private final Id id;
    private final Meter impl;

    MetricsCounter(Clock clock, Id id, Meter impl) {
        this.clock = clock;
        this.id = id;
        this.impl = impl;
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        return false;
    }

    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        long v = this.impl.getCount();
        return Collections.singleton(new Measurement(this.id, now, (double)v));
    }

    public void increment() {
        this.impl.mark();
    }

    public void increment(long amount) {
        this.impl.mark(amount);
    }

    public long count() {
        return this.impl.getCount();
    }
}

