/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.metrics3;

import com.codahale.metrics.MetricRegistry;
import com.netflix.spectator.api.AbstractRegistry;
import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Counter;
import com.netflix.spectator.api.DistributionSummary;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Tag;
import com.netflix.spectator.api.Timer;
import com.netflix.spectator.metrics3.MetricsCounter;
import com.netflix.spectator.metrics3.MetricsDistributionSummary;
import com.netflix.spectator.metrics3.MetricsTimer;

public class MetricsRegistry
extends AbstractRegistry {
    private final MetricRegistry impl;

    public MetricsRegistry() {
        this(Clock.SYSTEM, new MetricRegistry());
    }

    public MetricsRegistry(Clock clock, MetricRegistry impl) {
        super(clock);
        this.impl = impl;
    }

    private String toMetricName(Id id) {
        StringBuilder buf = new StringBuilder();
        buf.append(id.name());
        for (Tag t : id.tags()) {
            buf.append(t.key()).append("-").append(t.value());
        }
        return buf.toString();
    }

    protected Counter newCounter(Id id) {
        String name = this.toMetricName(id);
        return new MetricsCounter(this.clock(), id, this.impl.meter(name));
    }

    protected DistributionSummary newDistributionSummary(Id id) {
        String name = this.toMetricName(id);
        return new MetricsDistributionSummary(this.clock(), id, this.impl.histogram(name));
    }

    protected Timer newTimer(Id id) {
        String name = this.toMetricName(id);
        return new MetricsTimer(this.clock(), id, this.impl.timer(name));
    }
}

