/*
 * Decompiled with CFR 0.152.
 */
package com.netflix.spectator.metrics3;

import com.netflix.spectator.api.Clock;
import com.netflix.spectator.api.Id;
import com.netflix.spectator.api.Measurement;
import com.netflix.spectator.api.Timer;
import java.util.Collections;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;

class MetricsTimer
implements Timer {
    private final Clock clock;
    private final Id id;
    private final com.codahale.metrics.Timer impl;
    private final AtomicLong totalTime;

    MetricsTimer(Clock clock, Id id, com.codahale.metrics.Timer impl) {
        this.clock = clock;
        this.id = id;
        this.impl = impl;
        this.totalTime = new AtomicLong(0L);
    }

    public Id id() {
        return this.id;
    }

    public boolean hasExpired() {
        return false;
    }

    public void record(long amount, TimeUnit unit) {
        this.impl.update(amount, unit);
    }

    public Iterable<Measurement> measure() {
        long now = this.clock.wallTime();
        return Collections.singleton(new Measurement(this.id, now, this.impl.getMeanRate()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T> T record(Callable<T> f) throws Exception {
        long s = this.clock.monotonicTime();
        try {
            T t = f.call();
            return t;
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void record(Runnable f) {
        long s = this.clock.monotonicTime();
        try {
            f.run();
        }
        finally {
            long e = this.clock.monotonicTime();
            this.record(e - s, TimeUnit.NANOSECONDS);
        }
    }

    public long count() {
        return this.impl.getCount();
    }

    public long totalTime() {
        return this.totalTime.get();
    }
}

