/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring;

import com.github.f4b6a3.ulid.Ulid;
import com.google.gson.GsonBuilder;
import com.google.gson.annotations.JsonAdapter;
import com.redis.om.spring.annotations.Document;
import com.redis.om.spring.annotations.DocumentScore;
import com.redis.om.spring.annotations.GeoIndexed;
import com.redis.om.spring.annotations.Indexed;
import com.redis.om.spring.annotations.NumericIndexed;
import com.redis.om.spring.annotations.SchemaFieldType;
import com.redis.om.spring.annotations.Searchable;
import com.redis.om.spring.annotations.SerializationHint;
import com.redis.om.spring.annotations.TagIndexed;
import com.redis.om.spring.annotations.TextIndexed;
import com.redis.om.spring.annotations.VectorIndexed;
import com.redis.om.spring.ops.RedisModulesOperations;
import com.redis.om.spring.ops.search.SearchOperations;
import com.redis.om.spring.repository.query.QueryUtils;
import com.redis.om.spring.serialization.gson.EnumTypeAdapter;
import com.redis.om.spring.util.ObjectUtils;
import java.lang.reflect.Field;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.context.ApplicationContext;
import org.springframework.data.annotation.Reference;
import org.springframework.data.geo.Point;
import org.springframework.data.redis.core.RedisHash;
import org.springframework.data.redis.core.TimeToLive;
import org.springframework.data.redis.core.convert.KeyspaceConfiguration;
import org.springframework.data.redis.core.mapping.RedisMappingContext;
import org.springframework.data.redis.core.mapping.RedisPersistentEntity;
import org.springframework.data.util.TypeInformation;
import org.springframework.stereotype.Component;
import org.springframework.util.ClassUtils;
import redis.clients.jedis.search.FTCreateParams;
import redis.clients.jedis.search.FieldName;
import redis.clients.jedis.search.IndexDataType;
import redis.clients.jedis.search.schemafields.GeoField;
import redis.clients.jedis.search.schemafields.NumericField;
import redis.clients.jedis.search.schemafields.SchemaField;
import redis.clients.jedis.search.schemafields.TagField;
import redis.clients.jedis.search.schemafields.TextField;
import redis.clients.jedis.search.schemafields.VectorField;

@Component
public class RediSearchIndexer {
    private final Map<String, Class<?>> keyspaceToEntityClass = new ConcurrentHashMap();
    private final Map<Class<?>, String> entityClassToKeySpace = new ConcurrentHashMap();
    private final List<Class<?>> indexedEntityClasses = new ArrayList();
    private final Map<Class<?>, List<SchemaField>> entityClassToSchema = new ConcurrentHashMap();
    private static final Log logger = LogFactory.getLog(RediSearchIndexer.class);
    private final ApplicationContext ac;
    private final RedisModulesOperations<String> rmo;
    private final RedisMappingContext mappingContext;
    private final GsonBuilder gsonBuilder;
    private static final String SKIPPING_INDEX_CREATION = "Skipping index creation for %s because %s";

    public RediSearchIndexer(ApplicationContext ac, GsonBuilder gsonBuilder) {
        this.ac = ac;
        this.rmo = (RedisModulesOperations)ac.getBean("redisModulesOperations");
        this.mappingContext = (RedisMappingContext)ac.getBean("keyValueMappingContext");
        this.gsonBuilder = gsonBuilder;
    }

    public void createIndicesFor(Class<?> cls) {
        HashSet<BeanDefinition> beanDefs = new HashSet<BeanDefinition>(ObjectUtils.getBeanDefinitionsFor(this.ac, cls));
        logger.info((Object)String.format("Found %s @%s annotated Beans...", beanDefs.size(), cls.getSimpleName()));
        for (BeanDefinition beanDef : beanDefs) {
            try {
                Class<?> cl = Class.forName(beanDef.getBeanClassName());
                logger.info((Object)String.format("Creating index for %s annotated Entity...", cl.getSimpleName()));
                this.createIndexFor(cl);
            }
            catch (ClassNotFoundException e) {
                logger.warn((Object)String.format(SKIPPING_INDEX_CREATION, beanDef.getBeanClassName(), e.getMessage()));
            }
        }
    }

    public void createIndexFor(Class<?> cl) {
        Optional<IndexDataType> maybeType = this.determineIndexTarget(cl);
        if (!maybeType.isPresent()) {
            return;
        }
        IndexDataType idxType = maybeType.get();
        boolean isDocument = idxType == IndexDataType.JSON;
        Optional<Document> document = isDocument ? Optional.of(cl.getAnnotation(Document.class)) : Optional.empty();
        Optional<RedisHash> hash = !isDocument ? Optional.of(cl.getAnnotation(RedisHash.class)) : Optional.empty();
        Object indexName = "";
        try {
            Optional<String> maybeEntityPrefix;
            indexName = cl.getName() + "Idx";
            logger.info((Object)String.format("Found @%s annotated class: %s", idxType, cl.getName()));
            List<Field> allClassFields = ObjectUtils.getDeclaredFieldsTransitively(cl);
            List<SchemaField> fields = this.processIndexedFields(allClassFields, isDocument);
            Optional<String> maybeScoreField = this.getDocumentScoreField(allClassFields, isDocument);
            this.createIndexedFieldForIdField(cl, fields, isDocument).ifPresent(fields::add);
            SearchOperations<String> opsForSearch = this.rmo.opsForSearch((String)indexName);
            FTCreateParams params = this.createIndexDefinition(cl, idxType);
            if (isDocument) {
                maybeEntityPrefix = document.map(Document::value).filter(org.apache.commons.lang3.ObjectUtils::isNotEmpty);
                maybeScoreField.ifPresent(arg_0 -> ((FTCreateParams)params).scoreField(arg_0));
            } else {
                maybeEntityPrefix = hash.map(RedisHash::value).filter(org.apache.commons.lang3.ObjectUtils::isNotEmpty);
            }
            Object entityPrefix = maybeEntityPrefix.orElse(this.getEntityPrefix(cl));
            entityPrefix = ((String)entityPrefix).endsWith(":") ? entityPrefix : (String)entityPrefix + ":";
            params.prefix(new String[]{entityPrefix});
            this.addKeySpaceMapping((String)entityPrefix, cl);
            this.updateTTLSettings(cl, (String)entityPrefix, isDocument, document, allClassFields);
            opsForSearch.createIndex(params, fields);
            this.entityClassToSchema.put(cl, fields);
        }
        catch (Exception e) {
            logger.warn((Object)String.format(SKIPPING_INDEX_CREATION, indexName, e.getMessage()));
        }
    }

    public void dropIndexAndDocumentsFor(Class<?> cl) {
        this.dropIndex(cl, true, false);
    }

    public void dropAndRecreateIndexFor(Class<?> cl) {
        this.dropIndex(cl, false, true);
    }

    public void dropIndexFor(Class<?> cl) {
        this.dropIndex(cl, false, false);
    }

    public Optional<String> getIndexName(String keyspace) {
        return this.getIndexName(this.keyspaceToEntityClass.get(this.getKeyspace(keyspace)));
    }

    public Optional<String> getIndexName(Class<?> entityClass) {
        if (entityClass != null && this.entityClassToKeySpace.containsKey(entityClass)) {
            return Optional.of(entityClass.getName() + "Idx");
        }
        return Optional.empty();
    }

    public void addKeySpaceMapping(String keyspace, Class<?> entityClass) {
        String key = this.getKeyspace(keyspace);
        this.keyspaceToEntityClass.put(key, entityClass);
        this.entityClassToKeySpace.put(entityClass, key);
        this.indexedEntityClasses.add(entityClass);
    }

    public void removeKeySpaceMapping(String keyspace, Class<?> entityClass) {
        String key = this.getKeyspace(keyspace);
        this.keyspaceToEntityClass.remove(key);
        this.entityClassToKeySpace.remove(entityClass);
        this.indexedEntityClasses.remove(entityClass);
    }

    public Class<?> getEntityClassForKeyspace(String keyspace) {
        return this.keyspaceToEntityClass.get(this.getKeyspace(keyspace));
    }

    public String getKeyspaceForEntityClass(Class<?> entityClass) {
        RedisPersistentEntity persistentEntity;
        Object keyspace = this.entityClassToKeySpace.get(entityClass);
        if (keyspace == null && (persistentEntity = (RedisPersistentEntity)this.mappingContext.getPersistentEntity(entityClass)) != null) {
            String entityKeySpace = persistentEntity.getKeySpace();
            keyspace = (entityKeySpace != null ? entityKeySpace : entityClass.getName()) + ":";
        }
        return keyspace;
    }

    public boolean indexExistsFor(Class<?> entityClass) {
        return this.indexedEntityClasses.contains(entityClass);
    }

    public List<SchemaField> getSchemaFor(Class<?> entityClass) {
        return this.entityClassToSchema.get(entityClass);
    }

    private List<SchemaField> findIndexFields(Field field, String prefix, boolean isDocument) {
        ArrayList<SchemaField> fields = new ArrayList<SchemaField>();
        if (field.isAnnotationPresent(Indexed.class)) {
            logger.info((Object)String.format("Found @Indexed annotation on field of type: %s", field.getType()));
            Indexed indexed = field.getAnnotation(Indexed.class);
            Class fieldType = ClassUtils.resolvePrimitiveIfNecessary(field.getType());
            if (field.isAnnotationPresent(Reference.class)) {
                logger.debug((Object)("\ud83e\udeb2Found @Reference field " + field.getName() + " in " + field.getDeclaringClass().getSimpleName()));
                this.createIndexedFieldForReferenceIdField(field, isDocument).ifPresent(fields::add);
            } else if (indexed.schemaFieldType() == SchemaFieldType.AUTODETECT) {
                if (CharSequence.class.isAssignableFrom(fieldType) || fieldType == Boolean.class || fieldType == UUID.class || fieldType == Ulid.class) {
                    fields.add(this.indexAsTagFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.separator(), indexed.arrayIndex(), indexed.alias()));
                } else if (fieldType.isEnum()) {
                    if (Objects.requireNonNull(indexed.serializationHint()) == SerializationHint.ORDINAL) {
                        fields.add((SchemaField)this.indexAsNumericFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.noindex(), indexed.alias()));
                        this.gsonBuilder.registerTypeAdapter((Type)fieldType, EnumTypeAdapter.of(fieldType));
                    } else {
                        fields.add(this.indexAsTagFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.separator(), indexed.arrayIndex(), indexed.alias()));
                    }
                } else if (Number.class.isAssignableFrom(fieldType) || fieldType == LocalDateTime.class || field.getType() == LocalDate.class || field.getType() == Date.class || field.getType() == Instant.class || field.getType() == OffsetDateTime.class) {
                    fields.add((SchemaField)this.indexAsNumericFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.noindex(), indexed.alias()));
                } else if (Set.class.isAssignableFrom(fieldType) || List.class.isAssignableFrom(fieldType)) {
                    Optional<Class<?>> maybeCollectionType = ObjectUtils.getCollectionElementClass(field);
                    if (maybeCollectionType.isPresent()) {
                        Class<?> collectionType = maybeCollectionType.get();
                        if (CharSequence.class.isAssignableFrom(collectionType) || collectionType == Boolean.class) {
                            fields.add(this.indexAsTagFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.separator(), indexed.arrayIndex(), indexed.alias()));
                        } else if (isDocument) {
                            if (Number.class.isAssignableFrom(collectionType)) {
                                fields.add((SchemaField)this.indexAsNumericFieldFor(field, true, prefix, indexed.sortable(), indexed.noindex(), indexed.alias()));
                            } else if (collectionType == Point.class) {
                                fields.add((SchemaField)this.indexAsGeoFieldFor(field, true, prefix, indexed.alias()));
                            } else if (collectionType == UUID.class || collectionType == Ulid.class) {
                                fields.add(this.indexAsTagFieldFor(field, true, prefix, indexed.sortable(), indexed.separator(), 0, indexed.alias()));
                            } else {
                                logger.debug((Object)String.format("Found nested field on field of type: %s", field.getType()));
                                fields.addAll(this.indexAsNestedFieldFor(field, prefix));
                            }
                        }
                    } else {
                        logger.debug((Object)String.format("Could not determine the type of elements in the collection %s in entity %s", field.getName(), field.getDeclaringClass().getSimpleName()));
                    }
                } else if (fieldType == Point.class) {
                    fields.add((SchemaField)this.indexAsGeoFieldFor(field, isDocument, prefix, indexed.alias()));
                } else {
                    for (Field subfield : ObjectUtils.getDeclaredFieldsTransitively(field.getType())) {
                        String subfieldPrefix = prefix == null || prefix.isBlank() ? field.getName() : String.join((CharSequence)".", prefix, field.getName());
                        fields.addAll(this.findIndexFields(subfield, subfieldPrefix, isDocument));
                    }
                }
            } else {
                switch (indexed.schemaFieldType()) {
                    case TAG: {
                        fields.add(this.indexAsTagFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.separator(), indexed.arrayIndex(), indexed.alias()));
                        break;
                    }
                    case NUMERIC: {
                        fields.add((SchemaField)this.indexAsNumericFieldFor(field, isDocument, prefix, indexed.sortable(), indexed.noindex(), indexed.alias()));
                        break;
                    }
                    case GEO: {
                        fields.add((SchemaField)this.indexAsGeoFieldFor(field, true, prefix, indexed.alias()));
                        break;
                    }
                    case VECTOR: {
                        fields.add((SchemaField)this.indexAsVectorFieldFor(field, isDocument, prefix, indexed));
                        break;
                    }
                    case NESTED: {
                        for (Field subfield : ObjectUtils.getDeclaredFieldsTransitively(field.getType())) {
                            String subfieldPrefix = prefix == null || prefix.isBlank() ? field.getName() : String.join((CharSequence)".", prefix, field.getName());
                            fields.addAll(this.findIndexFields(subfield, subfieldPrefix, isDocument));
                        }
                        break;
                    }
                }
            }
        } else if (field.isAnnotationPresent(Searchable.class)) {
            logger.info((Object)String.format("Found @Searchable annotation on field of type: %s", field.getType()));
            Searchable searchable = field.getAnnotation(Searchable.class);
            fields.add((SchemaField)this.indexAsTextFieldFor(field, isDocument, prefix, searchable));
        } else if (field.isAnnotationPresent(TextIndexed.class)) {
            TextIndexed ti = field.getAnnotation(TextIndexed.class);
            fields.add((SchemaField)this.indexAsTextFieldFor(field, isDocument, prefix, ti));
        } else if (field.isAnnotationPresent(TagIndexed.class)) {
            TagIndexed ti = field.getAnnotation(TagIndexed.class);
            fields.add((SchemaField)this.indexAsTagFieldFor(field, isDocument, prefix, ti));
        } else if (field.isAnnotationPresent(GeoIndexed.class)) {
            GeoIndexed gi = field.getAnnotation(GeoIndexed.class);
            fields.add((SchemaField)this.indexAsGeoFieldFor(field, isDocument, prefix, gi));
        } else if (field.isAnnotationPresent(NumericIndexed.class)) {
            NumericIndexed ni = field.getAnnotation(NumericIndexed.class);
            fields.add((SchemaField)this.indexAsNumericFieldFor(field, isDocument, prefix, ni));
        } else if (field.isAnnotationPresent(VectorIndexed.class)) {
            VectorIndexed vi = field.getAnnotation(VectorIndexed.class);
            fields.add((SchemaField)this.indexAsVectorFieldFor(field, isDocument, prefix, vi));
        }
        return fields;
    }

    private TagField indexAsTagFieldFor(Field field, boolean isDocument, String prefix, TagIndexed ti) {
        TypeInformation typeInfo = TypeInformation.of(field.getType());
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        String fieldPostfix = isDocument && typeInfo.isCollectionLike() && !field.isAnnotationPresent(JsonAdapter.class) ? "[*]" : "";
        String name = fieldPrefix + field.getName() + fieldPostfix;
        String alias = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.alias()) ? QueryUtils.searchIndexFieldAliasFor(field, prefix) : ti.alias();
        FieldName fieldName = FieldName.of((String)name);
        fieldName = fieldName.as(alias);
        return this.getTagField(fieldName, ti.separator(), false);
    }

    private VectorField indexAsVectorFieldFor(Field field, boolean isDocument, String prefix, Indexed indexed) {
        TypeInformation typeInfo = TypeInformation.of(field.getType());
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        String fieldName = fieldPrefix + field.getName();
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("TYPE", indexed.type().toString());
        attributes.put("DIM", indexed.dimension());
        attributes.put("DISTANCE_METRIC", (Object)indexed.distanceMetric());
        if (indexed.initialCapacity() > 0) {
            attributes.put("INITIAL_CAP", indexed.initialCapacity());
        }
        if (indexed.algorithm().equals((Object)VectorField.VectorAlgorithm.FLAT) && indexed.blockSize() > 0) {
            attributes.put("BLOCK_SIZE", indexed.blockSize());
        }
        if (indexed.algorithm().equals((Object)VectorField.VectorAlgorithm.HNSW)) {
            attributes.put("M", indexed.m());
            attributes.put("EF_CONSTRUCTION", indexed.efConstruction());
            if (indexed.efRuntime() != 10) {
                attributes.put("EF_RUNTIME", indexed.efRuntime());
            }
            if (indexed.epsilon() != 0.01) {
                attributes.put("EPSILON", indexed.epsilon());
            }
        }
        String alias = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)indexed.alias()) ? QueryUtils.searchIndexFieldAliasFor(field, prefix) : indexed.alias();
        VectorField vectorField = new VectorField(fieldName, indexed.algorithm(), attributes);
        vectorField.as(alias);
        return vectorField;
    }

    private VectorField indexAsVectorFieldFor(Field field, boolean isDocument, String prefix, VectorIndexed vi) {
        TypeInformation typeInfo = TypeInformation.of(field.getType());
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        String fieldPostfix = isDocument && typeInfo.isCollectionLike() && !field.isAnnotationPresent(JsonAdapter.class) ? "[*]" : "";
        String fieldName = fieldPrefix + field.getName() + fieldPostfix;
        HashMap<String, Object> attributes = new HashMap<String, Object>();
        attributes.put("TYPE", vi.type().toString());
        attributes.put("DIM", vi.dimension());
        attributes.put("DISTANCE_METRIC", (Object)vi.distanceMetric());
        if (vi.initialCapacity() > 0) {
            attributes.put("INITIAL_CAP", vi.initialCapacity());
        }
        if (vi.algorithm().equals((Object)VectorField.VectorAlgorithm.FLAT) && vi.blockSize() > 0) {
            attributes.put("BLOCK_SIZE", vi.blockSize());
        }
        if (vi.algorithm().equals((Object)VectorField.VectorAlgorithm.HNSW)) {
            attributes.put("M", vi.m());
            attributes.put("EF_CONSTRUCTION", vi.efConstruction());
            if (vi.efRuntime() != 10) {
                attributes.put("EF_RUNTIME", vi.efRuntime());
            }
            if (vi.epsilon() != 0.01) {
                attributes.put("EPSILON", vi.epsilon());
            }
        }
        String alias = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)vi.alias()) ? QueryUtils.searchIndexFieldAliasFor(field, prefix) : vi.alias();
        VectorField vectorField = new VectorField(fieldName, vi.algorithm(), attributes);
        vectorField.as(alias);
        return vectorField;
    }

    private SchemaField indexAsTagFieldFor(Field field, boolean isDocument, String prefix, boolean sortable, String separator, int arrayIndex, String annotationAlias) {
        TypeInformation typeInfo = TypeInformation.of(field.getType());
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        Object index = arrayIndex != Integer.MIN_VALUE ? ".[" + arrayIndex + "]" : "[*]";
        String fieldPostfix = isDocument && typeInfo.isCollectionLike() && !field.isAnnotationPresent(JsonAdapter.class) ? index : "";
        String name = fieldPrefix + field.getName() + fieldPostfix;
        String alias = annotationAlias == null || annotationAlias.isBlank() ? QueryUtils.searchIndexFieldAliasFor(field, prefix) : annotationAlias;
        FieldName fieldName = FieldName.of((String)name);
        fieldName = fieldName.as(alias);
        return this.getTagField(fieldName, separator, sortable);
    }

    private TextField indexAsTextFieldFor(Field field, boolean isDocument, String prefix, TextIndexed ti) {
        FieldName fieldName = this.getFieldName(field, isDocument, prefix, org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.alias()) ? QueryUtils.searchIndexFieldAliasFor(field, prefix) : ti.alias());
        String phonetic = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.phonetic()) ? null : ti.phonetic();
        return this.getTextField(fieldName, ti.weight(), ti.sortable(), ti.nostem(), ti.noindex(), phonetic);
    }

    private TextField indexAsTextFieldFor(Field field, boolean isDocument, String prefix, Searchable ti) {
        FieldName fieldName = this.getFieldName(field, isDocument, prefix, org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.alias()) ? QueryUtils.searchIndexFieldAliasFor(field, prefix) : ti.alias());
        String phonetic = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ti.phonetic()) ? null : ti.phonetic();
        return this.getTextField(fieldName, ti.weight(), ti.sortable(), ti.nostem(), ti.noindex(), phonetic);
    }

    private GeoField indexAsGeoFieldFor(Field field, boolean isDocument, String prefix, GeoIndexed gi) {
        FieldName fieldName = this.getFieldName(field, isDocument, prefix, org.apache.commons.lang3.ObjectUtils.isEmpty((Object)gi.alias()) ? QueryUtils.searchIndexFieldAliasFor(field, prefix) : gi.alias());
        return GeoField.of((FieldName)fieldName);
    }

    private NumericField indexAsNumericFieldFor(Field field, boolean isDocument, String prefix, NumericIndexed ni) {
        FieldName fieldName = this.getFieldName(field, isDocument, prefix, org.apache.commons.lang3.ObjectUtils.isEmpty((Object)ni.alias()) ? QueryUtils.searchIndexFieldAliasFor(field, prefix) : ni.alias());
        return NumericField.of((FieldName)fieldName);
    }

    private NumericField indexAsNumericFieldFor(Field field, boolean isDocument, String prefix, boolean sortable, boolean noIndex, String annotationAlias) {
        String alias = annotationAlias == null || annotationAlias.isBlank() ? QueryUtils.searchIndexFieldAliasFor(field, prefix) : annotationAlias;
        FieldName fieldName = this.getFieldName(field, isDocument, prefix, alias);
        NumericField num = NumericField.of((FieldName)fieldName);
        if (sortable) {
            num.sortable();
        }
        if (noIndex) {
            num.noIndex();
        }
        return num;
    }

    private GeoField indexAsGeoFieldFor(Field field, boolean isDocument, String prefix, String annotationAlias) {
        String alias = annotationAlias == null || annotationAlias.isBlank() ? QueryUtils.searchIndexFieldAliasFor(field, prefix) : annotationAlias;
        FieldName fieldName = this.getFieldName(field, isDocument, prefix, alias);
        return GeoField.of((FieldName)fieldName);
    }

    private List<SchemaField> indexAsNestedFieldFor(Field field, String prefix) {
        String fieldPrefix = this.getFieldPrefix(prefix, true);
        return this.getNestedField(fieldPrefix, field, prefix, null);
    }

    private FieldName getFieldName(Field field, boolean isDocument, String prefix, String alias) {
        String fieldPrefix = this.getFieldPrefix(prefix, isDocument);
        String name = fieldPrefix + field.getName();
        FieldName fieldName = FieldName.of((String)name);
        fieldName = fieldName.as(alias);
        return fieldName;
    }

    private List<SchemaField> getNestedField(String fieldPrefix, Field field, String prefix, List<SchemaField> fieldList) {
        Type genericType;
        if (fieldList == null) {
            fieldList = new ArrayList<SchemaField>();
        }
        if ((genericType = field.getGenericType()) instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)genericType;
            Class actualTypeArgument = (Class)pt.getActualTypeArguments()[0];
            List<Field> subDeclaredFields = ObjectUtils.getDeclaredFieldsTransitively(actualTypeArgument);
            Object tempPrefix = "";
            prefix = prefix == null ? field.getName() : (String)prefix + "." + field.getName();
            for (Field subField : subDeclaredFields) {
                FieldName fieldName;
                String suffix;
                Optional<Class<?>> maybeCollectionType = ObjectUtils.getCollectionElementClass(subField);
                String string = suffix = maybeCollectionType.isPresent() && (CharSequence.class.isAssignableFrom(maybeCollectionType.get()) || maybeCollectionType.get() == Boolean.class) ? "[*]" : "";
                if (subField.isAnnotationPresent(TagIndexed.class)) {
                    TagIndexed ti = subField.getAnnotation(TagIndexed.class);
                    tempPrefix = field.getName() + "[0:].";
                    fieldName = FieldName.of((String)(fieldPrefix + (String)tempPrefix + subField.getName() + suffix));
                    fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(subField, (String)prefix));
                    logger.info((Object)String.format("Creating nested relationships: %s -> %s", field.getName(), subField.getName()));
                    fieldList.add((SchemaField)this.getTagField(fieldName, ti.separator(), false));
                    continue;
                }
                if (subField.isAnnotationPresent(Indexed.class)) {
                    boolean subFieldIsTagField;
                    boolean bl = subFieldIsTagField = subField.isAnnotationPresent(Indexed.class) && (CharSequence.class.isAssignableFrom(subField.getType()) || subField.getType() == Boolean.class || subField.getType() == UUID.class || maybeCollectionType.isPresent() && (CharSequence.class.isAssignableFrom(maybeCollectionType.get()) || maybeCollectionType.get() == Boolean.class));
                    if (subFieldIsTagField) {
                        Indexed indexed = subField.getAnnotation(Indexed.class);
                        tempPrefix = field.getName() + "[0:].";
                        FieldName fieldName2 = FieldName.of((String)(fieldPrefix + (String)tempPrefix + subField.getName() + suffix));
                        fieldName2 = fieldName2.as(QueryUtils.searchIndexFieldAliasFor(subField, (String)prefix));
                        logger.info((Object)String.format("Creating nested relationships: %s -> %s", field.getName(), subField.getName()));
                        fieldList.add((SchemaField)this.getTagField(fieldName2, indexed.separator(), false));
                        continue;
                    }
                    if (Number.class.isAssignableFrom(subField.getType()) || subField.getType() == LocalDateTime.class || subField.getType() == LocalDate.class || subField.getType() == Date.class) {
                        fieldName = FieldName.of((String)(fieldPrefix + (String)tempPrefix + subField.getName() + suffix));
                        fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(subField, (String)prefix));
                        logger.info((Object)String.format("Creating nested relationships: %s -> %s", field.getName(), subField.getName()));
                        fieldList.add((SchemaField)NumericField.of((FieldName)fieldName));
                    }
                } else if (subField.isAnnotationPresent(Searchable.class)) {
                    Searchable searchable = subField.getAnnotation(Searchable.class);
                    tempPrefix = field.getName() + "[0:].";
                    fieldName = FieldName.of((String)(fieldPrefix + (String)tempPrefix + subField.getName() + suffix));
                    fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(subField, (String)prefix));
                    logger.info((Object)String.format("Creating TEXT nested relationships: %s -> %s", field.getName(), subField.getName()));
                    String phonetic = org.apache.commons.lang3.ObjectUtils.isEmpty((Object)searchable.phonetic()) ? null : searchable.phonetic();
                    fieldList.add((SchemaField)this.getTextField(fieldName, searchable.weight(), searchable.sortable(), searchable.nostem(), searchable.noindex(), phonetic));
                    continue;
                }
                if (!subField.isAnnotationPresent(Indexed.class)) continue;
                this.getNestedField(fieldPrefix + (String)tempPrefix, subField, (String)prefix, fieldList);
            }
        }
        return fieldList;
    }

    private TagField getTagField(FieldName fieldName, String separator, boolean sortable) {
        TagField tag = TagField.of((FieldName)fieldName);
        if (separator != null) {
            if (separator.length() != 1) {
                throw new IllegalArgumentException("Separator '" + separator + "' is not of length 1.");
            }
            tag.separator(separator.charAt(0));
        }
        return tag.sortable();
    }

    private TextField getTextField(FieldName fieldName, double weight, boolean sortable, boolean noStem, boolean noIndex, String phonetic) {
        TextField text = TextField.of((FieldName)fieldName);
        text.weight(weight);
        if (sortable) {
            text.sortable();
        }
        if (noStem) {
            text.noStem();
        }
        if (noIndex) {
            text.noIndex();
        }
        if (phonetic != null) {
            text.phonetic(phonetic);
        }
        return text;
    }

    private String getEntityPrefix(Class<?> cl) {
        String entityPrefix = cl.getName() + ":";
        if (this.mappingContext.hasPersistentEntityFor(cl)) {
            RedisPersistentEntity persistentEntity = (RedisPersistentEntity)this.mappingContext.getRequiredPersistentEntity(cl);
            entityPrefix = persistentEntity.getKeySpace() != null ? persistentEntity.getKeySpace() + ":" : entityPrefix;
            logger.info((Object)String.format("Using entity prefix '%s' as keyspace for type : %s", entityPrefix, cl));
        }
        return entityPrefix;
    }

    private void dropIndex(Class<?> cl, boolean dropDocuments, boolean recreateIndex) {
        String indexName = this.generateIndexName(cl);
        try {
            SearchOperations<String> opsForSearch = this.rmo.opsForSearch(indexName);
            if (dropDocuments) {
                opsForSearch.dropIndexAndDocuments();
            } else {
                opsForSearch.dropIndex();
            }
            String entityPrefix = this.generateEntityPrefix(cl);
            this.removeKeySpaceMapping(entityPrefix, cl);
            if (recreateIndex) {
                this.createIndexFor(cl);
            }
        }
        catch (Exception e) {
            logger.warn((Object)String.format(SKIPPING_INDEX_CREATION, indexName, e.getMessage()));
        }
    }

    private String generateIndexName(Class<?> cl) {
        String indexName = cl.getName() + "Idx";
        logger.info((Object)String.format("Dropping index @%s for class: %s", indexName, cl.getName()));
        return indexName;
    }

    private String generateEntityPrefix(Class<?> cl) {
        RedisHash hash;
        String entityPrefix = this.getEntityPrefix(cl);
        if (cl.isAnnotationPresent(Document.class)) {
            Document document = cl.getAnnotation(Document.class);
            if (org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)document.value())) {
                entityPrefix = document.value();
            }
        } else if (cl.isAnnotationPresent(RedisHash.class) && org.apache.commons.lang3.ObjectUtils.isNotEmpty((Object)(hash = cl.getAnnotation(RedisHash.class)).value())) {
            entityPrefix = hash.value();
        }
        return entityPrefix;
    }

    private Optional<IndexDataType> determineIndexTarget(Class<?> cl) {
        if (cl.isAnnotationPresent(Document.class)) {
            return Optional.of(IndexDataType.JSON);
        }
        if (cl.isAnnotationPresent(RedisHash.class)) {
            return Optional.of(IndexDataType.HASH);
        }
        return Optional.empty();
    }

    private List<SchemaField> processIndexedFields(List<Field> allClassFields, boolean isDocument) {
        ArrayList<SchemaField> fields = new ArrayList<SchemaField>();
        for (Field field : allClassFields) {
            fields.addAll(this.findIndexFields(field, null, isDocument));
        }
        return fields;
    }

    private Optional<String> getDocumentScoreField(List<Field> allClassFields, boolean isDocument) {
        return allClassFields.stream().filter(field -> field.isAnnotationPresent(DocumentScore.class)).findFirst().map(field -> (isDocument ? "$." : "") + field.getName());
    }

    private Optional<SchemaField> createIndexedFieldForIdField(Class<?> cl, List<SchemaField> fields, boolean isDocument) {
        Field idField;
        Optional<Object> result = Optional.empty();
        Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(cl);
        if (maybeIdField.isPresent() && !(idField = maybeIdField.get()).isAnnotationPresent(Indexed.class) && !idField.isAnnotationPresent(Searchable.class) && !idField.isAnnotationPresent(TagIndexed.class) && !idField.isAnnotationPresent(TextIndexed.class) && fields.stream().noneMatch(f -> f.getName().equals(idField.getName()))) {
            String cls;
            Class primitive;
            Class idClass = idField.getType();
            if (idField.getType().isPrimitive() && (primitive = ClassUtils.resolvePrimitiveClassName((String)(cls = ObjectUtils.getTargetClassName(idClass.getName())))) != null) {
                idClass = ClassUtils.resolvePrimitiveIfNecessary((Class)primitive);
            }
            result = Number.class.isAssignableFrom(idClass) ? Optional.of(this.indexAsNumericFieldFor(maybeIdField.get(), isDocument, "", true, false, null)) : Optional.of(this.indexAsTagFieldFor(maybeIdField.get(), isDocument, "", false, "|", Integer.MIN_VALUE, null));
        }
        return result;
    }

    private Optional<SchemaField> createIndexedFieldForReferenceIdField(Field referenceIdField, boolean isDocument) {
        Optional<Object> result;
        String fieldPrefix = this.getFieldPrefix("", isDocument);
        FieldName fieldName = FieldName.of((String)(fieldPrefix + referenceIdField.getName()));
        fieldName = fieldName.as(QueryUtils.searchIndexFieldAliasFor(referenceIdField, ""));
        Class<?> refClass = referenceIdField.getType();
        Optional<Field> maybeIdField = ObjectUtils.getIdFieldForEntityClass(refClass);
        if (maybeIdField.isPresent()) {
            String cls;
            Class primitive;
            Field idField = maybeIdField.get();
            Class idClass = idField.getType();
            if (idField.getType().isPrimitive() && (primitive = ClassUtils.resolvePrimitiveClassName((String)(cls = ObjectUtils.getTargetClassName(idClass.getName())))) != null) {
                idClass = ClassUtils.resolvePrimitiveIfNecessary((Class)primitive);
            }
            result = Number.class.isAssignableFrom(idClass) ? Optional.of(NumericField.of((FieldName)fieldName).sortable()) : Optional.of(TagField.of((FieldName)fieldName).separator('|').sortable());
        } else {
            result = Optional.of(TagField.of((FieldName)fieldName).separator('|').sortable());
        }
        return result;
    }

    private FTCreateParams createIndexDefinition(Class<?> cl, IndexDataType idxType) {
        FTCreateParams params = FTCreateParams.createParams();
        params.on(idxType);
        if (cl.isAnnotationPresent(Document.class)) {
            Document document = cl.getAnnotation(Document.class);
            Optional.ofNullable(document.filter()).filter(org.apache.commons.lang3.ObjectUtils::isNotEmpty).ifPresent(arg_0 -> ((FTCreateParams)params).filter(arg_0));
            Optional.ofNullable(document.language()).filter(org.apache.commons.lang3.ObjectUtils::isNotEmpty).ifPresent(lang -> params.language(lang.getValue()));
            Optional.ofNullable(document.languageField()).filter(org.apache.commons.lang3.ObjectUtils::isNotEmpty).ifPresent(arg_0 -> ((FTCreateParams)params).languageField(arg_0));
            params.score(document.score());
        }
        return params;
    }

    private void updateTTLSettings(Class<?> cl, String entityPrefix, boolean isDocument, Optional<Document> document, List<Field> allClassFields) {
        if (isDocument) {
            KeyspaceConfiguration.KeyspaceSettings setting = new KeyspaceConfiguration.KeyspaceSettings(cl, entityPrefix);
            document.filter(doc -> doc.timeToLive() > 0L).ifPresent(doc -> setting.setTimeToLive(Long.valueOf(doc.timeToLive())));
            allClassFields.stream().filter(field -> field.isAnnotationPresent(TimeToLive.class)).findFirst().ifPresent(field -> setting.setTimeToLivePropertyName(field.getName()));
            this.mappingContext.getMappingConfiguration().getKeyspaceConfiguration().addKeyspaceSettings(setting);
        }
    }

    private String getKeyspace(String keyspace) {
        return keyspace.endsWith(":") ? keyspace : keyspace + ":";
    }

    private String getFieldPrefix(String prefix, boolean isDocument) {
        String chain = prefix == null || prefix.isBlank() ? "" : prefix + ".";
        return isDocument ? "$." + chain : chain;
    }
}

