/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.convert;

import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.ZoneId;
import org.springframework.core.convert.converter.Converter;
import org.springframework.data.convert.WritingConverter;
import org.springframework.stereotype.Component;

@Component
@WritingConverter
public class OffsetDateTimeToBytesConverter
implements Converter<OffsetDateTime, byte[]> {
    byte[] fromString(String source) {
        return source.getBytes(StandardCharsets.UTF_8);
    }

    public byte[] convert(OffsetDateTime source) {
        Instant instant = source.atZoneSameInstant(ZoneId.systemDefault()).toInstant();
        long timeInMillis = instant.toEpochMilli();
        return this.fromString(Long.toString(timeInMillis));
    }
}

