/*
 * Decompiled with CFR 0.152.
 */
package com.redis.om.spring.ops.pds;

import com.redis.om.spring.client.RedisModulesClient;
import com.redis.om.spring.ops.pds.CuckooFilterOperations;
import java.util.List;
import java.util.Map;
import redis.clients.jedis.bloom.CFInsertParams;
import redis.clients.jedis.bloom.CFReserveParams;

public class CuckooFilterOperationsImpl<K>
implements CuckooFilterOperations<K> {
    final RedisModulesClient client;

    public CuckooFilterOperationsImpl(RedisModulesClient client) {
        this.client = client;
    }

    @Override
    public void createFilter(String key, long capacity) {
        this.client.clientForCuckoo().cfReserve(key, capacity);
    }

    @Override
    public void createFilter(String key, long capacity, CFReserveParams reserveParams) {
        this.client.clientForCuckoo().cfReserve(key, capacity, reserveParams);
    }

    @Override
    public boolean add(String key, String item) {
        return this.client.clientForCuckoo().cfAdd(key, item);
    }

    @Override
    public boolean addNx(String key, String item) {
        return this.client.clientForCuckoo().cfAddNx(key, item);
    }

    @Override
    public List<Boolean> insert(String key, String ... items) {
        return this.client.clientForCuckoo().cfInsert(key, items);
    }

    @Override
    public List<Boolean> insert(String key, CFInsertParams insertParams, String ... items) {
        return this.client.clientForCuckoo().cfInsert(key, insertParams, items);
    }

    @Override
    public List<Boolean> insertNx(String key, String ... items) {
        return this.client.clientForCuckoo().cfInsertNx(key, items);
    }

    @Override
    public List<Boolean> insertNx(String key, CFInsertParams insertParams, String ... items) {
        return this.client.clientForCuckoo().cfInsertNx(key, insertParams, items);
    }

    @Override
    public boolean exists(String key, String item) {
        return this.client.clientForCuckoo().cfExists(key, item);
    }

    @Override
    public List<Boolean> exists(String key, String ... items) {
        return this.client.clientForCuckoo().cfMExists(key, items);
    }

    @Override
    public boolean delete(String key, String item) {
        return this.client.clientForCuckoo().cfDel(key, item);
    }

    @Override
    public long count(String key, String item) {
        return this.client.clientForCuckoo().cfCount(key, item);
    }

    @Override
    public Map.Entry<Long, byte[]> scanDump(String key, long iterator) {
        return this.client.clientForCuckoo().cfScanDump(key, iterator);
    }

    @Override
    public String loadChunk(String key, long iterator, byte[] data) {
        return this.client.clientForCuckoo().cfLoadChunk(key, iterator, data);
    }

    @Override
    public Map<String, Object> info(String key) {
        return this.client.clientForCuckoo().cfInfo(key);
    }
}

