/*
 * Decompiled with CFR 0.152.
 */
package com.saucelabs.selenium.client.embedded_rc;

import com.saucelabs.selenium.client.client.factory.SeleniumFactory;
import com.saucelabs.selenium.client.client.factory.spi.SeleniumFactorySPI;
import com.saucelabs.selenium.client.embedded_rc.SeleniumFilter;
import com.thoughtworks.selenium.Selenium;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import org.openqa.selenium.server.RemoteControlConfiguration;
import org.openqa.selenium.server.SeleniumServer;
import org.openqa.selenium.server.cli.RemoteControlLauncher;

public class EmbeddedRcSPIImpl
extends SeleniumFactorySPI {
    private static final String SCHEME = "embedded-rc:";
    private static final String JETTY_FORM_SIZE = "org.openqa.jetty.http.HttpRequest.maxFormContentSize";

    public Selenium createSelenium(SeleniumFactory factory, String browserURL) {
        SeleniumServer server;
        String uri = factory.getUri();
        if (!uri.startsWith(SCHEME)) {
            return null;
        }
        String browser = uri.substring(SCHEME.length());
        if (browser.length() == 0) {
            browser = this.getPlatformDefaultBrowser();
        }
        String[] args = this.getArguments(factory);
        RemoteControlConfiguration configuration = RemoteControlLauncher.parseLauncherOptions((String[])args);
        int port = this.allocateRandomPort();
        configuration.setPort(port);
        if (System.getProperty(JETTY_FORM_SIZE) == null) {
            System.setProperty(JETTY_FORM_SIZE, "0");
        }
        try {
            server = new SeleniumServer(Boolean.getBoolean("slowResources"), configuration);
            server.boot();
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Failed to start embedded RC", e);
        }
        SeleniumFactory f = factory.clone();
        Selenium base = f.setUri("http://localhost:" + port + "/" + browser).createSelenium(browserURL);
        return new SeleniumFilter(base){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void stop() {
                try {
                    super.stop();
                }
                finally {
                    server.stop();
                }
            }
        };
    }

    private String[] getArguments(SeleniumFactory factory) {
        Object ea = factory.getProperty("embedded_args");
        if (ea instanceof String) {
            return ((String)ea).split(" +");
        }
        String[] args = (String[])ea;
        if (args == null) {
            args = new String[]{};
        }
        return args;
    }

    private int allocateRandomPort() {
        try {
            ServerSocket ss = new ServerSocket(0);
            int port = ss.getLocalPort();
            ss.close();
            return port;
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Failed to allocate a random port", e);
        }
    }

    protected String getPlatformDefaultBrowser() {
        if (File.pathSeparatorChar == ';') {
            return "*iexplore";
        }
        String osName = System.getProperty("os.name");
        if (osName.contains("Mac") || osName.startsWith("Darwin")) {
            return "*safari";
        }
        return "*firefox";
    }
}

