/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.pipeline.intermediate.standard.internal;

import com.speedment.jpastreamer.pipeline.intermediate.IntIntermediateOperationFactory;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperation;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationType;
import com.speedment.jpastreamer.pipeline.intermediate.standard.internal.StandardIntermediateOperation;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.IntConsumer;
import java.util.function.IntFunction;
import java.util.function.IntPredicate;
import java.util.function.IntToDoubleFunction;
import java.util.function.IntToLongFunction;
import java.util.function.IntUnaryOperator;
import java.util.function.UnaryOperator;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class InternalIntIntermediateOperationFactory
implements IntIntermediateOperationFactory {
    private static final Function<IntStream, IntStream> SORTED_FUNCTION = IntStream::sorted;
    private static final IntermediateOperation<IntStream, IntStream> SORTED = new StandardIntermediateOperation<IntStream, IntStream>(IntermediateOperationType.SORTED, IntStream.class, IntStream.class, SORTED_FUNCTION, new Object[0]);
    private static final Function<IntStream, IntStream> DISTINCT_FUNCTION = IntStream::distinct;
    private static final IntermediateOperation<IntStream, IntStream> DISTINCT = new StandardIntermediateOperation<IntStream, IntStream>(IntermediateOperationType.DISTINCT, IntStream.class, IntStream.class, DISTINCT_FUNCTION, new Object[0]);
    private static final Function<IntStream, Stream<Integer>> BOXED_FUNCTION = IntStream::boxed;
    private static final IntermediateOperation<IntStream, Stream<Integer>> BOXED = new StandardIntermediateOperation<IntStream, Stream<Integer>>(IntermediateOperationType.BOXED, IntStream.class, Stream.class, BOXED_FUNCTION, new Object[0]);
    private static final Function<IntStream, LongStream> AS_LONG_STREAM_FUNCTION = IntStream::asLongStream;
    private static final IntermediateOperation<IntStream, LongStream> AS_LONG_STREAM = new StandardIntermediateOperation<IntStream, LongStream>(IntermediateOperationType.AS, IntStream.class, LongStream.class, AS_LONG_STREAM_FUNCTION, new Object[0]);
    private static final Function<IntStream, DoubleStream> AS_DOUBLE_STREAM_FUNCTION = IntStream::asDoubleStream;
    private static final IntermediateOperation<IntStream, DoubleStream> AS_DOUBLE_STREAM = new StandardIntermediateOperation<IntStream, DoubleStream>(IntermediateOperationType.AS, IntStream.class, DoubleStream.class, AS_DOUBLE_STREAM_FUNCTION, new Object[0]);

    public IntermediateOperation<IntStream, IntStream> createFilter(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        UnaryOperator function = s -> s.filter(predicate);
        return new StandardIntermediateOperation<IntStream, IntStream>(IntermediateOperationType.FILTER, IntStream.class, IntStream.class, function, predicate);
    }

    public IntermediateOperation<IntStream, IntStream> createMap(IntUnaryOperator mapper) {
        Objects.requireNonNull(mapper);
        UnaryOperator function = s -> s.map(mapper);
        return new StandardIntermediateOperation<IntStream, IntStream>(IntermediateOperationType.MAP_TO_SAME, IntStream.class, IntStream.class, function, mapper);
    }

    public <U> IntermediateOperation<IntStream, Stream<U>> createMapToObj(IntFunction<? extends U> mapper) {
        Objects.requireNonNull(mapper);
        Function<IntStream, Stream> function = s -> s.mapToObj(mapper);
        return new StandardIntermediateOperation<IntStream, Stream<U>>(IntermediateOperationType.MAP_TO, IntStream.class, Stream.class, function, mapper);
    }

    public IntermediateOperation<IntStream, LongStream> createMapToLong(IntToLongFunction mapper) {
        Objects.requireNonNull(mapper);
        Function<IntStream, LongStream> function = s -> s.mapToLong(mapper);
        return new StandardIntermediateOperation<IntStream, LongStream>(IntermediateOperationType.MAP_TO, IntStream.class, LongStream.class, function, mapper);
    }

    public IntermediateOperation<IntStream, DoubleStream> createMapToDouble(IntToDoubleFunction mapper) {
        Objects.requireNonNull(mapper);
        Function<IntStream, DoubleStream> function = s -> s.mapToDouble(mapper);
        return new StandardIntermediateOperation<IntStream, DoubleStream>(IntermediateOperationType.MAP_TO, IntStream.class, DoubleStream.class, function, mapper);
    }

    public IntermediateOperation<IntStream, IntStream> createFlatMap(IntFunction<? extends IntStream> mapper) {
        Objects.requireNonNull(mapper);
        UnaryOperator function = s -> s.flatMap(mapper);
        return new StandardIntermediateOperation<IntStream, IntStream>(IntermediateOperationType.FLAT_MAP_TO_SAME, IntStream.class, IntStream.class, function, mapper);
    }

    public IntermediateOperation<IntStream, IntStream> acquireDistinct() {
        return DISTINCT;
    }

    public IntermediateOperation<IntStream, IntStream> acquireSorted() {
        return SORTED;
    }

    public IntermediateOperation<IntStream, IntStream> createPeek(IntConsumer action) {
        Objects.requireNonNull(action);
        UnaryOperator function = s -> s.peek(action);
        return new StandardIntermediateOperation<IntStream, IntStream>(IntermediateOperationType.PEEK, IntStream.class, IntStream.class, function, action);
    }

    public IntermediateOperation<IntStream, IntStream> createLimit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException(Long.toString(maxSize));
        }
        UnaryOperator function = s -> s.limit(maxSize);
        return new StandardIntermediateOperation<IntStream, IntStream>(IntermediateOperationType.LIMIT, IntStream.class, IntStream.class, function, maxSize);
    }

    public IntermediateOperation<IntStream, IntStream> createSkip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(Long.toString(n));
        }
        UnaryOperator function = s -> s.skip(n);
        return new StandardIntermediateOperation<IntStream, IntStream>(IntermediateOperationType.SKIP, IntStream.class, IntStream.class, function, n);
    }

    public IntermediateOperation<IntStream, IntStream> createTakeWhile(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        UnaryOperator function = s -> s.takeWhile(predicate);
        return new StandardIntermediateOperation<IntStream, IntStream>(IntermediateOperationType.TAKE_WHILE, IntStream.class, IntStream.class, function, predicate);
    }

    public IntermediateOperation<IntStream, IntStream> createDropWhile(IntPredicate predicate) {
        Objects.requireNonNull(predicate);
        UnaryOperator function = s -> s.dropWhile(predicate);
        return new StandardIntermediateOperation<IntStream, IntStream>(IntermediateOperationType.DROP_WHILE, IntStream.class, IntStream.class, function, predicate);
    }

    public IntermediateOperation<IntStream, Stream<Integer>> acquireBoxed() {
        return BOXED;
    }

    public IntermediateOperation<IntStream, LongStream> acquireAsLongStream() {
        return AS_LONG_STREAM;
    }

    public IntermediateOperation<IntStream, DoubleStream> acquireAsDoubleStream() {
        return AS_DOUBLE_STREAM;
    }
}

