/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.pipeline.intermediate.standard.internal;

import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperation;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationFactory;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationType;
import com.speedment.jpastreamer.pipeline.intermediate.standard.internal.StandardIntermediateOperation;
import com.speedment.jpastreamer.pipeline.intermediate.standard.internal.TypeUtil;
import java.util.Comparator;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToDoubleFunction;
import java.util.function.ToIntFunction;
import java.util.function.ToLongFunction;
import java.util.function.UnaryOperator;
import java.util.stream.DoubleStream;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import java.util.stream.Stream;

public final class InternalIntermediateOperationFactory
implements IntermediateOperationFactory {
    private static final Function<Stream<Object>, Stream<Object>> SORTED_FUNCTION = Stream::sorted;
    private static final IntermediateOperation<Stream<Object>, Stream<Object>> SORTED = new StandardIntermediateOperation<Stream<Object>, Stream<Object>>(IntermediateOperationType.SORTED, Stream.class, Stream.class, SORTED_FUNCTION, new Object[0]);
    private static final Function<Stream<Object>, Stream<Object>> DISTINCT_FUNCTION = Stream::distinct;
    private static final IntermediateOperation<Stream<Object>, Stream<Object>> DISTINCT = new StandardIntermediateOperation<Stream<Object>, Stream<Object>>(IntermediateOperationType.DISTINCT, Stream.class, Stream.class, DISTINCT_FUNCTION, new Object[0]);

    public <T> IntermediateOperation<Stream<T>, Stream<T>> createFilter(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        UnaryOperator function = s -> s.filter(predicate);
        return new StandardIntermediateOperation<Stream<T>, Stream<T>>(IntermediateOperationType.FILTER, Stream.class, Stream.class, function, predicate);
    }

    public <T, R> IntermediateOperation<Stream<T>, Stream<R>> createMap(Function<? super T, ? extends R> mapper) {
        Objects.requireNonNull(mapper);
        Function<Stream, Stream> function = s -> s.map(mapper);
        return new StandardIntermediateOperation<Stream<T>, Stream<R>>(IntermediateOperationType.MAP, Stream.class, Stream.class, function, mapper);
    }

    public <T> IntermediateOperation<Stream<T>, IntStream> createMapToInt(ToIntFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        Function<Stream, IntStream> function = s -> s.mapToInt(mapper);
        return new StandardIntermediateOperation<Stream<T>, IntStream>(IntermediateOperationType.MAP_TO, Stream.class, IntStream.class, function, mapper);
    }

    public <T> IntermediateOperation<Stream<T>, LongStream> createMapToLong(ToLongFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        Function<Stream, LongStream> function = s -> s.mapToLong(mapper);
        return new StandardIntermediateOperation<Stream<T>, LongStream>(IntermediateOperationType.MAP_TO, Stream.class, LongStream.class, function, mapper);
    }

    public <T> IntermediateOperation<Stream<T>, DoubleStream> createMapToDouble(ToDoubleFunction<? super T> mapper) {
        Objects.requireNonNull(mapper);
        Function<Stream, DoubleStream> function = s -> s.mapToDouble(mapper);
        return new StandardIntermediateOperation<Stream<T>, DoubleStream>(IntermediateOperationType.MAP_TO, Stream.class, DoubleStream.class, function, mapper);
    }

    public <T, R> IntermediateOperation<Stream<T>, Stream<R>> createFlatMap(Function<? super T, ? extends Stream<? extends R>> mapper) {
        Objects.requireNonNull(mapper);
        Function<Stream, Stream> function = s -> s.flatMap(mapper);
        return new StandardIntermediateOperation<Stream<T>, Stream<R>>(IntermediateOperationType.FLAT_MAP, Stream.class, Stream.class, function, mapper);
    }

    public <T> IntermediateOperation<Stream<T>, IntStream> createFlatMapToInt(Function<? super T, ? extends IntStream> mapper) {
        Objects.requireNonNull(mapper);
        Function<Stream, IntStream> function = s -> s.flatMapToInt(mapper);
        return new StandardIntermediateOperation<Stream<T>, IntStream>(IntermediateOperationType.FLAT_MAP_TO, Stream.class, IntStream.class, function, mapper);
    }

    public <T> IntermediateOperation<Stream<T>, LongStream> createFlatMapToLong(Function<? super T, ? extends LongStream> mapper) {
        Objects.requireNonNull(mapper);
        Function<Stream, LongStream> function = s -> s.flatMapToLong(mapper);
        return new StandardIntermediateOperation<Stream<T>, LongStream>(IntermediateOperationType.FLAT_MAP_TO, Stream.class, LongStream.class, function, mapper);
    }

    public <T> IntermediateOperation<Stream<T>, DoubleStream> createFlatMapToDouble(Function<? super T, ? extends DoubleStream> mapper) {
        Objects.requireNonNull(mapper);
        Function<Stream, DoubleStream> function = s -> s.flatMapToDouble(mapper);
        return new StandardIntermediateOperation<Stream<T>, DoubleStream>(IntermediateOperationType.FLAT_MAP_TO, Stream.class, DoubleStream.class, function, mapper);
    }

    public <T> IntermediateOperation<Stream<T>, Stream<T>> acquireDistinct() {
        return TypeUtil.typed(DISTINCT);
    }

    public <T> IntermediateOperation<Stream<T>, Stream<T>> acquireSorted() {
        return TypeUtil.typed(SORTED);
    }

    public <T> IntermediateOperation<Stream<T>, Stream<T>> createSorted(Comparator<? super T> comparator) {
        Objects.requireNonNull(comparator);
        UnaryOperator function = s -> s.sorted(comparator);
        return new StandardIntermediateOperation<Stream<T>, Stream<T>>(IntermediateOperationType.SORTED, Stream.class, Stream.class, function, comparator);
    }

    public <T> IntermediateOperation<Stream<T>, Stream<T>> createPeek(Consumer<? super T> action) {
        Objects.requireNonNull(action);
        UnaryOperator function = s -> s.peek(action);
        return new StandardIntermediateOperation<Stream<T>, Stream<T>>(IntermediateOperationType.PEEK, Stream.class, Stream.class, function, action);
    }

    public <T> IntermediateOperation<Stream<T>, Stream<T>> createLimit(long maxSize) {
        if (maxSize < 0L) {
            throw new IllegalArgumentException(Long.toString(maxSize));
        }
        UnaryOperator function = s -> s.limit(maxSize);
        return new StandardIntermediateOperation<Stream<T>, Stream<T>>(IntermediateOperationType.LIMIT, Stream.class, Stream.class, function, maxSize);
    }

    public <T> IntermediateOperation<Stream<T>, Stream<T>> createSkip(long n) {
        if (n < 0L) {
            throw new IllegalArgumentException(Long.toString(n));
        }
        UnaryOperator function = s -> s.skip(n);
        return new StandardIntermediateOperation<Stream<T>, Stream<T>>(IntermediateOperationType.SKIP, Stream.class, Stream.class, function, n);
    }

    public <T> IntermediateOperation<Stream<T>, Stream<T>> createTakeWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        UnaryOperator function = s -> s.takeWhile(predicate);
        return new StandardIntermediateOperation<Stream<T>, Stream<T>>(IntermediateOperationType.TAKE_WHILE, Stream.class, Stream.class, function, predicate);
    }

    public <T> IntermediateOperation<Stream<T>, Stream<T>> createDropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate);
        UnaryOperator function = s -> s.dropWhile(predicate);
        return new StandardIntermediateOperation<Stream<T>, Stream<T>>(IntermediateOperationType.DROP_WHILE, Stream.class, Stream.class, function, predicate);
    }
}

