/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.pipeline.intermediate.standard.internal;

import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperation;
import com.speedment.jpastreamer.pipeline.intermediate.IntermediateOperationType;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.BaseStream;
import java.util.stream.Collectors;
import java.util.stream.Stream;

final class StandardIntermediateOperation<S extends BaseStream<?, S>, R extends BaseStream<?, R>>
implements IntermediateOperation<S, R> {
    private final IntermediateOperationType type;
    private final Class<? super S> streamType;
    private final Class<? super R> returnType;
    private final Function<S, R> function;
    private final Object[] arguments;

    StandardIntermediateOperation(IntermediateOperationType type, Class<? super S> streamType, Class<? super R> returnType, Function<S, R> function, Object ... arguments) {
        this.type = Objects.requireNonNull(type);
        this.streamType = Objects.requireNonNull(streamType);
        this.arguments = Objects.requireNonNull(arguments);
        this.returnType = Objects.requireNonNull(returnType);
        this.function = Objects.requireNonNull(function);
    }

    public IntermediateOperationType type() {
        return this.type;
    }

    public Class<? super S> streamType() {
        return this.streamType;
    }

    public Class<? super R> returnType() {
        return this.returnType;
    }

    public Function<S, R> function() {
        return this.function;
    }

    public Object[] arguments() {
        return this.arguments;
    }

    public String toString() {
        return String.format("%s(%s)", this.type.toString(), this.arguments == null ? "" : Stream.of(this.arguments).map(this::objectLabel).collect(Collectors.joining(", ")));
    }

    private String objectLabel(Object object) {
        if (object instanceof Long) {
            return object.toString();
        }
        return object.getClass().getSimpleName();
    }
}

