/*
 * Decompiled with CFR 0.152.
 */
package com.speedment.jpastreamer.pipeline.terminal.standard.internal;

import com.speedment.jpastreamer.pipeline.terminal.LongTerminalOperationFactory;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.TerminalOperationType;
import com.speedment.jpastreamer.pipeline.terminal.standard.internal.AcceptTerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.standard.internal.ApplyAsLongTerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.standard.internal.ApplyTerminalOperation;
import com.speedment.jpastreamer.pipeline.terminal.standard.internal.TestTerminalOperation;
import java.util.LongSummaryStatistics;
import java.util.Objects;
import java.util.OptionalDouble;
import java.util.OptionalLong;
import java.util.PrimitiveIterator;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.LongBinaryOperator;
import java.util.function.LongConsumer;
import java.util.function.LongPredicate;
import java.util.function.ObjLongConsumer;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.ToLongFunction;
import java.util.stream.LongStream;

public class InternalLongTerminalOperationFactory
implements LongTerminalOperationFactory {
    private static final TerminalOperation<LongStream, long[]> TO_ARRAY = new ApplyTerminalOperation<LongStream, long[], Function<LongStream, long[]>>(TerminalOperationType.TO_ARRAY, LongStream.class, long[].class, LongStream::toArray, new Object[0]);
    private static final TerminalOperation<LongStream, Long> SUM = new ApplyAsLongTerminalOperation<LongStream, Long, ToLongFunction<LongStream>>(TerminalOperationType.SUM_LONG, LongStream.class, Long.TYPE, LongStream::sum, new Object[0]);
    private static final TerminalOperation<LongStream, OptionalLong> MIN = new ApplyTerminalOperation<LongStream, OptionalLong, Function<LongStream, OptionalLong>>(TerminalOperationType.MIN, LongStream.class, OptionalLong.class, LongStream::min, new Object[0]);
    private static final TerminalOperation<LongStream, OptionalLong> MAX = new ApplyTerminalOperation<LongStream, OptionalLong, Function<LongStream, OptionalLong>>(TerminalOperationType.MAX, LongStream.class, OptionalLong.class, LongStream::max, new Object[0]);
    private static final TerminalOperation<LongStream, OptionalDouble> AVERAGE = new ApplyTerminalOperation<LongStream, OptionalDouble, Function<LongStream, OptionalDouble>>(TerminalOperationType.MAX, LongStream.class, OptionalDouble.class, LongStream::average, new Object[0]);
    private static final TerminalOperation<LongStream, LongSummaryStatistics> SUMMARY_STATISTICS = new ApplyTerminalOperation<LongStream, LongSummaryStatistics, Function<LongStream, LongSummaryStatistics>>(TerminalOperationType.MAX, LongStream.class, LongSummaryStatistics.class, LongStream::summaryStatistics, new Object[0]);
    private static final TerminalOperation<LongStream, OptionalLong> FIND_FIRST = new ApplyTerminalOperation<LongStream, OptionalLong, Function<LongStream, OptionalLong>>(TerminalOperationType.FIND_FIRST, LongStream.class, OptionalLong.class, LongStream::findFirst, new Object[0]);
    private static final TerminalOperation<LongStream, OptionalLong> FIND_ANY = new ApplyTerminalOperation<LongStream, OptionalLong, Function<LongStream, OptionalLong>>(TerminalOperationType.FIND_ANY, LongStream.class, OptionalLong.class, LongStream::findAny, new Object[0]);
    private static final TerminalOperation<LongStream, Long> COUNT = new ApplyAsLongTerminalOperation<LongStream, Long, ToLongFunction<LongStream>>(TerminalOperationType.COUNT, LongStream.class, Long.TYPE, LongStream::count, new Object[0]);
    private static final TerminalOperation<LongStream, PrimitiveIterator.OfLong> ITERATOR = new ApplyTerminalOperation<LongStream, PrimitiveIterator.OfLong, Function<LongStream, PrimitiveIterator.OfLong>>(TerminalOperationType.ITERATOR, LongStream.class, PrimitiveIterator.OfLong.class, LongStream::iterator, new Object[0]);
    private static final TerminalOperation<LongStream, Spliterator.OfLong> SPLITERATOR = new ApplyTerminalOperation<LongStream, Spliterator.OfLong, Function<LongStream, Spliterator.OfLong>>(TerminalOperationType.SPLITERATOR, LongStream.class, Spliterator.OfLong.class, LongStream::spliterator, new Object[0]);

    public TerminalOperation<LongStream, Void> createForEach(LongConsumer action) {
        Objects.requireNonNull(action);
        return new AcceptTerminalOperation<LongStream, Void, Consumer<LongStream>>(TerminalOperationType.FOR_EACH, LongStream.class, Void.TYPE, stream -> stream.forEach(action), action);
    }

    public TerminalOperation<LongStream, Void> createForEachOrdered(LongConsumer action) {
        Objects.requireNonNull(action);
        return new AcceptTerminalOperation<LongStream, Void, Consumer<LongStream>>(TerminalOperationType.FOR_EACH_ORDERED, LongStream.class, Void.TYPE, stream -> stream.forEachOrdered(action), action);
    }

    public TerminalOperation<LongStream, long[]> acquireToArray() {
        return TO_ARRAY;
    }

    public TerminalOperation<LongStream, Long> createReduce(long identity, LongBinaryOperator op) {
        Objects.requireNonNull(op);
        return new ApplyAsLongTerminalOperation<LongStream, Long, ToLongFunction<LongStream>>(TerminalOperationType.REDUCE, LongStream.class, Long.TYPE, stream -> stream.reduce(identity, op), identity, op);
    }

    public TerminalOperation<LongStream, OptionalLong> createReduce(LongBinaryOperator op) {
        Objects.requireNonNull(op);
        return new ApplyTerminalOperation<LongStream, OptionalLong, Function<LongStream, OptionalLong>>(TerminalOperationType.REDUCE, LongStream.class, OptionalLong.class, stream -> stream.reduce(op), op);
    }

    public <R> TerminalOperation<LongStream, R> createCollect(Supplier<R> supplier, ObjLongConsumer<R> accumulator, BiConsumer<R, R> combiner) {
        Objects.requireNonNull(supplier);
        Objects.requireNonNull(accumulator);
        Objects.requireNonNull(combiner);
        return new ApplyTerminalOperation<LongStream, Object, Function<LongStream, Object>>(TerminalOperationType.COLLECT, LongStream.class, Object.class, stream -> stream.collect(supplier, accumulator, combiner), supplier, accumulator, combiner);
    }

    public TerminalOperation<LongStream, Long> acquireSum() {
        return SUM;
    }

    public TerminalOperation<LongStream, OptionalLong> acquireMin() {
        return MIN;
    }

    public TerminalOperation<LongStream, OptionalLong> acquireMax() {
        return MAX;
    }

    public TerminalOperation<LongStream, Long> acquireCount() {
        return COUNT;
    }

    public TerminalOperation<LongStream, OptionalDouble> acquireAverage() {
        return AVERAGE;
    }

    public TerminalOperation<LongStream, LongSummaryStatistics> acquireSummaryStatistics() {
        return SUMMARY_STATISTICS;
    }

    public TerminalOperation<LongStream, Boolean> createAnyMatch(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new TestTerminalOperation<LongStream, Boolean, Predicate<LongStream>>(TerminalOperationType.ANY_MATCH, LongStream.class, Boolean.TYPE, stream -> stream.anyMatch(predicate), predicate);
    }

    public TerminalOperation<LongStream, Boolean> createAllMatch(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new TestTerminalOperation<LongStream, Boolean, Predicate<LongStream>>(TerminalOperationType.ALL_MATCH, LongStream.class, Boolean.TYPE, stream -> stream.allMatch(predicate), predicate);
    }

    public TerminalOperation<LongStream, Boolean> createNoneMatch(LongPredicate predicate) {
        Objects.requireNonNull(predicate);
        return new TestTerminalOperation<LongStream, Boolean, Predicate<LongStream>>(TerminalOperationType.NONE_MATCH, LongStream.class, Boolean.TYPE, stream -> stream.noneMatch(predicate), predicate);
    }

    public TerminalOperation<LongStream, OptionalLong> acquireFindFirst() {
        return FIND_FIRST;
    }

    public TerminalOperation<LongStream, OptionalLong> acquireFindAny() {
        return FIND_ANY;
    }

    public TerminalOperation<LongStream, PrimitiveIterator.OfLong> acquireIterator() {
        return ITERATOR;
    }

    public TerminalOperation<LongStream, Spliterator.OfLong> acquireSpliterator() {
        return SPLITERATOR;
    }
}

