/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.config;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.stormpath.sdk.account.Account;
import com.stormpath.sdk.application.Application;
import com.stormpath.sdk.authc.AuthenticationResult;
import com.stormpath.sdk.cache.Cache;
import com.stormpath.sdk.client.Client;
import com.stormpath.sdk.idsite.IdSiteResultListener;
import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.lang.BiPredicate;
import com.stormpath.sdk.lang.Collections;
import com.stormpath.sdk.lang.Strings;
import com.stormpath.sdk.saml.SamlResultListener;
import com.stormpath.sdk.servlet.account.AccountResolver;
import com.stormpath.sdk.servlet.account.DefaultAccountResolver;
import com.stormpath.sdk.servlet.application.ApplicationResolver;
import com.stormpath.sdk.servlet.application.DefaultApplicationResolver;
import com.stormpath.sdk.servlet.authz.RequestAuthorizer;
import com.stormpath.sdk.servlet.config.CookieConfig;
import com.stormpath.sdk.servlet.config.CookieProperties;
import com.stormpath.sdk.servlet.config.RegisterEnabledPredicate;
import com.stormpath.sdk.servlet.config.RegisterEnabledResolver;
import com.stormpath.sdk.servlet.config.impl.AccessTokenCookieConfig;
import com.stormpath.sdk.servlet.config.impl.RefreshTokenCookieConfig;
import com.stormpath.sdk.servlet.csrf.CsrfTokenManager;
import com.stormpath.sdk.servlet.csrf.DefaultCsrfTokenManager;
import com.stormpath.sdk.servlet.csrf.DisabledCsrfTokenManager;
import com.stormpath.sdk.servlet.event.RequestEvent;
import com.stormpath.sdk.servlet.event.RequestEventListener;
import com.stormpath.sdk.servlet.event.RequestEventListenerAdapter;
import com.stormpath.sdk.servlet.event.TokenRevocationRequestEventListener;
import com.stormpath.sdk.servlet.event.impl.Publisher;
import com.stormpath.sdk.servlet.event.impl.RequestEventPublisher;
import com.stormpath.sdk.servlet.filter.ContentNegotiationResolver;
import com.stormpath.sdk.servlet.filter.ControllerConfig;
import com.stormpath.sdk.servlet.filter.DefaultContentNegotiationResolver;
import com.stormpath.sdk.servlet.filter.DefaultFilterChainManager;
import com.stormpath.sdk.servlet.filter.DefaultLoginPageRedirector;
import com.stormpath.sdk.servlet.filter.DefaultServerUriResolver;
import com.stormpath.sdk.servlet.filter.DefaultUsernamePasswordRequestFactory;
import com.stormpath.sdk.servlet.filter.DefaultWrappedServletRequestFactory;
import com.stormpath.sdk.servlet.filter.FilterChainManager;
import com.stormpath.sdk.servlet.filter.FilterChainResolver;
import com.stormpath.sdk.servlet.filter.Filters;
import com.stormpath.sdk.servlet.filter.LoginPageRedirector;
import com.stormpath.sdk.servlet.filter.MeFilter;
import com.stormpath.sdk.servlet.filter.PathMatchingFilterChainResolver;
import com.stormpath.sdk.servlet.filter.PrioritizedFilterChainResolver;
import com.stormpath.sdk.servlet.filter.ServerUriResolver;
import com.stormpath.sdk.servlet.filter.StormpathFilter;
import com.stormpath.sdk.servlet.filter.UsernamePasswordRequestFactory;
import com.stormpath.sdk.servlet.filter.WrappedServletRequestFactory;
import com.stormpath.sdk.servlet.filter.account.AccountResolverFilter;
import com.stormpath.sdk.servlet.filter.account.AuthenticationResultSaver;
import com.stormpath.sdk.servlet.filter.account.AuthorizationHeaderAccountResolver;
import com.stormpath.sdk.servlet.filter.account.CookieAccountResolver;
import com.stormpath.sdk.servlet.filter.account.CookieAuthenticationResultSaver;
import com.stormpath.sdk.servlet.filter.account.DefaultJwtAccountResolver;
import com.stormpath.sdk.servlet.filter.account.JwtAccountResolver;
import com.stormpath.sdk.servlet.filter.account.JwtSigningKeyResolver;
import com.stormpath.sdk.servlet.filter.account.SessionAccountResolver;
import com.stormpath.sdk.servlet.filter.account.SessionAuthenticationResultSaver;
import com.stormpath.sdk.servlet.filter.mvc.ControllerFilter;
import com.stormpath.sdk.servlet.filter.oauth.AccessTokenAuthenticationRequestFactory;
import com.stormpath.sdk.servlet.filter.oauth.AccessTokenResultFactory;
import com.stormpath.sdk.servlet.filter.oauth.DefaultAccessTokenAuthenticationRequestFactory;
import com.stormpath.sdk.servlet.filter.oauth.DefaultAccessTokenRequestAuthorizer;
import com.stormpath.sdk.servlet.filter.oauth.DefaultAccessTokenResultFactory;
import com.stormpath.sdk.servlet.filter.oauth.DefaultRefreshTokenAuthenticationRequestFactory;
import com.stormpath.sdk.servlet.filter.oauth.DefaultRefreshTokenResultFactory;
import com.stormpath.sdk.servlet.filter.oauth.OriginAccessTokenRequestAuthorizer;
import com.stormpath.sdk.servlet.filter.oauth.RefreshTokenAuthenticationRequestFactory;
import com.stormpath.sdk.servlet.filter.oauth.RefreshTokenResultFactory;
import com.stormpath.sdk.servlet.http.InvalidMediaTypeException;
import com.stormpath.sdk.servlet.http.MediaType;
import com.stormpath.sdk.servlet.http.Resolver;
import com.stormpath.sdk.servlet.http.Saver;
import com.stormpath.sdk.servlet.http.authc.AccountStoreResolver;
import com.stormpath.sdk.servlet.http.authc.AuthorizationHeaderAuthenticator;
import com.stormpath.sdk.servlet.http.authc.BasicAuthenticationScheme;
import com.stormpath.sdk.servlet.http.authc.BearerAuthenticationScheme;
import com.stormpath.sdk.servlet.http.authc.DisabledAccountStoreResolver;
import com.stormpath.sdk.servlet.http.authc.HeaderAuthenticator;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticationScheme;
import com.stormpath.sdk.servlet.http.authc.HttpAuthenticator;
import com.stormpath.sdk.servlet.i18n.DefaultMessageContext;
import com.stormpath.sdk.servlet.i18n.MessageContext;
import com.stormpath.sdk.servlet.idsite.DefaultIdSiteOrganizationResolver;
import com.stormpath.sdk.servlet.idsite.IdSiteOrganizationContext;
import com.stormpath.sdk.servlet.mvc.AbstractController;
import com.stormpath.sdk.servlet.mvc.AbstractSocialCallbackController;
import com.stormpath.sdk.servlet.mvc.AccessTokenController;
import com.stormpath.sdk.servlet.mvc.ChangePasswordController;
import com.stormpath.sdk.servlet.mvc.ContentNegotiatingFieldValueResolver;
import com.stormpath.sdk.servlet.mvc.Controller;
import com.stormpath.sdk.servlet.mvc.DefaultViewResolver;
import com.stormpath.sdk.servlet.mvc.DisabledWebHandler;
import com.stormpath.sdk.servlet.mvc.ErrorModelFactory;
import com.stormpath.sdk.servlet.mvc.ForgotPasswordController;
import com.stormpath.sdk.servlet.mvc.FormController;
import com.stormpath.sdk.servlet.mvc.IdSiteController;
import com.stormpath.sdk.servlet.mvc.IdSiteLogoutController;
import com.stormpath.sdk.servlet.mvc.IdSiteResultController;
import com.stormpath.sdk.servlet.mvc.JacksonView;
import com.stormpath.sdk.servlet.mvc.LoginController;
import com.stormpath.sdk.servlet.mvc.LoginErrorModelFactory;
import com.stormpath.sdk.servlet.mvc.LogoutController;
import com.stormpath.sdk.servlet.mvc.MeController;
import com.stormpath.sdk.servlet.mvc.RegisterController;
import com.stormpath.sdk.servlet.mvc.RequestFieldValueResolver;
import com.stormpath.sdk.servlet.mvc.SamlController;
import com.stormpath.sdk.servlet.mvc.SamlResultController;
import com.stormpath.sdk.servlet.mvc.VerifyController;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import com.stormpath.sdk.servlet.mvc.WebHandler;
import com.stormpath.sdk.servlet.mvc.provider.AccountStoreModelFactory;
import com.stormpath.sdk.servlet.mvc.provider.ExternalAccountStoreModelFactory;
import com.stormpath.sdk.servlet.mvc.provider.FacebookCallbackController;
import com.stormpath.sdk.servlet.mvc.provider.GithubCallbackController;
import com.stormpath.sdk.servlet.mvc.provider.GoogleCallbackController;
import com.stormpath.sdk.servlet.mvc.provider.LinkedinCallbackController;
import com.stormpath.sdk.servlet.oauth.AccessTokenValidationStrategy;
import com.stormpath.sdk.servlet.oauth.impl.JwtTokenSigningKeyResolver;
import com.stormpath.sdk.servlet.organization.DefaultOrganizationNameKeyResolver;
import com.stormpath.sdk.servlet.saml.DefaultSamlOrganizationResolver;
import com.stormpath.sdk.servlet.saml.SamlOrganizationContext;
import com.stormpath.sdk.servlet.util.IsLocalhostResolver;
import com.stormpath.sdk.servlet.util.PatternMatcher;
import com.stormpath.sdk.servlet.util.RemoteAddrResolver;
import com.stormpath.sdk.servlet.util.SecureRequiredExceptForLocalhostResolver;
import com.stormpath.sdk.servlet.util.SubdomainResolver;
import com.stormpath.spring.config.AccessTokenCookieProperties;
import com.stormpath.spring.config.RefreshTokenCookieProperties;
import com.stormpath.spring.mvc.ChangePasswordControllerConfig;
import com.stormpath.spring.mvc.DisabledHandlerMapping;
import com.stormpath.spring.mvc.ForgotPasswordControllerConfig;
import com.stormpath.spring.mvc.LoginControllerConfig;
import com.stormpath.spring.mvc.LogoutControllerConfig;
import com.stormpath.spring.mvc.MessageContextRegistrar;
import com.stormpath.spring.mvc.RegisterControllerConfig;
import com.stormpath.spring.mvc.SingleNamedViewResolver;
import com.stormpath.spring.mvc.SpringMessageSource;
import com.stormpath.spring.mvc.SpringView;
import com.stormpath.spring.mvc.TemplateLayoutInterceptor;
import com.stormpath.spring.mvc.VerifyControllerConfig;
import com.stormpath.spring.util.SpringPatternMatcher;
import io.jsonwebtoken.SignatureAlgorithm;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.BeanCreationException;
import org.springframework.beans.factory.BeanInitializationException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.ApplicationContext;
import org.springframework.context.MessageSource;
import org.springframework.core.env.CompositePropertySource;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.EnumerablePropertySource;
import org.springframework.core.env.Environment;
import org.springframework.core.env.PropertySource;
import org.springframework.util.PathMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.HandlerMapping;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.i18n.CookieLocaleResolver;
import org.springframework.web.servlet.i18n.LocaleChangeInterceptor;
import org.springframework.web.servlet.view.InternalResourceViewResolver;
import org.springframework.web.servlet.view.JstlView;
import org.springframework.web.servlet.view.json.MappingJackson2JsonView;
import org.springframework.web.util.UrlPathHelper;

public abstract class AbstractStormpathWebMvcConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AbstractStormpathWebMvcConfiguration.class);
    private static final String PRODUCES_SUPPORTED_TYPES_MSG = "stormpath.web.produces property value must specify either application/json or text/html or both.  Other media types for this property are not currently supported.";
    @Value(value="#{ @environment['stormpath.web.authc.savers.cookie.enabled'] ?: true }")
    protected boolean cookieAuthenticationResultSaverEnabled;
    @Value(value="#{ @environment['stormpath.web.authc.savers.session.enabled'] ?: false }")
    protected boolean sessionAuthenticationResultSaverEnabled;
    @Value(value="#{ @environment['stormpath.web.account.jwt.ttl'] ?: 259200 }")
    protected long accountJwtTtl;
    @Value(value="#{ @environment['stormpath.web.account.jwt.signatureAlgorithm'] ?: 'HS256' }")
    protected SignatureAlgorithm accountJwtSignatureAlgorithm;
    @Value(value="#{ @environment['stormpath.web.request.remoteUser.strategy'] ?: 'username' }")
    protected String requestRemoteUserStrategy;
    @Value(value="#{ @environment['stormpath.web.request.userPrincipal.strategy'] ?: 'account' }")
    protected String requestUserPrincipalStrategy;
    @Value(value="#{ @environment['stormpath.web.request.client.attributeNames'] ?: 'client' }")
    protected String requestClientAttributeNames;
    @Value(value="#{ @environment['stormpath.web.request.application.attributeNames'] ?: 'application' }")
    protected String requestApplicationAttributeNames;
    @Value(value="#{ @environment['stormpath.web.csrf.token.enabled'] ?: true }")
    protected boolean csrfTokenEnabled;
    @Value(value="#{ @environment['stormpath.web.csrf.token.ttl'] ?: 3600000 }")
    protected long csrfTokenTtl;
    @Value(value="#{ @environment['stormpath.web.csrf.token.name'] ?: 'csrfToken'}")
    protected String csrfTokenName;
    @Value(value="#{ @environment['stormpath.web.nonce.cache.name'] ?: 'com.stormpath.sdk.servlet.nonces' }")
    protected String nonceCacheName;
    @Value(value="#{ @environment['stormpath.web.http.authc.challenge'] ?: true }")
    protected boolean httpAuthenticationChallenge;
    @Value(value="#{ @environment['stormpath.web.stormpathFilter.enabled'] ?: true }")
    protected boolean stormpathFilterEnabled;
    @Value(value="#{ @environment['stormpath.web.stormpathFilter.order'] ?: T(org.springframework.core.Ordered).HIGHEST_PRECEDENCE }")
    protected int stormpathFilterOrder;
    @Value(value="#{ @environment['stormpath.web.stormpathFilter.urlPatterns'] ?: '/*' }")
    protected String stormpathFilterUrlPatterns;
    @Value(value="#{ @environment['stormpath.web.stormpathFilter.servletNames'] }")
    protected String stormpathFilterServletNames;
    @Value(value="#{ @environment['stormpath.web.stormpathFilter.dispatcherTypes'] ?: 'REQUEST, INCLUDE, FORWARD, ERROR' }")
    protected String stormpathFilterDispatcherTypes;
    @Value(value="#{ @environment['stormpath.web.stormpathFilter.matchAfter'] ?: false }")
    protected boolean stormpathFilterMatchAfter;
    @Value(value="#{ @environment['stormpath.web.assets.handlerMapping.order'] ?: T(org.springframework.core.Ordered).HIGHEST_PRECEDENCE + 2}")
    protected int staticResourceHandlerMappingOrder = Integer.MIN_VALUE;
    @Value(value="#{ @environment['stormpath.web.assets.enabled'] ?: true}")
    protected boolean assetsEnabled;
    @Value(value="#{ @environment['stormpath.web.assets.defaultServletName'] ?: null}")
    protected String defaultServletName;
    @Value(value="#{ @environment['stormpath.web.assets.js.enabled'] ?: true}")
    protected boolean jsEnabled;
    @Value(value="#{ @environment['stormpath.web.assets.css.enabled'] ?: true}")
    protected boolean cssEnabled;
    @Value(value="#{ @environment['stormpath.web.head.view'] ?: 'stormpath/head' }")
    protected String headView;
    @Value(value="#{ @environment['stormpath.web.head.fragmentSelector'] ?: 'head' }")
    protected String headFragmentSelector;
    @Value(value="#{ @environment['stormpath.web.head.cssUris'] ?: '//fonts.googleapis.com/css?family=Open+Sans:300italic,300,400italic,400,600italic,600,700italic,700,800italic,800 //netdna.bootstrapcdn.com/bootstrap/3.3.6/css/bootstrap.min.css /assets/css/stormpath.css' }")
    protected String headCssUris;
    @Value(value="#{ @environment['stormpath.web.head.extraCssUris'] }")
    protected String headExtraCssUris;
    @Value(value="#{ @environment['stormpath.web.register.autoLogin'] ?: false }")
    protected boolean registerAutoLogin;
    @Value(value="#{ @environment['stormpath.web.logout.invalidateHttpSession'] ?: true }")
    protected boolean logoutInvalidateHttpSession;
    @Value(value="#{ @environment['stormpath.web.oauth2.enabled'] ?: true }")
    protected boolean accessTokenEnabled;
    @Value(value="#{ @environment['stormpath.web.oauth2.uri'] ?: '/oauth/token' }")
    protected String accessTokenUri;
    @Value(value="#{ @environment['stormpath.web.oauth2.origin.authorizer.originUris'] }")
    protected String accessTokenAuthorizedOriginUris;
    @Value(value="#{ @environment['stormpath.web.oauth2.password.validationStrategy'] ?: 'local'}")
    protected String accessTokenValidationStrategy;
    @Value(value="#{ @environment['stormpath.web.idSite.enabled'] ?: false }")
    protected boolean idSiteEnabled;
    @Value(value="#{ @environment['stormpath.web.idSite.loginUri'] }")
    protected String idSiteLoginUri;
    @Value(value="#{ @environment['stormpath.web.idSite.registerUri'] ?: '/#/register' }")
    protected String idSiteRegisterUri;
    @Value(value="#{ @environment['stormpath.web.idSite.forgotUri'] ?: '/#/forgot' }")
    protected String idSiteForgotUri;
    @Value(value="#{ @environment['stormpath.web.idSite.useSubdomain'] }")
    protected Boolean idSiteUseSubdomain;
    @Value(value="#{ @environment['stormpath.web.idSite.showOrganizationField'] }")
    protected Boolean idSiteShowOrganizationField;
    @Value(value="#{ @environment['stormpath.web.callback.enabled'] ?: true }")
    protected boolean callbackEnabled;
    @Value(value="#{ @environment['stormpath.web.callback.uri'] ?: '/stormpathCallback' }")
    protected String callbackUri;
    @Value(value="#{ @environment['stormpath.web.me.enabled'] ?: true }")
    protected boolean meEnabled;
    @Value(value="#{ @environment['stormpath.web.me.uri'] ?: '/me' }")
    protected String meUri;
    @Value(value="#{ @environment['stormpath.web.produces'] ?: 'application/json, text/html' }")
    protected String produces;
    @Value(value="#{ @environment['stormpath.web.social.google.uri'] ?: '/callbacks/google' }")
    protected String googleCallbackUri;
    @Value(value="#{ @environment['stormpath.web.social.facebook.uri'] ?: '/callbacks/facebook' }")
    protected String facebookCallbackUri;
    @Value(value="#{ @environment['stormpath.web.social.linkedin.uri'] ?: '/callbacks/linkedin' }")
    protected String linkedinCallbackUri;
    @Value(value="#{ @environment['stormpath.web.social.github.uri'] ?: '/callbacks/github' }")
    protected String githubCallbackUri;
    @Value(value="#{ @environment['stormpath.web.application.domain'] }")
    protected String baseDomainName;
    @Value(value="#{ @environment['stormpath.web.json.view.resolver.order'] ?: T(org.springframework.core.Ordered).LOWEST_PRECEDENCE - 10 }")
    protected int jsonViewResolverOrder;
    @Value(value="#{ @environment['stormpath.web.jsp.view.resolver.order'] ?: T(org.springframework.core.Ordered).LOWEST_PRECEDENCE}")
    protected int jspViewResolverOrder;
    @Autowired(required=false)
    protected PathMatcher pathMatcher;
    @Autowired(required=false)
    protected UrlPathHelper urlPathHelper;
    @Autowired
    protected Client client;
    @Autowired
    @Qualifier(value="stormpathApplication")
    protected Application application;
    @Autowired
    protected MessageSource messageSource;
    @Autowired(required=false)
    protected LocaleResolver localeResolver;
    @Autowired(required=false)
    protected LocaleChangeInterceptor localeChangeInterceptor;
    @Autowired(required=false)
    @Qualifier(value="springSecurityIdSiteResultListener")
    protected IdSiteResultListener springSecurityIdSiteResultListener;
    @Autowired(required=false)
    @Qualifier(value="springSecuritySamlResultListener")
    protected SamlResultListener springSecuritySamlResultListener;
    @Autowired(required=false)
    protected ErrorModelFactory loginErrorModelFactory;
    @Autowired(required=false)
    protected ObjectMapper objectMapper = new ObjectMapper();
    @Autowired
    protected ApplicationContext applicationContext;
    @Autowired
    protected Environment environment;
    @Autowired
    protected ServletContext servletContext;
    @Autowired(required=false)
    @Qualifier(value="loginPreHandler")
    protected WebHandler loginPreHandler = new DisabledWebHandler();
    @Autowired(required=false)
    @Qualifier(value="loginPostHandler")
    protected WebHandler loginPostHandler = new DisabledWebHandler();
    @Autowired(required=false)
    @Qualifier(value="registerPreHandler")
    protected WebHandler registerPreHandler = new DisabledWebHandler();
    @Autowired(required=false)
    @Qualifier(value="registerPostHandler")
    protected WebHandler registerPostHandler = new DisabledWebHandler();
    @Autowired
    private Map<String, ViewResolver> viewResolvers;

    public HandlerMapping stormpathStaticResourceHandlerMapping() {
        if (!this.assetsEnabled || !this.cssEnabled && !this.jsEnabled) {
            return new DisabledHandlerMapping();
        }
        AccessibleResourceHandlerRegistry registry = new AccessibleResourceHandlerRegistry(this.applicationContext, this.servletContext);
        registry.setOrder(this.staticResourceHandlerMappingOrder);
        if (this.cssEnabled) {
            registry.addResourceHandler(new String[]{"/assets/css/*stormpath.css"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/assets/css/"});
        }
        if (this.jsEnabled) {
            registry.addResourceHandler(new String[]{"/assets/js/*stormpath.js"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/assets/js/"});
        }
        return registry.toHandlerMapping();
    }

    private void addRoutes(DefaultFilterChainManager mgr) throws ServletException {
        if (this.stormpathLoginConfig().isEnabled()) {
            this.addFilter(mgr, this.stormpathLoginController(), this.stormpathLoginConfig());
            this.addFilter(mgr, this.stormpathFacebookCallbackController(), "facebook", this.facebookCallbackUri);
            this.addFilter(mgr, this.stormpathGithubCallbackController(), "github", this.githubCallbackUri);
            this.addFilter(mgr, this.stormpathGoogleCallbackController(), "google", this.googleCallbackUri);
            this.addFilter(mgr, this.stormpathLinkedinCallbackController(), "linkedin", this.linkedinCallbackUri);
        }
        if (this.stormpathLogoutConfig().isEnabled()) {
            this.addFilter(mgr, this.stormpathLogoutController(), this.stormpathLogoutConfig());
        }
        boolean registerEnabled = this.stormpathRegisterConfig().isEnabled();
        if (this.stormpathRegisterEnabledPredicate().test((Object)registerEnabled, (Object)this.application)) {
            this.addFilter(mgr, this.stormpathRegisterController(), this.stormpathRegisterConfig());
        }
        if (this.stormpathVerifyConfig().isEnabled()) {
            this.addFilter(mgr, this.stormpathVerifyController(), this.stormpathVerifyConfig());
        }
        if (this.stormpathForgotPasswordConfig().isEnabled()) {
            this.addFilter(mgr, this.stormpathForgotPasswordController(), this.stormpathForgotPasswordConfig());
        }
        if (this.stormpathChangePasswordConfig().isEnabled()) {
            this.addFilter(mgr, this.stormpathChangePasswordController(), (ControllerConfig)this.stormpathChangePasswordConfig());
        }
        if (this.accessTokenEnabled) {
            this.addFilter(mgr, this.stormpathAccessTokenController(), "accessToken", this.accessTokenUri);
        }
        if (this.idSiteEnabled) {
            this.addFilter(mgr, this.stormpathIdSiteResultController(), "idSiteResult", this.callbackUri);
        }
        if (this.callbackEnabled) {
            this.addFilter(mgr, this.stormpathSamlController(), "saml", "/saml");
            this.addFilter(mgr, this.stormpathSamlResultController(), "samlResult", this.callbackUri);
        }
        if (this.meEnabled) {
            this.addMeFilter(mgr);
        }
    }

    public com.stormpath.sdk.servlet.mvc.View stormpathControllerView() {
        InternalResourceViewResolver irvr;
        ViewResolver vr;
        ArrayList<ViewResolver> l = new ArrayList<ViewResolver>(this.viewResolvers.values());
        if (!l.contains(vr = this.stormpathJsonViewResolver())) {
            l.add(vr);
        }
        if (!l.contains(irvr = this.stormpathJspViewResolver())) {
            l.add((ViewResolver)irvr);
        }
        return new SpringView(l, this.stormpathSpringLocaleResolver(), this.stormpathLayoutInterceptor());
    }

    public com.stormpath.sdk.servlet.mvc.View stormpathJacksonView() {
        JacksonView view = new JacksonView();
        view.setObjectMapper(this.objectMapper);
        return view;
    }

    public com.stormpath.sdk.servlet.mvc.ViewResolver stormpathControllerViewResolver() {
        com.stormpath.sdk.servlet.mvc.ViewResolver fixed = new com.stormpath.sdk.servlet.mvc.ViewResolver(){

            public com.stormpath.sdk.servlet.mvc.View getView(ViewModel model, HttpServletRequest request) {
                return AbstractStormpathWebMvcConfiguration.this.stormpathControllerView();
            }
        };
        return new DefaultViewResolver(fixed, this.stormpathJacksonView(), this.stormpathProducedMediaTypes());
    }

    public ApplicationResolver stormpathApplicationResolver() {
        return new DefaultApplicationResolver();
    }

    public Resolver<Boolean> stormpathRegisterEnabledResolver() {
        return new RegisterEnabledResolver(this.stormpathRegisterConfig().isEnabled(), this.stormpathApplicationResolver(), this.stormpathRegisterEnabledPredicate());
    }

    public BiPredicate<Boolean, Application> stormpathRegisterEnabledPredicate() {
        return new RegisterEnabledPredicate();
    }

    public Controller stormpathGoogleCallbackController() {
        return this.configure(new GoogleCallbackController());
    }

    public Controller stormpathGithubCallbackController() {
        return this.configure(new GithubCallbackController());
    }

    public Controller stormpathFacebookCallbackController() {
        return this.configure(new FacebookCallbackController());
    }

    public Controller stormpathLinkedinCallbackController() {
        return this.configure(new LinkedinCallbackController());
    }

    public HandlerInterceptor stormpathLayoutInterceptor() {
        TemplateLayoutInterceptor interceptor = new TemplateLayoutInterceptor();
        interceptor.setHeadViewName(this.headView);
        interceptor.setHeadFragmentSelector(this.headFragmentSelector);
        String[] uris = StringUtils.tokenizeToStringArray((String)this.headCssUris, (String)" \t");
        LinkedHashSet uriSet = new LinkedHashSet();
        if (uris != null && uris.length > 0) {
            java.util.Collections.addAll(uriSet, uris);
        }
        if ((uris = StringUtils.tokenizeToStringArray((String)this.headExtraCssUris, (String)" \t")) != null && uris.length > 0) {
            java.util.Collections.addAll(uriSet, uris);
        }
        if (!Collections.isEmpty(uriSet)) {
            ArrayList<String> list = new ArrayList<String>();
            list.addAll(uriSet);
            interceptor.setHeadCssUris(list);
        }
        try {
            interceptor.afterPropertiesSet();
        }
        catch (Exception e) {
            String msg = "Unable to initialize stormpathLayoutInterceptor: " + e.getMessage();
            throw new BeanInitializationException(msg, (Throwable)e);
        }
        return interceptor;
    }

    public List<MediaType> stormpathProducedMediaTypes() {
        String mediaTypes = Strings.clean((String)this.produces);
        Assert.notNull((Object)mediaTypes, (String)"stormpath.web.produces property value cannot be null or empty.");
        try {
            return MediaType.parseMediaTypes((String)mediaTypes);
        }
        catch (InvalidMediaTypeException e) {
            String msg = "Unable to parse value in stormpath.web.produces property: " + e.getMessage();
            throw new IllegalArgumentException(msg, e);
        }
    }

    public View stormpathJsonView() {
        MappingJackson2JsonView jsonView = new MappingJackson2JsonView(this.objectMapper);
        jsonView.setDisableCaching(false);
        return jsonView;
    }

    public ViewResolver stormpathJsonViewResolver() {
        return new SingleNamedViewResolver("stormpathJsonView", this.stormpathJsonView(), this.jsonViewResolverOrder);
    }

    public InternalResourceViewResolver stormpathJspViewResolver() {
        InternalResourceViewResolver bean = new InternalResourceViewResolver();
        bean.setOrder(this.jspViewResolverOrder);
        bean.setViewClass(JstlView.class);
        bean.setPrefix("/WEB-INF/jsp/");
        bean.setSuffix(".jsp");
        return bean;
    }

    public AccountStoreResolver stormpathAccountStoreResolver() {
        return new DisabledAccountStoreResolver();
    }

    public UsernamePasswordRequestFactory stormpathUsernamePasswordRequestFactory() {
        return new DefaultUsernamePasswordRequestFactory(this.stormpathAccountStoreResolver());
    }

    public AccessTokenCookieProperties accessTokenCookieProperties() {
        return new AccessTokenCookieProperties();
    }

    public RefreshTokenCookieProperties refreshTokenCookieProperties() {
        return new RefreshTokenCookieProperties();
    }

    public CookieConfig stormpathRefreshTokenCookieConfig() {
        return new RefreshTokenCookieConfig((CookieProperties)this.refreshTokenCookieProperties());
    }

    public CookieConfig stormpathAccessTokenCookieConfig() {
        return new AccessTokenCookieConfig((CookieProperties)this.accessTokenCookieProperties());
    }

    public Resolver<String> stormpathRemoteAddrResolver() {
        return new RemoteAddrResolver();
    }

    public Resolver<Boolean> stormpathLocalhostResolver() {
        return new IsLocalhostResolver(this.stormpathRemoteAddrResolver());
    }

    public Resolver<Boolean> stormpathSecureResolver() {
        return new SecureRequiredExceptForLocalhostResolver(this.stormpathLocalhostResolver());
    }

    public Saver<AuthenticationResult> stormpathCookieAuthenticationResultSaver() {
        if (this.cookieAuthenticationResultSaverEnabled) {
            return new CookieAuthenticationResultSaver(this.stormpathAccessTokenCookieConfig(), this.stormpathRefreshTokenCookieConfig(), this.stormpathSecureResolver());
        }
        return DisabledAuthenticationResultSaver.INSTANCE;
    }

    public Saver<AuthenticationResult> stormpathSessionAuthenticationResultSaver() {
        if (this.sessionAuthenticationResultSaverEnabled) {
            String[] attributeNames = new String[]{Account.class.getName(), "account"};
            HashSet<String> set = new HashSet<String>(Arrays.asList(attributeNames));
            return new SessionAuthenticationResultSaver(set);
        }
        return DisabledAuthenticationResultSaver.INSTANCE;
    }

    public List<Saver<AuthenticationResult>> stormpathAuthenticationResultSavers() {
        ArrayList<Saver<AuthenticationResult>> savers = new ArrayList<Saver<AuthenticationResult>>();
        Saver<AuthenticationResult> saver = this.stormpathCookieAuthenticationResultSaver();
        if (!(saver instanceof DisabledAuthenticationResultSaver)) {
            savers.add(saver);
        }
        if (!((saver = this.stormpathSessionAuthenticationResultSaver()) instanceof DisabledAuthenticationResultSaver)) {
            savers.add(saver);
        }
        return savers;
    }

    public Saver<AuthenticationResult> stormpathAuthenticationResultSaver() {
        List<Saver<AuthenticationResult>> savers = this.stormpathAuthenticationResultSavers();
        if (Collections.isEmpty(savers)) {
            String msg = "No Saver<AuthenticationResult> instances have been enabled or configured.  This is required to save authentication result state.";
            throw new IllegalStateException(msg);
        }
        return new AuthenticationResultSaver(savers);
    }

    public JwtSigningKeyResolver stormpathJwtSigningKeyResolver() {
        return new JwtTokenSigningKeyResolver();
    }

    public RequestEventListener stormpathRequestEventListener() {
        return new RequestEventListenerAdapter();
    }

    public Publisher<RequestEvent> stormpathRequestEventPublisher() {
        ArrayList<Object> listeners = new ArrayList<Object>();
        listeners.add(new TokenRevocationRequestEventListener());
        listeners.add(this.stormpathRequestEventListener());
        return new RequestEventPublisher(listeners);
    }

    public String stormpathCsrfTokenSigningKey() {
        return this.client.getApiKey().getSecret();
    }

    public JwtAccountResolver stormpathJwtAccountResolver() {
        return new DefaultJwtAccountResolver(this.stormpathJwtSigningKeyResolver());
    }

    public Cache<String, String> stormpathNonceCache() {
        return this.client.getCacheManager().getCache(this.nonceCacheName);
    }

    public CsrfTokenManager stormpathCsrfTokenManager() {
        if (this.csrfTokenEnabled) {
            return new DefaultCsrfTokenManager(this.csrfTokenName, this.stormpathNonceCache(), this.stormpathCsrfTokenSigningKey(), this.csrfTokenTtl);
        }
        return new DisabledCsrfTokenManager(this.csrfTokenName);
    }

    public RequestFieldValueResolver stormpathFieldValueResolver() {
        ContentNegotiatingFieldValueResolver contentNegotiatingFieldValueResolver = new ContentNegotiatingFieldValueResolver();
        contentNegotiatingFieldValueResolver.setProduces(this.stormpathProducedMediaTypes());
        return contentNegotiatingFieldValueResolver;
    }

    public AccessTokenResultFactory stormpathAccessTokenResultFactory() {
        return new DefaultAccessTokenResultFactory(this.application);
    }

    public RefreshTokenResultFactory stormpathRefreshTokenResultFactory() {
        return new DefaultRefreshTokenResultFactory(this.application);
    }

    public WrappedServletRequestFactory stormpathWrappedServletRequestFactory() {
        return new DefaultWrappedServletRequestFactory(this.stormpathUsernamePasswordRequestFactory(), this.stormpathAuthenticationResultSaver(), this.stormpathRequestEventPublisher(), this.requestUserPrincipalStrategy, this.requestRemoteUserStrategy);
    }

    public HttpAuthenticationScheme stormpathBasicAuthenticationScheme() {
        return new BasicAuthenticationScheme(this.stormpathUsernamePasswordRequestFactory());
    }

    public HttpAuthenticationScheme stormpathBearerAuthenticationScheme() {
        return new BearerAuthenticationScheme(this.stormpathJwtSigningKeyResolver(), AccessTokenValidationStrategy.fromName((String)this.accessTokenValidationStrategy));
    }

    public List<HttpAuthenticationScheme> stormpathHttpAuthenticationSchemes() {
        return Arrays.asList(this.stormpathBasicAuthenticationScheme(), this.stormpathBearerAuthenticationScheme());
    }

    public HeaderAuthenticator stormpathAuthorizationHeaderAuthenticator() {
        return new AuthorizationHeaderAuthenticator(this.stormpathHttpAuthenticationSchemes(), this.httpAuthenticationChallenge, this.stormpathRequestEventPublisher());
    }

    public Resolver<Account> stormpathAuthorizationHeaderAccountResolver() {
        return new AuthorizationHeaderAccountResolver((HttpAuthenticator)this.stormpathAuthorizationHeaderAuthenticator(), this.callbackUri);
    }

    public Resolver<Account> stormpathCookieAccountResolver() {
        return new CookieAccountResolver(this.stormpathAccessTokenCookieConfig(), this.stormpathRefreshTokenCookieConfig(), this.stormpathJwtAccountResolver(), this.stormpathCookieAuthenticationResultSaver(), this.stormpathAccessTokenResultFactory());
    }

    public Resolver<Account> stormpathSessionAccountResolver() {
        return new SessionAccountResolver();
    }

    public List<Resolver<Account>> stormpathAccountResolvers() {
        ArrayList<Resolver<Account>> resolvers = new ArrayList<Resolver<Account>>(3);
        resolvers.add(this.stormpathAuthorizationHeaderAccountResolver());
        resolvers.add(this.stormpathCookieAccountResolver());
        resolvers.add(this.stormpathSessionAccountResolver());
        return resolvers;
    }

    public Resolver<List<String>> stormpathSubdomainResolver() {
        SubdomainResolver resolver = new SubdomainResolver();
        resolver.setBaseDomainName(this.baseDomainName);
        return resolver;
    }

    public Resolver<String> stormpathOrganizationNameKeyResolver() {
        DefaultOrganizationNameKeyResolver resolver = new DefaultOrganizationNameKeyResolver();
        resolver.setSubdomainResolver(this.stormpathSubdomainResolver());
        return resolver;
    }

    public Resolver<IdSiteOrganizationContext> stormpathIdSiteOrganizationResolver() {
        DefaultIdSiteOrganizationResolver resolver = new DefaultIdSiteOrganizationResolver();
        resolver.setOrganizationNameKeyResolver(this.stormpathOrganizationNameKeyResolver());
        resolver.setUseSubdomain(this.idSiteUseSubdomain);
        resolver.setShowOrganizationField(this.idSiteShowOrganizationField);
        return resolver;
    }

    public Resolver<SamlOrganizationContext> stormpathSamlOrganizationResolver() {
        DefaultSamlOrganizationResolver resolver = new DefaultSamlOrganizationResolver();
        resolver.setOrganizationNameKeyResolver(this.stormpathOrganizationNameKeyResolver());
        return resolver;
    }

    protected Controller createIdSiteController(String idSiteUri) {
        IdSiteController controller = new IdSiteController();
        controller.setServerUriResolver(this.stormpathServerUriResolver());
        controller.setIdSiteUri(idSiteUri);
        controller.setCallbackUri(this.callbackUri);
        controller.setAlreadyLoggedInUri(this.stormpathLoginConfig().getNextUri());
        controller.setIdSiteOrganizationResolver(this.stormpathIdSiteOrganizationResolver());
        controller.setNextUri(this.stormpathLoginConfig().getNextUri());
        controller.init();
        return controller;
    }

    protected Controller stormpathSamlController() {
        SamlController controller = new SamlController();
        controller.setServerUriResolver(this.stormpathServerUriResolver());
        controller.setCallbackUri(this.callbackUri);
        controller.setAlreadyLoggedInUri(this.stormpathLoginConfig().getNextUri());
        controller.setNextUri(this.stormpathLoginConfig().getNextUri());
        controller.setSamlOrganizationResolver(this.stormpathSamlOrganizationResolver());
        controller.init();
        return controller;
    }

    public ErrorModelFactory stormpathLoginErrorModelFactory() {
        return new LoginErrorModelFactory(this.stormpathMessageSource());
    }

    protected String createForwardView(String uri) {
        Assert.hasText((String)"uri cannot be null or empty.");
        assert (uri != null);
        if (!uri.startsWith("forward:")) {
            uri = "forward:" + uri;
        }
        return uri;
    }

    public AccountStoreModelFactory stormpathAccountStoreModelFactory() {
        return new ExternalAccountStoreModelFactory();
    }

    public ControllerConfig stormpathLoginConfig() {
        return new LoginControllerConfig();
    }

    public Controller stormpathLoginController() {
        if (this.idSiteEnabled) {
            return this.createIdSiteController(this.idSiteLoginUri);
        }
        LoginController c = this.configure(new LoginController(), this.stormpathLoginConfig());
        c.setForgotPasswordEnabled(this.stormpathForgotPasswordConfig().isEnabled());
        c.setForgotPasswordUri(this.stormpathForgotPasswordConfig().getUri());
        c.setVerifyEnabled(this.stormpathVerifyConfig().isEnabled());
        c.setVerifyUri(this.stormpathVerifyConfig().getUri());
        c.setRegisterEnabledResolver(this.stormpathRegisterEnabledResolver());
        c.setRegisterUri(this.stormpathRegisterConfig().getUri());
        c.setLogoutUri(this.stormpathLogoutConfig().getUri());
        c.setApplicationResolver(this.stormpathApplicationResolver());
        c.setAuthenticationResultSaver(this.stormpathAuthenticationResultSaver());
        c.setPreLoginHandler(this.loginPreHandler);
        c.setPostLoginHandler(this.loginPostHandler);
        c.setIdSiteEnabled(this.idSiteEnabled);
        c.setCallbackEnabled(this.callbackEnabled);
        this.init(c);
        return c;
    }

    public ControllerConfig stormpathLogoutConfig() {
        return new LogoutControllerConfig();
    }

    public Controller stormpathLogoutController() {
        IdSiteLogoutController c = this.idSiteEnabled ? new IdSiteLogoutController() : new LogoutController();
        c.setNextUri(this.stormpathLogoutConfig().getNextUri());
        c.setProduces(this.stormpathProducedMediaTypes());
        c.setInvalidateHttpSession(this.logoutInvalidateHttpSession);
        if (this.idSiteEnabled) {
            IdSiteLogoutController idslc = c;
            idslc.setServerUriResolver(this.stormpathServerUriResolver());
            idslc.setIdSiteResultUri(this.callbackUri);
            idslc.setIdSiteOrganizationResolver(this.stormpathIdSiteOrganizationResolver());
            c = idslc;
        }
        return this.init(c);
    }

    public ControllerConfig stormpathForgotPasswordConfig() {
        return new ForgotPasswordControllerConfig();
    }

    public Controller stormpathForgotPasswordController() {
        if (this.idSiteEnabled) {
            return this.createIdSiteController(this.idSiteForgotUri);
        }
        ForgotPasswordController c = this.configure(new ForgotPasswordController(), this.stormpathForgotPasswordConfig());
        c.setLoginUri(this.stormpathLoginConfig().getUri());
        c.setAccountStoreResolver(this.stormpathAccountStoreResolver());
        return this.init(c);
    }

    public LocaleResolver stormpathSpringLocaleResolver() {
        if (this.localeResolver != null) {
            return this.localeResolver;
        }
        return new CookieLocaleResolver();
    }

    public LocaleChangeInterceptor stormpathLocaleChangeInterceptor() {
        if (this.localeChangeInterceptor != null) {
            return this.localeChangeInterceptor;
        }
        LocaleChangeInterceptor lci = new LocaleChangeInterceptor();
        lci.setParamName("lang");
        return lci;
    }

    public Set<String> stormpathRequestClientAttributeNames() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(Strings.commaDelimitedListToSet((String)this.requestClientAttributeNames));
        set.add(Client.class.getName());
        return set;
    }

    public Set<String> stormpathRequestApplicationAttributeNames() {
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        set.addAll(Strings.commaDelimitedListToSet((String)this.requestApplicationAttributeNames));
        set.add(Application.class.getName());
        return set;
    }

    public Resolver<Locale> stormpathLocaleResolver() {
        final LocaleResolver localeResolver = this.stormpathSpringLocaleResolver();
        return new Resolver<Locale>(){

            public Locale get(HttpServletRequest request, HttpServletResponse response) {
                return localeResolver.resolveLocale(request);
            }
        };
    }

    public MessageContextRegistrar stormpathMessageContextRegistrar() {
        DefaultMessageContext ctx = new DefaultMessageContext(this.stormpathMessageSource(), this.stormpathLocaleResolver());
        return new MessageContextRegistrar((MessageContext)ctx, this.servletContext);
    }

    public com.stormpath.sdk.servlet.i18n.MessageSource stormpathMessageSource() {
        return new SpringMessageSource(this.messageSource);
    }

    public ControllerConfig stormpathRegisterConfig() {
        return new RegisterControllerConfig();
    }

    public Controller stormpathRegisterController() {
        if (this.idSiteEnabled) {
            return this.createIdSiteController(this.idSiteRegisterUri);
        }
        RegisterController c = this.configure(new RegisterController(), this.stormpathRegisterConfig());
        c.setClient(this.client);
        c.setAuthenticationResultSaver(this.stormpathAuthenticationResultSaver());
        c.setLoginUri(this.stormpathLoginConfig().getUri());
        c.setVerifyViewName(this.stormpathVerifyConfig().getView());
        c.setAutoLogin(this.registerAutoLogin);
        c.setPreRegisterHandler(this.registerPreHandler);
        c.setPostRegisterHandler(this.registerPostHandler);
        c.setAccountStoreResolver(this.stormpathAccountStoreResolver());
        return this.init(c);
    }

    public ControllerConfig stormpathVerifyConfig() {
        return new VerifyControllerConfig();
    }

    public Controller stormpathVerifyController() {
        if (this.idSiteEnabled) {
            return this.createIdSiteController(null);
        }
        VerifyController c = this.configure(new VerifyController(), this.stormpathVerifyConfig());
        c.setLoginUri(this.stormpathLoginConfig().getUri());
        c.setLoginNextUri(this.stormpathLoginConfig().getNextUri());
        c.setClient(this.client);
        c.setAutoLogin(this.registerAutoLogin);
        c.setAuthenticationResultSaver(this.stormpathAuthenticationResultSaver());
        c.setAccountStoreResolver(this.stormpathAccountStoreResolver());
        return this.init(c);
    }

    public ChangePasswordControllerConfig stormpathChangePasswordConfig() {
        return new ChangePasswordControllerConfig();
    }

    public Controller stormpathChangePasswordController() {
        if (this.idSiteEnabled) {
            return this.createIdSiteController(null);
        }
        ChangePasswordController c = this.configure(new ChangePasswordController(), (ControllerConfig)this.stormpathChangePasswordConfig());
        c.setForgotPasswordUri(this.stormpathForgotPasswordConfig().getUri());
        c.setLoginUri(this.stormpathLoginConfig().getUri());
        c.setLoginNextUri(this.stormpathLoginConfig().getNextUri());
        c.setErrorUri(this.stormpathChangePasswordConfig().getErrorUri());
        c.setAutoLogin(this.stormpathChangePasswordConfig().isAutoLogin());
        c.setAuthenticationResultSaver(this.stormpathAuthenticationResultSaver());
        return this.init(c);
    }

    public Controller stormpathAccessTokenController() {
        AccessTokenController c = new AccessTokenController();
        c.setEventPublisher(this.stormpathRequestEventPublisher());
        c.setAccessTokenAuthenticationRequestFactory(this.stormpathAccessTokenAuthenticationRequestFactory());
        c.setAccessTokenResultFactory(this.stormpathAccessTokenResultFactory());
        c.setRefreshTokenAuthenticationRequestFactory(this.stormpathRefreshTokenAuthenticationRequestFactory());
        c.setRefreshTokenResultFactory(this.stormpathRefreshTokenResultFactory());
        c.setAccountSaver(this.stormpathAuthenticationResultSaver());
        c.setRequestAuthorizer(this.stormpathAccessTokenRequestAuthorizer());
        c.setBasicAuthenticationScheme(this.stormpathBasicAuthenticationScheme());
        return this.init(c);
    }

    public Controller stormpathIdSiteResultController() {
        IdSiteResultController controller = new IdSiteResultController();
        controller.setLoginNextUri(this.stormpathLoginConfig().getNextUri());
        controller.setRegisterNextUri(this.stormpathRegisterConfig().getNextUri());
        controller.setLogoutController(this.stormpathLogoutController());
        controller.setAuthenticationResultSaver(this.stormpathAuthenticationResultSaver());
        controller.setEventPublisher(this.stormpathRequestEventPublisher());
        if (this.springSecurityIdSiteResultListener != null) {
            controller.addIdSiteResultListener(this.springSecurityIdSiteResultListener);
        }
        controller.init();
        return controller;
    }

    public Controller stormpathMeController() {
        ArrayList<String> expandedAccountAttributes = new ArrayList<String>();
        AbstractStormpathWebMvcConfiguration.getPropertiesStartingWith((ConfigurableEnvironment)this.environment, "stormpath.web.me.expand");
        Pattern pattern = Pattern.compile("^stormpath\\.web\\.me\\.expand\\.(\\w+)$");
        for (String key : AbstractStormpathWebMvcConfiguration.getPropertiesStartingWith((ConfigurableEnvironment)this.environment, "stormpath.web.me.expand").keySet()) {
            Matcher matcher = pattern.matcher(key);
            if (!matcher.find() || !((Boolean)this.environment.getProperty(key, Boolean.class, (Object)false)).booleanValue()) continue;
            expandedAccountAttributes.add(matcher.group(1));
        }
        MeController controller = new MeController();
        controller.setExpands(expandedAccountAttributes);
        controller.setObjectMapper(this.objectMapper);
        controller.setProduces(this.stormpathProducedMediaTypes());
        controller.setUri(this.meUri);
        controller.setLoginPageRedirector((LoginPageRedirector)new DefaultLoginPageRedirector(this.stormpathLoginConfig().getUri()));
        controller.setApplicationResolver(this.stormpathApplicationResolver());
        this.init(controller);
        return controller;
    }

    public Controller stormpathSamlResultController() {
        SamlResultController controller = new SamlResultController();
        controller.setLoginNextUri(this.stormpathLoginConfig().getNextUri());
        controller.setLogoutController(this.stormpathLogoutController());
        controller.setAuthenticationResultSaver(this.stormpathAuthenticationResultSaver());
        controller.setEventPublisher(this.stormpathRequestEventPublisher());
        if (this.springSecuritySamlResultListener != null) {
            controller.addSamlResultListener(this.springSecuritySamlResultListener);
        }
        controller.init();
        return controller;
    }

    public AccessTokenAuthenticationRequestFactory stormpathAccessTokenAuthenticationRequestFactory() {
        return new DefaultAccessTokenAuthenticationRequestFactory(this.stormpathAccountStoreResolver());
    }

    public RefreshTokenAuthenticationRequestFactory stormpathRefreshTokenAuthenticationRequestFactory() {
        return new DefaultRefreshTokenAuthenticationRequestFactory();
    }

    public RequestAuthorizer stormpathAccessTokenRequestAuthorizer() {
        return new DefaultAccessTokenRequestAuthorizer(this.stormpathSecureResolver(), this.stormpathOriginAccessTokenRequestAuthorizer());
    }

    public Set<String> stormpathAccessTokenAuthorizedOriginUris() {
        return Strings.delimitedListToSet((String)this.accessTokenAuthorizedOriginUris, (String)" \t");
    }

    public RequestAuthorizer stormpathOriginAccessTokenRequestAuthorizer() {
        return new OriginAccessTokenRequestAuthorizer(this.stormpathServerUriResolver(), this.stormpathLocalhostResolver(), this.stormpathAccessTokenAuthorizedOriginUris(), this.stormpathProducedMediaTypes());
    }

    public ServerUriResolver stormpathServerUriResolver() {
        return new DefaultServerUriResolver();
    }

    public AccountResolver stormpathAccountResolver() {
        return new DefaultAccountResolver();
    }

    public ContentNegotiationResolver stormpathContentNegotiationResolver() {
        return new DefaultContentNegotiationResolver();
    }

    private void configure(AbstractController c) {
        c.setAccountResolver(this.stormpathAccountResolver());
        c.setContentNegotiationResolver(this.stormpathContentNegotiationResolver());
        c.setEventPublisher(this.stormpathRequestEventPublisher());
        c.setLocaleResolver(this.stormpathLocaleResolver());
        c.setMessageSource(this.stormpathMessageSource());
        c.setProduces(this.stormpathProducedMediaTypes());
    }

    private <T extends FormController> T configure(T c, ControllerConfig cr) {
        this.configure((AbstractController)c);
        c.setUri(cr.getUri());
        c.setNextUri(cr.getNextUri());
        c.setView(cr.getView());
        c.setControllerKey(cr.getControllerKey());
        c.setCsrfTokenManager(this.stormpathCsrfTokenManager());
        c.setFieldValueResolver(this.stormpathFieldValueResolver());
        List fields = cr.getFormFields();
        if (!Collections.isEmpty((Collection)fields)) {
            c.setFormFields(fields);
        }
        return c;
    }

    private <T extends AbstractSocialCallbackController> T configure(T c) {
        this.configure((AbstractController)c);
        c.setNextUri(this.stormpathLoginConfig().getUri());
        c.setAuthenticationResultSaver(this.stormpathAuthenticationResultSaver());
        c.setApplicationResolver(this.stormpathApplicationResolver());
        return c;
    }

    private <T extends AbstractController> T init(T c) {
        try {
            c.init();
            return c;
        }
        catch (Exception e) {
            String msg = "Unable to initialize controller [" + c + "]: " + e.getMessage();
            throw new BeanInitializationException(msg, (Throwable)e);
        }
    }

    private Filter wrapForSpringLocaleSupport(final Filter filter) {
        return new Filter(){

            public void init(FilterConfig filterConfig) throws ServletException {
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
                HttpServletRequest req = (HttpServletRequest)request;
                HttpServletResponse resp = (HttpServletResponse)response;
                ServletRequestAttributes attributes = new ServletRequestAttributes(req, resp);
                try {
                    RequestContextHolder.setRequestAttributes((RequestAttributes)attributes);
                    AbstractStormpathWebMvcConfiguration.this.stormpathLocaleChangeInterceptor().preHandle(req, resp, null);
                    filter.doFilter((ServletRequest)req, (ServletResponse)resp, chain);
                }
                finally {
                    RequestContextHolder.resetRequestAttributes();
                }
            }

            public void destroy() {
            }
        };
    }

    private Filter createFilter(Controller controller, String name) {
        try {
            ControllerFilter filter = new ControllerFilter();
            filter.setViewResolver(this.stormpathControllerViewResolver());
            filter.setProducedMediaTypes(this.stormpathProducedMediaTypes());
            filter.setController(controller);
            Filter f = Filters.builder().setFilter((Filter)filter).setServletContext(this.servletContext).setName(name).build();
            return this.wrapForSpringLocaleSupport(f);
        }
        catch (ServletException e) {
            String msg = "Unable to create filter '" + name + "' to wrap controller [" + controller + "]: " + e.getMessage();
            throw new BeanCreationException(msg, (Throwable)e);
        }
    }

    private void addFilter(DefaultFilterChainManager mgr, Controller controller, ControllerConfig config) throws ServletException {
        this.addFilter(mgr, controller, config.getControllerKey(), config.getUri());
    }

    private void addFilter(DefaultFilterChainManager mgr, Controller controller, String name, String uri) throws ServletException {
        Filter filter = this.createFilter(controller, name);
        mgr.addFilter(name, (Object)filter);
        mgr.createChain(uri, name);
    }

    private void addMeFilter(DefaultFilterChainManager mgr) throws ServletException {
        String name = "me";
        MeFilter meFilter = new MeFilter();
        meFilter.setProducedMediaTypes(this.stormpathProducedMediaTypes());
        meFilter.setController(this.stormpathMeController());
        Filter f = Filters.builder().setFilter((Filter)meFilter).setServletContext(this.servletContext).setName(name).build();
        mgr.addFilter(name, (Object)f);
        mgr.createChain(this.meUri, name);
    }

    public FilterChainResolver stormpathFilterChainResolver() {
        PathMatchingFilterChainResolver resolver = new PathMatchingFilterChainResolver(this.servletContext);
        resolver.setFilterChainManager(this.stormpathFilterChainManager());
        if (this.pathMatcher != null) {
            resolver.setPathMatcher((PatternMatcher)new SpringPatternMatcher(this.pathMatcher));
        }
        AccountResolverFilter accountResolverFilter = new AccountResolverFilter();
        accountResolverFilter.setEnabled(this.stormpathFilterEnabled);
        accountResolverFilter.setResolvers(this.stormpathAccountResolvers());
        accountResolverFilter.setOauthEndpointUri(this.accessTokenUri);
        List priorityFilters = Collections.toList((Object[])new Filter[]{accountResolverFilter});
        return new PrioritizedFilterChainResolver((FilterChainResolver)resolver, priorityFilters);
    }

    public FilterChainManager stormpathFilterChainManager() {
        DefaultFilterChainManager mgr = new DefaultFilterChainManager(this.servletContext);
        try {
            this.addRoutes(mgr);
            return mgr;
        }
        catch (ServletException e) {
            String msg = "Could not create Filter Chain Manager: " + e.getMessage();
            throw new BeanCreationException(msg, (Throwable)e);
        }
    }

    protected StormpathFilter newStormpathFilter() {
        StormpathFilter filter = new StormpathFilter();
        filter.setClient(this.client);
        filter.setApplication(this.application);
        filter.setEnabled(this.stormpathFilterEnabled);
        filter.setClientRequestAttributeNames(this.stormpathRequestClientAttributeNames());
        filter.setApplicationRequestAttributeNames(this.stormpathRequestApplicationAttributeNames());
        filter.setFilterChainResolver(this.stormpathFilterChainResolver());
        filter.setWrappedServletRequestFactory(this.stormpathWrappedServletRequestFactory());
        return filter;
    }

    public static Map<String, Object> getPropertiesStartingWith(ConfigurableEnvironment aEnv, String aKeyPrefix) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        Map<String, Object> map = AbstractStormpathWebMvcConfiguration.getAllProperties(aEnv);
        for (Map.Entry<String, Object> entry : map.entrySet()) {
            String key = entry.getKey();
            if (!key.startsWith(aKeyPrefix)) continue;
            result.put(key, entry.getValue());
        }
        return result;
    }

    protected static Map<String, Object> getAllProperties(ConfigurableEnvironment aEnv) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        for (PropertySource propertySource : aEnv.getPropertySources()) {
            AbstractStormpathWebMvcConfiguration.addAll(result, AbstractStormpathWebMvcConfiguration.getAllProperties(propertySource));
        }
        return result;
    }

    protected static Map<String, Object> getAllProperties(PropertySource<?> aPropSource) {
        HashMap<String, Object> result = new HashMap<String, Object>();
        if (aPropSource instanceof CompositePropertySource) {
            CompositePropertySource cps = (CompositePropertySource)aPropSource;
            for (PropertySource propertySource : cps.getPropertySources()) {
                AbstractStormpathWebMvcConfiguration.addAll(result, AbstractStormpathWebMvcConfiguration.getAllProperties(propertySource));
            }
            return result;
        }
        if (aPropSource instanceof EnumerablePropertySource) {
            EnumerablePropertySource ps = (EnumerablePropertySource)aPropSource;
            for (String propertyName : ps.getPropertyNames()) {
                result.put(propertyName, ps.getProperty(propertyName));
            }
            return result;
        }
        return result;
    }

    private static void addAll(Map<String, Object> aBase, Map<String, Object> aToBeAdded) {
        for (Map.Entry<String, Object> entry : aToBeAdded.entrySet()) {
            if (aBase.containsKey(entry.getKey())) continue;
            aBase.put(entry.getKey(), entry.getValue());
        }
    }

    protected static class DisabledAuthenticationResultSaver
    implements Saver<AuthenticationResult> {
        protected static final DisabledAuthenticationResultSaver INSTANCE = new DisabledAuthenticationResultSaver();

        protected DisabledAuthenticationResultSaver() {
        }

        public void set(HttpServletRequest request, HttpServletResponse response, AuthenticationResult value) {
        }
    }

    private static class AccessibleResourceHandlerRegistry
    extends ResourceHandlerRegistry {
        public AccessibleResourceHandlerRegistry(ApplicationContext applicationContext, ServletContext servletContext) {
            super(applicationContext, servletContext);
        }

        public HandlerMapping toHandlerMapping() {
            return this.getHandlerMapping();
        }
    }
}

