/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.mvc;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.mvc.ViewModel;
import com.stormpath.sdk.servlet.util.RedirectUrlBuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;
import org.springframework.ui.ModelMap;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.LocaleResolver;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.View;
import org.springframework.web.servlet.ViewResolver;
import org.springframework.web.servlet.support.RequestContextUtils;
import org.springframework.web.servlet.view.RedirectView;

public class SpringView
implements com.stormpath.sdk.servlet.mvc.View {
    private static final Logger log = LoggerFactory.getLogger(SpringView.class);
    private final LocaleResolver localeResolver;
    private final List<ViewResolver> viewResolvers;
    private final HandlerInterceptor handlerInterceptor;

    public SpringView(Collection<ViewResolver> viewResolvers, LocaleResolver localeResolver, HandlerInterceptor templateHandlerInterceptor) {
        Assert.notEmpty(viewResolvers, (String)"viewResolvers cannot be null or empty.");
        Assert.notNull((Object)localeResolver, (String)"localeResolver cannot be null.");
        Assert.notNull((Object)templateHandlerInterceptor, (String)"templateHandlerInterceptor cannot be null.");
        this.handlerInterceptor = templateHandlerInterceptor;
        ArrayList<ViewResolver> l = new ArrayList<ViewResolver>(viewResolvers);
        AnnotationAwareOrderComparator.sort(l);
        this.viewResolvers = l;
        this.localeResolver = localeResolver;
    }

    public void render(HttpServletRequest request, HttpServletResponse response, ViewModel vm) throws Exception {
        ModelAndView mav = this.convert(vm, request);
        this.handlerInterceptor.postHandle(request, response, null, mav);
        this.render(mav, request, response);
    }

    private ModelAndView convert(ViewModel vm, HttpServletRequest request) {
        String viewName = vm.getViewName();
        Assert.hasText((String)viewName, (String)"ViewModel must contain a viewName.");
        Map model = vm.getModel();
        boolean redirect = vm.isRedirect();
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addAllObjects(RequestContextUtils.getInputFlashMap((HttpServletRequest)request));
        modelAndView.addAllObjects(model);
        if (redirect) {
            String targetUrl = new RedirectUrlBuilder(request).setUrl(viewName).setContextRelative(true).build();
            modelAndView.setView((View)new RedirectView(targetUrl));
        } else {
            modelAndView.setViewName(viewName);
        }
        return modelAndView;
    }

    private void render(ModelAndView mav, HttpServletRequest request, HttpServletResponse response) throws Exception {
        View view;
        Locale locale = this.localeResolver.resolveLocale(request);
        response.setLocale(locale);
        ModelMap model = mav.getModelMap();
        if (mav.isReference()) {
            view = this.resolveViewName(mav.getViewName(), (Map<String, Object>)model, locale, request);
            if (view == null) {
                throw new ServletException("Could not resolve view with name '" + mav.getViewName() + "'");
            }
        } else {
            view = mav.getView();
            if (view == null) {
                throw new ServletException("ModelAndView [" + mav + "] neither contains a view name nor a View object.");
            }
        }
        log.debug("Rendering Spring view [{}]", (Object)view);
        try {
            view.render((Map)model, request, response);
        }
        catch (Exception ex) {
            if (log.isDebugEnabled()) {
                log.debug("Error rendering Spring view [" + view + "].", (Throwable)ex);
            }
            throw ex;
        }
    }

    private View resolveViewName(String viewName, Map<String, Object> model, Locale locale, HttpServletRequest request) throws Exception {
        for (ViewResolver viewResolver : this.viewResolvers) {
            View view = viewResolver.resolveViewName(viewName, locale);
            if (view == null) continue;
            return view;
        }
        return null;
    }
}

