/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.errors;

import com.stormpath.spring.errors.CustomParameterizedException;
import com.stormpath.spring.errors.Error;
import com.stormpath.spring.errors.ParameterizedError;
import java.util.List;
import org.springframework.core.annotation.AnnotationUtils;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.validation.BindingResult;
import org.springframework.validation.FieldError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.MethodArgumentNotValidException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.bind.annotation.ResponseStatus;
import org.springframework.web.servlet.NoHandlerFoundException;

@ControllerAdvice
public class ExceptionTranslator {
    @ExceptionHandler(value={MethodArgumentNotValidException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public Error processValidationError(MethodArgumentNotValidException ex) {
        BindingResult result = ex.getBindingResult();
        List fieldErrors = result.getFieldErrors();
        return this.processFieldErrors(fieldErrors);
    }

    @ExceptionHandler(value={CustomParameterizedException.class})
    @ResponseStatus(value=HttpStatus.BAD_REQUEST)
    @ResponseBody
    public ParameterizedError processParameterizedValidationError(CustomParameterizedException ex) {
        return ex.getErrorDTO();
    }

    @ExceptionHandler(value={NoHandlerFoundException.class})
    @ResponseStatus(value=HttpStatus.NOT_FOUND)
    @ResponseBody
    public Error processPageNotFoundException(NoHandlerFoundException e) {
        return new Error("error.pageNotFound", e.getMessage());
    }

    private Error processFieldErrors(List<FieldError> fieldErrors) {
        Error dto = new Error("error.validation");
        for (FieldError fieldError : fieldErrors) {
            dto.add(fieldError.getObjectName(), fieldError.getField(), fieldError.getCode());
        }
        return dto;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    @ResponseBody
    @ResponseStatus(value=HttpStatus.METHOD_NOT_ALLOWED)
    public Error processMethodNotSupportedException(HttpRequestMethodNotSupportedException exception) {
        return new Error("error.methodNotSupported", exception.getMessage());
    }

    @ExceptionHandler(value={Exception.class})
    public ResponseEntity<Error> processRuntimeException(Exception ex) throws Exception {
        Error error;
        ResponseEntity.BodyBuilder builder;
        ResponseStatus responseStatus = (ResponseStatus)AnnotationUtils.findAnnotation(ex.getClass(), ResponseStatus.class);
        if (responseStatus != null) {
            builder = ResponseEntity.status((HttpStatus)responseStatus.value());
            error = new Error("error." + responseStatus.value().value(), responseStatus.reason());
        } else {
            builder = ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR);
            error = new Error("error.internalServerError", "Internal server error");
        }
        return builder.body((Object)error);
    }
}

