/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.mvc;

import com.stormpath.sdk.lang.Assert;
import com.stormpath.sdk.servlet.i18n.MessageSource;
import java.util.Locale;
import org.springframework.context.NoSuchMessageException;

public class SpringMessageSource
implements MessageSource {
    private final org.springframework.context.MessageSource delegate;

    public SpringMessageSource(org.springframework.context.MessageSource delegate) {
        Assert.notNull((Object)"delegate Spring MessageSource cannot be null.");
        this.delegate = delegate;
    }

    public String getMessage(String key, Locale locale) {
        return this.getMessage(key, locale, new Object[0]);
    }

    public String getMessage(String key, String defaultMessage, Locale locale, Object ... args) {
        try {
            return this.delegate.getMessage(key, args, locale);
        }
        catch (NoSuchMessageException e) {
            return defaultMessage;
        }
    }

    public String getMessage(String key, String defaultMessage, Locale locale) {
        try {
            return this.delegate.getMessage(key, new Object[0], locale);
        }
        catch (NoSuchMessageException e) {
            return defaultMessage;
        }
    }

    public String getMessage(String key, Locale locale, Object ... args) {
        try {
            return this.delegate.getMessage(key, args, locale);
        }
        catch (NoSuchMessageException e) {
            return '!' + key + '!';
        }
    }
}

