/*
 * Decompiled with CFR 0.152.
 */
package com.stormpath.spring.mvc;

import com.stormpath.sdk.lang.Strings;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class TemplateLayoutInterceptor
extends HandlerInterceptorAdapter
implements InitializingBean {
    public static final String HEAD_VIEW_NAME_KEY = "headViewName";
    public static final String HEAD_FRAGMENT_SELECTOR_KEY = "headFragmentSelector";
    public static final String HEAD_CSS_URIS_KEY = "headCssUris";
    private String headViewName;
    private String headFragmentSelector;
    private List<String> headCssUris;

    public String getHeadViewName() {
        return this.headViewName;
    }

    public void setHeadViewName(String headViewName) {
        this.headViewName = headViewName;
    }

    public String getHeadFragmentSelector() {
        return this.headFragmentSelector;
    }

    public void setHeadFragmentSelector(String headFragmentSelector) {
        this.headFragmentSelector = headFragmentSelector;
    }

    public List<String> getHeadCssUris() {
        return this.headCssUris;
    }

    public void setHeadCssUris(List<String> headCssUris) {
        this.headCssUris = headCssUris;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.hasText((String)this.headViewName, (String)"headViewName must be specified.");
    }

    protected boolean shouldExecute(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) {
        if (modelAndView == null || !modelAndView.isReference() || "stormpathJsonView".equals(modelAndView.getViewName())) {
            return false;
        }
        String viewName = modelAndView.getViewName();
        return !this.isRedirectOrForward(viewName);
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
        if (!this.shouldExecute(request, response, handler, modelAndView)) {
            return;
        }
        if (!modelAndView.getModel().containsKey(HEAD_VIEW_NAME_KEY)) {
            modelAndView.addObject(HEAD_VIEW_NAME_KEY, (Object)this.headViewName);
        }
        if (Strings.hasText((String)this.headFragmentSelector) && !modelAndView.getModel().containsKey(HEAD_FRAGMENT_SELECTOR_KEY)) {
            modelAndView.addObject(HEAD_FRAGMENT_SELECTOR_KEY, (Object)this.headFragmentSelector);
        }
        if (!CollectionUtils.isEmpty(this.headCssUris) && !modelAndView.getModel().containsKey(HEAD_CSS_URIS_KEY)) {
            ArrayList<String> modified = new ArrayList<String>(this.headCssUris.size());
            for (String uri : this.headCssUris) {
                if (uri.startsWith("http") || uri.startsWith("//")) {
                    modified.add(uri);
                    continue;
                }
                String contextPath = request.getContextPath();
                String contextRelative = contextPath + uri;
                modified.add(contextRelative);
            }
            modelAndView.addObject(HEAD_CSS_URIS_KEY, modified);
        }
    }

    private boolean isRedirectOrForward(String viewName) {
        return viewName.startsWith("redirect:") || viewName.startsWith("forward:");
    }
}

