/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.archunit.junit;

import com.tngtech.archunit.Internal;
import com.tngtech.archunit.PublicAPI;
import com.tngtech.archunit.core.domain.JavaClasses;
import com.tngtech.archunit.core.importer.ImportOption;
import com.tngtech.archunit.junit.AnalyzeClasses;
import com.tngtech.archunit.junit.ArchRuleDeclaration;
import com.tngtech.archunit.junit.ArchRuleExecution;
import com.tngtech.archunit.junit.ArchRules;
import com.tngtech.archunit.junit.ArchTest;
import com.tngtech.archunit.junit.ArchTestExecution;
import com.tngtech.archunit.junit.ArchTestInitializationException;
import com.tngtech.archunit.junit.ArchTestMethodExecution;
import com.tngtech.archunit.junit.ArchTests;
import com.tngtech.archunit.junit.CacheMode;
import com.tngtech.archunit.junit.ClassAnalysisRequest;
import com.tngtech.archunit.junit.ClassCache;
import com.tngtech.archunit.junit.LocationProvider;
import com.tngtech.archunit.thirdparty.com.google.common.collect.ImmutableSet;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.ParentRunner;
import org.junit.runners.model.FrameworkField;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;

@PublicAPI(usage=PublicAPI.Usage.ACCESS)
public class ArchUnitRunner
extends ParentRunner<ArchTestExecution> {
    private SharedCache cache = new SharedCache();

    @Internal
    public ArchUnitRunner(Class<?> testClass) throws InitializationError {
        super(testClass);
        ArchUnitRunner.checkAnnotation(testClass);
    }

    private static AnalyzeClasses checkAnnotation(Class<?> testClass) {
        AnalyzeClasses analyzeClasses = testClass.getAnnotation(AnalyzeClasses.class);
        ArchTestInitializationException.check(analyzeClasses != null, "Class %s must be annotated with @%s", testClass.getSimpleName(), AnalyzeClasses.class.getSimpleName());
        return analyzeClasses;
    }

    protected Statement classBlock(RunNotifier notifier) {
        final Statement statement = super.classBlock(notifier);
        return new Statement(){

            public void evaluate() throws Throwable {
                try {
                    statement.evaluate();
                }
                finally {
                    ArchUnitRunner.this.cache.clear(ArchUnitRunner.this.getTestClass().getJavaClass());
                }
            }
        };
    }

    protected List<ArchTestExecution> getChildren() {
        ArrayList<ArchTestExecution> children = new ArrayList<ArchTestExecution>();
        children.addAll(this.findArchRuleFields());
        children.addAll(this.findArchRuleMethods());
        return children;
    }

    private Collection<ArchTestExecution> findArchRuleFields() {
        ArrayList<ArchTestExecution> result = new ArrayList<ArchTestExecution>();
        for (FrameworkField ruleField : this.getTestClass().getAnnotatedFields(ArchTest.class)) {
            result.addAll(this.findArchRulesIn(ruleField));
        }
        return result;
    }

    private Set<ArchTestExecution> findArchRulesIn(FrameworkField ruleField) {
        boolean ignore = ArchRuleDeclaration.elementShouldBeIgnored(ruleField.getField());
        if (ruleField.getType() == ArchTests.class || ruleField.getType() == ArchRules.class) {
            return this.asTestExecutions(this.getArchRules(ruleField.getField()), ignore);
        }
        return Collections.singleton(new ArchRuleExecution(this.getTestClass().getJavaClass(), ruleField.getField(), ignore));
    }

    private Set<ArchTestExecution> asTestExecutions(ArchTests archTests, boolean forceIgnore) {
        ExecutionTransformer executionTransformer = new ExecutionTransformer();
        for (ArchRuleDeclaration<?> declaration : ArchRuleDeclaration.toDeclarations(archTests, this.getTestClass().getJavaClass(), ArchTest.class, forceIgnore)) {
            declaration.handleWith(executionTransformer);
        }
        return executionTransformer.getExecutions();
    }

    private ArchTests getArchRules(Field field) {
        return ArchTests.from(ArchTestExecution.getValue(field, field.getDeclaringClass()));
    }

    private Collection<ArchTestExecution> findArchRuleMethods() {
        ArrayList<ArchTestExecution> result = new ArrayList<ArchTestExecution>();
        for (FrameworkMethod testMethod : this.getTestClass().getAnnotatedMethods(ArchTest.class)) {
            boolean ignore = ArchRuleDeclaration.elementShouldBeIgnored(testMethod.getMethod());
            result.add(new ArchTestMethodExecution(this.getTestClass().getJavaClass(), testMethod.getMethod(), ignore));
        }
        return result;
    }

    protected Description describeChild(ArchTestExecution child) {
        return child.describeSelf();
    }

    protected void runChild(ArchTestExecution child, RunNotifier notifier) {
        if (child.ignore()) {
            notifier.fireTestIgnored(this.describeChild(child));
        } else {
            notifier.fireTestStarted(this.describeChild(child));
            Class testClass = this.getTestClass().getJavaClass();
            JavaClasses classes = this.cache.get().getClassesToAnalyzeFor(testClass, new JUnit4ClassAnalysisRequest(testClass));
            child.evaluateOn(classes).notify(notifier);
            notifier.fireTestFinished(this.describeChild(child));
        }
    }

    static class SharedCache {
        private static final ClassCache cache = new ClassCache();

        SharedCache() {
        }

        ClassCache get() {
            return cache;
        }

        void clear(Class<?> testClass) {
            cache.clear(testClass);
        }
    }

    private static class ExecutionTransformer
    implements ArchRuleDeclaration.Handler {
        private final ImmutableSet.Builder<ArchTestExecution> executions = ImmutableSet.builder();

        private ExecutionTransformer() {
        }

        @Override
        public void handleFieldDeclaration(Field field, Class<?> fieldOwner, boolean ignore) {
            this.executions.add((Object)new ArchRuleExecution(fieldOwner, field, ignore));
        }

        @Override
        public void handleMethodDeclaration(Method method, Class<?> methodOwner, boolean ignore) {
            this.executions.add((Object)new ArchTestMethodExecution(methodOwner, method, ignore));
        }

        Set<ArchTestExecution> getExecutions() {
            return this.executions.build();
        }
    }

    private static class JUnit4ClassAnalysisRequest
    implements ClassAnalysisRequest {
        private final AnalyzeClasses analyzeClasses;

        JUnit4ClassAnalysisRequest(Class<?> testClass) {
            this.analyzeClasses = ArchUnitRunner.checkAnnotation(testClass);
        }

        @Override
        public String[] getPackageNames() {
            return this.analyzeClasses.packages();
        }

        @Override
        public Class<?>[] getPackageRoots() {
            return this.analyzeClasses.packagesOf();
        }

        @Override
        public Class<? extends LocationProvider>[] getLocationProviders() {
            return this.analyzeClasses.locations();
        }

        @Override
        public Class<? extends ImportOption>[] getImportOptions() {
            return this.analyzeClasses.importOptions();
        }

        @Override
        public CacheMode getCacheMode() {
            return this.analyzeClasses.cacheMode();
        }
    }
}

