/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.propertyloader;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import javax.crypto.Cipher;
import javax.crypto.SecretKey;
import javax.crypto.SecretKeyFactory;
import javax.crypto.spec.PBEKeySpec;
import javax.crypto.spec.SecretKeySpec;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Obfuscator {
    private static final String ENCRYPTION_ALGORITHM = "Blowfish";
    private static final String ENCRYPTION_ALGORITHM_MODIFIER = "/ECB/PKCS5Padding";
    private BASE64Encoder base64Encoder = new BASE64Encoder();
    private BASE64Decoder base64Decoder = new BASE64Decoder();
    private String encoding = "UTF-8";
    private SecretKeySpec dataEncryptionSecretKeySpec;

    public Obfuscator(String password) {
        byte[] salt = new byte[]{65, 110, 100, 114, 111, 105, 100, 75, 105, 116, 75, 97, 116, 13, 1, 20, 20, 9, 1, 19};
        try {
            SecretKeyFactory factory = SecretKeyFactory.getInstance("PBKDF2WithHmacSHA1");
            SecretKey tmp = factory.generateSecret(new PBEKeySpec(password.toCharArray(), salt, 100, 128));
            this.dataEncryptionSecretKeySpec = new SecretKeySpec(tmp.getEncoded(), ENCRYPTION_ALGORITHM);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String encrypt(String toEncrypt) {
        byte[] encryptedBytes = this.encryptInternal(this.dataEncryptionSecretKeySpec, toEncrypt);
        return this.base64Encoder.encodeBuffer(encryptedBytes);
    }

    private byte[] encryptInternal(SecretKeySpec key, String toEncrypt) {
        try {
            Cipher cipher = Cipher.getInstance("Blowfish/ECB/PKCS5Padding");
            cipher.init(1, key);
            return cipher.doFinal(toEncrypt.getBytes(this.encoding));
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Exception during decryptInternal: " + e, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Exception during encryptInternal: " + e, e);
        }
    }

    public String decrypt(String toDecrypt) {
        try {
            byte[] encryptedBytes = this.base64Decoder.decodeBuffer(toDecrypt);
            return this.decryptInternal(this.dataEncryptionSecretKeySpec, encryptedBytes);
        }
        catch (IOException e) {
            throw new RuntimeException("Exception during decodeBase64: " + e, e);
        }
    }

    private String decryptInternal(SecretKeySpec key, byte[] encryptedBytes) {
        try {
            Cipher cipher = Cipher.getInstance("Blowfish/ECB/PKCS5Padding");
            cipher.init(2, key);
            byte[] decryptedBytes = cipher.doFinal(encryptedBytes);
            return new String(decryptedBytes, this.encoding);
        }
        catch (GeneralSecurityException e) {
            throw new RuntimeException("Exception during decryptInternal: " + e, e);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException("Exception during encryptInternal: " + e, e);
        }
    }
}

