/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.propertyloader;

import com.tngtech.propertyloader.exception.PropertyLoaderException;
import com.tngtech.propertyloader.impl.DefaultPropertyFilterContainer;
import com.tngtech.propertyloader.impl.DefaultPropertyLocationContainer;
import com.tngtech.propertyloader.impl.DefaultPropertySuffixContainer;
import com.tngtech.propertyloader.impl.PropertyFileReader;
import com.tngtech.propertyloader.impl.PropertyLoaderFactory;
import com.tngtech.propertyloader.impl.helpers.HostsHelper;
import com.tngtech.propertyloader.impl.helpers.PropertyFileNameHelper;
import com.tngtech.propertyloader.impl.interfaces.PropertyFilterContainer;
import com.tngtech.propertyloader.impl.interfaces.PropertyLoaderFilter;
import com.tngtech.propertyloader.impl.interfaces.PropertyLoaderOpener;
import com.tngtech.propertyloader.impl.interfaces.PropertyLocationsContainer;
import com.tngtech.propertyloader.impl.interfaces.PropertySuffixContainer;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Stack;

public class PropertyLoader
implements PropertyLocationsContainer<PropertyLoader>,
PropertySuffixContainer<PropertyLoader>,
PropertyFilterContainer<PropertyLoader> {
    private static final String INCLUDE_KEY = "$include";
    private final PropertyFileNameHelper propertyFileNameHelper;
    private final PropertyFileReader propertyFileReader;
    private final PropertyLoaderFactory propertyLoaderFactory;
    private String propertyFileEncoding = "ISO-8859-1";
    private List<String> baseNames = new ArrayList<String>();
    private String fileExtension = "properties";
    private DefaultPropertySuffixContainer propertySuffix;
    private DefaultPropertyLocationContainer propertyLocation;
    private DefaultPropertyFilterContainer propertyLoaderFilters;
    private Stack<String> fileNameStack;

    protected PropertyLoader(PropertyFileNameHelper propertyFileNameHelper, PropertyFileReader propertyFileReader, PropertyLoaderFactory propertyLoaderFactory, DefaultPropertySuffixContainer propertySuffix, DefaultPropertyLocationContainer propertyLocation, DefaultPropertyFilterContainer propertyLoaderFilters) {
        this.propertyFileNameHelper = propertyFileNameHelper;
        this.propertyFileReader = propertyFileReader;
        this.propertyLoaderFactory = propertyLoaderFactory;
        this.propertySuffix = propertySuffix;
        this.propertyLocation = propertyLocation;
        this.propertyLoaderFilters = propertyLoaderFilters;
    }

    public PropertyLoader() {
        PropertyLoaderFactory propertyLoaderFactory = new PropertyLoaderFactory();
        HostsHelper hostsHelper = propertyLoaderFactory.createInstance(HostsHelper.class);
        this.propertyFileNameHelper = propertyLoaderFactory.createInstance(PropertyFileNameHelper.class);
        this.propertyFileReader = new PropertyFileReader(propertyLoaderFactory);
        this.propertyLoaderFactory = propertyLoaderFactory;
        this.propertySuffix = new DefaultPropertySuffixContainer(hostsHelper);
        this.propertyLocation = new DefaultPropertyLocationContainer(propertyLoaderFactory);
        this.propertyLoaderFilters = new DefaultPropertyFilterContainer(propertyLoaderFactory);
    }

    public PropertyLoader withEncoding(String propertyFileEncoding) {
        this.propertyFileEncoding = propertyFileEncoding;
        return this;
    }

    public DefaultPropertyLocationContainer getLocations() {
        return this.propertyLocation;
    }

    public DefaultPropertySuffixContainer getSuffixes() {
        return this.propertySuffix;
    }

    public DefaultPropertyFilterContainer getFilters() {
        return this.propertyLoaderFilters;
    }

    public String getExtension() {
        return this.fileExtension;
    }

    public void withSuffixes(DefaultPropertySuffixContainer propertySuffix) {
        this.propertySuffix = propertySuffix;
    }

    public void withLocations(DefaultPropertyLocationContainer propertyLocation) {
        this.propertyLocation = propertyLocation;
    }

    public void withFilters(DefaultPropertyFilterContainer propertyFilter) {
        this.propertyLoaderFilters = propertyFilter;
    }

    public PropertyLoader withExtension(String extension) {
        this.fileExtension = extension;
        return this;
    }

    public PropertyLoader withBaseNames(List<String> baseNames) {
        this.baseNames = baseNames;
        return this;
    }

    public PropertyLoader withDefaultConfig() {
        this.propertyLocation.clear().atDefaultLocations();
        this.propertySuffix.clear().addDefaultSuffixes();
        this.propertyLoaderFilters.clear().withDefaultFilters();
        return this;
    }

    @Override
    public PropertyLoader atDefaultLocations() {
        this.propertyLocation.atDefaultLocations();
        return this;
    }

    @Override
    public PropertyLoader atCurrentDirectory() {
        this.propertyLocation.atCurrentDirectory();
        return this;
    }

    @Override
    public PropertyLoader atHomeDirectory() {
        this.propertyLocation.atHomeDirectory();
        return this;
    }

    @Override
    public PropertyLoader atDirectory(String directory) {
        this.propertyLocation.atDirectory(directory);
        return this;
    }

    @Override
    public PropertyLoader atContextClassPath() {
        this.propertyLocation.atContextClassPath();
        return this;
    }

    @Override
    public PropertyLoader atRelativeToClass(Class<?> reference) {
        this.propertyLocation.atRelativeToClass((Class)reference);
        return this;
    }

    @Override
    public PropertyLoader atClassLoader(ClassLoader classLoader) {
        this.propertyLocation.atClassLoader(classLoader);
        return this;
    }

    @Override
    public PropertyLoader atBaseURL(URL url) {
        this.propertyLocation.atBaseURL(url);
        return this;
    }

    @Override
    public PropertyLoader addUserName() {
        this.propertySuffix.addUserName();
        return this;
    }

    @Override
    public PropertyLoader addLocalHostNames() {
        this.propertySuffix.addLocalHostNames();
        return this;
    }

    @Override
    public PropertyLoader addString(String suffix) {
        this.propertySuffix.addString(suffix);
        return this;
    }

    @Override
    public PropertyLoader addSuffixList(List<String> suffixes) {
        this.propertySuffix.addSuffixList((List)suffixes);
        return this;
    }

    @Override
    public PropertyLoader addDefaultSuffixes() {
        this.propertySuffix.addDefaultSuffixes();
        return this;
    }

    @Override
    public PropertyLoader withDefaultFilters() {
        this.propertyLoaderFilters.withDefaultFilters();
        return this;
    }

    @Override
    public PropertyLoader withVariableResolvingFilter() {
        this.propertyLoaderFilters.withVariableResolvingFilter();
        return this;
    }

    @Override
    public PropertyLoader withEnvironmentResolvingFilter() {
        this.propertyLoaderFilters.withEnvironmentResolvingFilter();
        return this;
    }

    @Override
    public PropertyLoader withWarnIfPropertyHasToBeDefined() {
        this.propertyLoaderFilters.withWarnIfPropertyHasToBeDefined();
        return this;
    }

    @Override
    public PropertyLoader withWarnOnSurroundingWhitespace() {
        this.propertyLoaderFilters.withWarnOnSurroundingWhitespace();
        return this;
    }

    public PropertyLoader withDecryptingFilter() {
        this.propertyLoaderFilters.withDecryptingFilter();
        return this;
    }

    public Properties load(String baseName) {
        this.fileNameStack = this.propertyLoaderFactory.getEmptyFileNameStack();
        Properties loadedProperties = this.loadPropertiesFromBaseNameList(Arrays.asList(baseName));
        this.filterProperties(loadedProperties);
        return loadedProperties;
    }

    public Properties load(String[] baseNames) {
        this.fileNameStack = this.propertyLoaderFactory.getEmptyFileNameStack();
        Properties loadedProperties = this.loadPropertiesFromBaseNameList(Arrays.asList(baseNames));
        this.filterProperties(loadedProperties);
        return loadedProperties;
    }

    public Properties load() {
        this.fileNameStack = this.propertyLoaderFactory.getEmptyFileNameStack();
        Properties loadedProperties = this.loadPropertiesFromBaseNameList(this.baseNames);
        this.filterProperties(loadedProperties);
        return loadedProperties;
    }

    private Properties loadPropertiesFromBaseNameList(List<String> baseNames) {
        Properties loadedProperties = this.propertyLoaderFactory.getEmptyProperties();
        for (String fileName : this.propertyFileNameHelper.getFileNames(baseNames, this.propertySuffix.getSuffixes(), this.fileExtension)) {
            this.throwIfRecursionInIncludes(fileName);
            this.fileNameStack.push(fileName);
            for (PropertyLoaderOpener opener : this.propertyLocation.getOpeners()) {
                Properties newProperties = this.propertyFileReader.tryToReadPropertiesFromFile(fileName, this.propertyFileEncoding, opener);
                Properties includedProperties = this.loadPropertiesFromBaseNameList(Arrays.asList(this.collectIncludesAndRemoveKey(newProperties)));
                newProperties.putAll((Map<?, ?>)includedProperties);
                loadedProperties.putAll((Map<?, ?>)newProperties);
            }
            this.fileNameStack.pop();
        }
        return loadedProperties;
    }

    private void throwIfRecursionInIncludes(String fileName) {
        if (this.fileNameStack.contains(fileName)) {
            StringBuilder sb = this.propertyLoaderFactory.getStringBuilder();
            sb.append("property file include recursion: ");
            Enumeration elements = this.fileNameStack.elements();
            while (elements.hasMoreElements()) {
                String currentFileName = (String)elements.nextElement();
                sb.append(currentFileName);
                sb.append(" -> ");
            }
            sb.append(fileName);
            throw new PropertyLoaderException(sb.toString());
        }
    }

    private String[] collectIncludesAndRemoveKey(Properties properties) {
        String[] includes = new String[]{};
        if (properties.containsKey(INCLUDE_KEY)) {
            includes = properties.getProperty(INCLUDE_KEY).split(",");
            properties.remove(INCLUDE_KEY);
        }
        return includes;
    }

    private void filterProperties(Properties loadedProperties) {
        for (PropertyLoaderFilter filter : this.propertyLoaderFilters.getFilters()) {
            filter.filter(loadedProperties);
        }
    }
}

