/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.propertyloader.impl;

import com.tngtech.propertyloader.impl.PropertyLoaderFactory;
import com.tngtech.propertyloader.impl.interfaces.PropertyFilterContainer;
import com.tngtech.propertyloader.impl.interfaces.PropertyLoaderFilter;
import java.util.ArrayList;
import java.util.List;

public class DefaultPropertyFilterContainer
implements PropertyFilterContainer<DefaultPropertyFilterContainer> {
    private final PropertyLoaderFactory propertyLoaderFactory;
    private List<PropertyLoaderFilter> filters = new ArrayList<PropertyLoaderFilter>();

    public DefaultPropertyFilterContainer(PropertyLoaderFactory propertyLoaderFactory) {
        this.propertyLoaderFactory = propertyLoaderFactory;
    }

    public List<PropertyLoaderFilter> getFilters() {
        return this.filters;
    }

    @Override
    public DefaultPropertyFilterContainer withDefaultFilters() {
        return this.withVariableResolvingFilter().withEnvironmentResolvingFilter().withWarnIfPropertyHasToBeDefined().withWarnOnSurroundingWhitespace().withDecryptingFilter();
    }

    public DefaultPropertyFilterContainer withDecryptingFilter() {
        this.filters.add(this.propertyLoaderFactory.getDecryptingFilter());
        return this;
    }

    @Override
    public DefaultPropertyFilterContainer withVariableResolvingFilter() {
        this.filters.add(this.propertyLoaderFactory.getVariableResolvingFilter());
        return this;
    }

    @Override
    public DefaultPropertyFilterContainer withEnvironmentResolvingFilter() {
        this.filters.add(this.propertyLoaderFactory.getEnvironmentResolvingFilter());
        return this;
    }

    @Override
    public DefaultPropertyFilterContainer withWarnIfPropertyHasToBeDefined() {
        this.filters.add(this.propertyLoaderFactory.getWarnIfPropertyHasToBeDefined());
        return this;
    }

    @Override
    public DefaultPropertyFilterContainer withWarnOnSurroundingWhitespace() {
        this.filters.add(this.propertyLoaderFactory.getWarnOnSurroundingWhitespace());
        return this;
    }

    public DefaultPropertyFilterContainer clear() {
        this.filters.clear();
        return this;
    }
}

