/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.propertyloader.impl;

import com.tngtech.propertyloader.impl.PropertyLoaderFactory;
import com.tngtech.propertyloader.impl.interfaces.PropertyLoaderOpener;
import com.tngtech.propertyloader.impl.interfaces.PropertyLocationsContainer;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public class DefaultPropertyLocationContainer
implements PropertyLocationsContainer<DefaultPropertyLocationContainer> {
    private final PropertyLoaderFactory propertyLoaderFactory;
    private List<PropertyLoaderOpener> openers = new ArrayList<PropertyLoaderOpener>();

    public DefaultPropertyLocationContainer(PropertyLoaderFactory propertyLoaderFactory) {
        this.propertyLoaderFactory = propertyLoaderFactory;
    }

    public List<PropertyLoaderOpener> getOpeners() {
        return this.openers;
    }

    @Override
    public DefaultPropertyLocationContainer atDefaultLocations() {
        this.atCurrentDirectory();
        this.atContextClassPath();
        this.atHomeDirectory();
        return this;
    }

    @Override
    public DefaultPropertyLocationContainer atCurrentDirectory() {
        this.openers.add(this.propertyLoaderFactory.getURLFileOpener());
        return this;
    }

    @Override
    public DefaultPropertyLocationContainer atHomeDirectory() {
        this.openers.add(this.propertyLoaderFactory.getURLFileOpener(System.getProperty("user.home")));
        return this;
    }

    @Override
    public DefaultPropertyLocationContainer atDirectory(String directory) {
        this.openers.add(this.propertyLoaderFactory.getURLFileOpener(directory));
        return this;
    }

    @Override
    public DefaultPropertyLocationContainer atContextClassPath() {
        this.openers.add(this.propertyLoaderFactory.getContextClassLoaderOpener());
        return this;
    }

    @Override
    public DefaultPropertyLocationContainer atRelativeToClass(Class<?> reference) {
        this.openers.add(this.propertyLoaderFactory.getRelativeToClass(reference));
        return this;
    }

    @Override
    public DefaultPropertyLocationContainer atClassLoader(ClassLoader classLoader) {
        this.openers.add(this.propertyLoaderFactory.getClassLoaderOpener(classLoader));
        return this;
    }

    @Override
    public DefaultPropertyLocationContainer atBaseURL(URL url) {
        this.openers.add(this.propertyLoaderFactory.getURLFileOpener(url));
        return this;
    }

    public DefaultPropertyLocationContainer clear() {
        this.openers.clear();
        return this;
    }
}

