/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.propertyloader.impl;

import com.tngtech.propertyloader.impl.helpers.HostsHelper;
import com.tngtech.propertyloader.impl.interfaces.PropertySuffixContainer;
import java.util.ArrayList;
import java.util.List;

public class DefaultPropertySuffixContainer
implements PropertySuffixContainer<DefaultPropertySuffixContainer> {
    private final HostsHelper hostsHelper;
    private List<String> suffixes = new ArrayList<String>();

    public DefaultPropertySuffixContainer(HostsHelper hostsHelper) {
        this.hostsHelper = hostsHelper;
    }

    @Override
    public DefaultPropertySuffixContainer addUserName() {
        this.suffixes.add(System.getProperty("user.name"));
        return this;
    }

    @Override
    public DefaultPropertySuffixContainer addLocalHostNames() {
        this.suffixes.addAll(this.hostsHelper.getLocalHostNames());
        return this;
    }

    @Override
    public DefaultPropertySuffixContainer addString(String suffix) {
        this.suffixes.add(suffix);
        return this;
    }

    @Override
    public DefaultPropertySuffixContainer addSuffixList(List<String> suffixes) {
        this.suffixes.addAll(suffixes);
        return this;
    }

    public List<String> getSuffixes() {
        return this.suffixes;
    }

    @Override
    public DefaultPropertySuffixContainer addDefaultSuffixes() {
        this.addUserName();
        this.addLocalHostNames();
        this.addString("override");
        return this;
    }

    public DefaultPropertySuffixContainer clear() {
        this.suffixes.clear();
        return this;
    }
}

