/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.propertyloader.impl.filters;

import com.tngtech.propertyloader.impl.filters.ValueModifyingFilter;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EnvironmentResolvingFilter
extends ValueModifyingFilter {
    private static final Logger log = LoggerFactory.getLogger(EnvironmentResolvingFilter.class);
    private static final Pattern PATTERN = Pattern.compile("\\$ENV\\{(.*)\\}");

    @Override
    protected String filterValue(String key, String value, Properties properties) {
        Matcher matcher = PATTERN.matcher(value);
        if (matcher.matches() && (value = this.getenv(matcher.group(1))) == null) {
            log.warn("There is no system property called " + matcher.group(1));
        }
        return value;
    }

    protected String getenv(String key) {
        return System.getenv(key);
    }
}

