/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.propertyloader.impl.filters;

import com.tngtech.propertyloader.impl.filters.ThrowIfPropertyHasToBeDefinedException;
import com.tngtech.propertyloader.impl.interfaces.PropertyLoaderFilter;
import java.util.Map;
import java.util.Properties;

public class ThrowIfPropertyHasToBeDefined
implements PropertyLoaderFilter {
    public static final String HAS_TO_BE_DEFINED = "<HAS_TO_BE_DEFINED>";

    @Override
    public void filter(Properties properties) {
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            String key = entry.getKey().toString();
            String value = entry.getValue().toString();
            if (!HAS_TO_BE_DEFINED.equals(value)) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("\nConfiguration incomplete: property " + key + " is still mapped to " + value);
            properties.remove(entry.getKey());
            try {
                this.filter(properties);
            }
            catch (ThrowIfPropertyHasToBeDefinedException e) {
                sb.append(e.getMessage());
            }
            throw new ThrowIfPropertyHasToBeDefinedException(sb.toString());
        }
    }
}

