/*
 * Decompiled with CFR 0.152.
 */
package com.tngtech.propertyloader.impl.openers;

import com.tngtech.propertyloader.impl.interfaces.PropertyLoaderOpener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;

public class URLFileOpener
implements PropertyLoaderOpener {
    private URL url;

    public URLFileOpener() {
        try {
            this.url = new File("").toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("THIS CAN NOT HAPPEN: error while forming URL from path '%s'", ""), e);
        }
    }

    public URLFileOpener(URL url) {
        this.url = url;
    }

    public URLFileOpener(String address) {
        try {
            this.url = new File(address.replace("/", File.separator)).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("THIS SHOULD NOT HAPPEN: error while forming URL from path '%s'", address), e);
        }
    }

    @Override
    public InputStream open(String fileName) {
        try {
            URL urlToFile = new URL(this.url, fileName);
            return urlToFile.openStream();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(String.format("error while forming new URL from URL %s and filename %s", this.url.getPath(), fileName), e);
        }
        catch (IOException e) {
            return null;
        }
    }

    public String toString() {
        return "in path " + this.url.getPath();
    }
}

