/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.common.util;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.twitter.common.quantity.Amount;
import com.twitter.common.quantity.Time;
import com.twitter.common.quantity.Unit;
import com.twitter.common.util.Clock;
import java.io.Closeable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;

public class LowResClock
implements Clock,
Closeable {
    private static final ScheduledExecutorService GLOBAL_SCHEDULER = Executors.newScheduledThreadPool(1, new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable, "LowResClock");
            thread.setDaemon(true);
            return thread;
        }
    });
    public static final Clock DEFAULT = new LowResClock((Amount<Long, Time>)Amount.of((long)100L, (Unit)Time.MILLISECONDS));
    private volatile long time;
    private final ScheduledFuture<?> updaterHandler;
    private final Clock underlying;

    @VisibleForTesting
    LowResClock(Amount<Long, Time> amount, ScheduledExecutorService scheduledExecutorService, Clock clock) {
        long l = (Long)amount.as((Unit)Time.MILLISECONDS);
        Preconditions.checkArgument((l > 0L ? 1 : 0) != 0);
        this.underlying = clock;
        this.time = this.underlying.nowMillis();
        this.updaterHandler = scheduledExecutorService.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                LowResClock.this.time = LowResClock.this.underlying.nowMillis();
            }
        }, 0L, l, TimeUnit.MILLISECONDS);
    }

    public LowResClock(Amount<Long, Time> amount) {
        this(amount, GLOBAL_SCHEDULER, Clock.SYSTEM_CLOCK);
    }

    @Override
    public void close() {
        this.updaterHandler.cancel(true);
    }

    @Override
    public long nowMillis() {
        if (this.updaterHandler.isCancelled()) {
            throw new IllegalStateException("LowResClock invoked after being closed!");
        }
        return this.time;
    }

    @Override
    public long nowNanos() {
        return this.nowMillis() * 1000L * 1000L;
    }

    @Override
    public void waitFor(long l) throws InterruptedException {
        if (this.updaterHandler.isCancelled()) {
            throw new IllegalStateException("LowResClock invoked after being closed!");
        }
        this.underlying.waitFor(l);
    }
}

