/*
 * Decompiled with CFR 0.152.
 */
package org.controlhaus.jms;

import java.lang.reflect.Method;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.HashMap;
import java.util.Map;
import javax.jms.Connection;
import javax.jms.Destination;
import javax.jms.Session;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.apache.beehive.controls.api.properties.BaseProperties;
import org.apache.beehive.controls.api.properties.PropertyKey;
import org.apache.beehive.controls.api.properties.PropertyMap;
import org.apache.beehive.controls.api.versioning.Version;
import org.apache.beehive.controls.api.versioning.VersionRequired;
import org.apache.beehive.controls.runtime.bean.ControlBean;
import org.controlhaus.jms.JMSControl;

public class JMSControlBean
extends ControlBean
implements JMSControl {
    static final Method _setPropertyMethod;
    static final Method _setPropertiesMethod;
    static final Method _setHeaderMethod;
    static final Method _setHeadersMethod;
    static final Method _getDestinationMethod;
    static final Method _getConnectionMethod;
    static final Method _getSessionMethod;
    static HashMap<Method, String[]> _methodParamMap;
    public static final PropertyKey ControlImplementationKey;
    public static final PropertyKey JndiProviderURLKey;
    public static final PropertyKey JndiContextFactoryKey;
    public static final PropertyKey AcknowledgeModeKey;
    public static final PropertyKey TransactedKey;
    public static final PropertyKey SendTypeKey;
    public static final PropertyKey JndiConnectionFactoryKey;
    public static final PropertyKey SendCorrelationPropertyKey;
    public static final PropertyKey SendJndiNameKey;
    private static HashMap _annotCache;

    public JMSControlBean(ControlBeanContext context, String id, PropertyMap props) {
        this(context, id, props, JMSControl.class);
    }

    public JMSControlBean() {
        this(null, null, null);
    }

    protected JMSControlBean(ControlBeanContext context, String id, PropertyMap props, Class controlClass) {
        super(context, id, props, controlClass);
    }

    protected String[] getParameterNames(Method m) {
        if (_methodParamMap.containsKey(m)) {
            return _methodParamMap.get(m);
        }
        return super.getParameterNames(m);
    }

    public void setProperty(String name, Object value) {
        Object[] argArray = new Object[]{name, value};
        Throwable thrown = null;
        JMSControl target = (JMSControl)this.ensureControl();
        try {
            this.preInvoke(_setPropertyMethod, argArray);
            target.setProperty(name, value);
        }
        catch (Throwable t) {
            thrown = t;
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        finally {
            Object rv = null;
            this.postInvoke(_setPropertyMethod, argArray, rv, thrown);
        }
    }

    public void setProperties(Map properties) {
        Object[] argArray = new Object[]{properties};
        Throwable thrown = null;
        JMSControl target = (JMSControl)this.ensureControl();
        try {
            this.preInvoke(_setPropertiesMethod, argArray);
            target.setProperties(properties);
        }
        catch (Throwable t) {
            thrown = t;
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        finally {
            Object rv = null;
            this.postInvoke(_setPropertiesMethod, argArray, rv, thrown);
        }
    }

    public void setHeader(JMSControl.HeaderType type, Object value) {
        Object[] argArray = new Object[]{type, value};
        Throwable thrown = null;
        JMSControl target = (JMSControl)this.ensureControl();
        try {
            this.preInvoke(_setHeaderMethod, argArray);
            target.setHeader(type, value);
        }
        catch (Throwable t) {
            thrown = t;
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        finally {
            Object rv = null;
            this.postInvoke(_setHeaderMethod, argArray, rv, thrown);
        }
    }

    public void setHeaders(Map headers) {
        Object[] argArray = new Object[]{headers};
        Throwable thrown = null;
        JMSControl target = (JMSControl)this.ensureControl();
        try {
            this.preInvoke(_setHeadersMethod, argArray);
            target.setHeaders(headers);
        }
        catch (Throwable t) {
            thrown = t;
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        finally {
            Object rv = null;
            this.postInvoke(_setHeadersMethod, argArray, rv, thrown);
        }
    }

    public Destination getDestination() throws ControlException {
        Object[] argArray = new Object[]{};
        Throwable thrown = null;
        JMSControl target = (JMSControl)this.ensureControl();
        Destination retval = null;
        try {
            this.preInvoke(_getDestinationMethod, argArray);
            retval = target.getDestination();
        }
        catch (Throwable t) {
            thrown = t;
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof ControlException) {
                throw (ControlException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        finally {
            Destination rv = retval;
            this.postInvoke(_getDestinationMethod, argArray, rv, thrown);
        }
        return retval;
    }

    public Connection getConnection() throws ControlException {
        Object[] argArray = new Object[]{};
        Throwable thrown = null;
        JMSControl target = (JMSControl)this.ensureControl();
        Connection retval = null;
        try {
            this.preInvoke(_getConnectionMethod, argArray);
            retval = target.getConnection();
        }
        catch (Throwable t) {
            thrown = t;
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof ControlException) {
                throw (ControlException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        finally {
            Connection rv = retval;
            this.postInvoke(_getConnectionMethod, argArray, rv, thrown);
        }
        return retval;
    }

    public Session getSession() throws ControlException {
        Object[] argArray = new Object[]{};
        Throwable thrown = null;
        JMSControl target = (JMSControl)this.ensureControl();
        Session retval = null;
        try {
            this.preInvoke(_getSessionMethod, argArray);
            retval = target.getSession();
        }
        catch (Throwable t) {
            thrown = t;
            if (t instanceof Error) {
                throw (Error)t;
            }
            if (t instanceof RuntimeException) {
                throw (RuntimeException)t;
            }
            if (t instanceof ControlException) {
                throw (ControlException)t;
            }
            throw new UndeclaredThrowableException(t);
        }
        finally {
            Session rv = retval;
            this.postInvoke(_getSessionMethod, argArray, rv, thrown);
        }
        return retval;
    }

    public String getControlImplementation() {
        return (String)this.getControlProperty(ControlImplementationKey);
    }

    public synchronized void setJndiProviderURL(String value) {
        this.setControlProperty(JndiProviderURLKey, value);
    }

    public String getJndiProviderURL() {
        return (String)this.getControlProperty(JndiProviderURLKey);
    }

    public synchronized void setJndiContextFactory(String value) {
        this.setControlProperty(JndiContextFactoryKey, value);
    }

    public String getJndiContextFactory() {
        return (String)this.getControlProperty(JndiContextFactoryKey);
    }

    public synchronized void setAcknowledgeMode(JMSControl.AcknowledgeMode value) {
        this.setControlProperty(AcknowledgeModeKey, (Object)value);
    }

    public JMSControl.AcknowledgeMode getAcknowledgeMode() {
        return (JMSControl.AcknowledgeMode)((Object)this.getControlProperty(AcknowledgeModeKey));
    }

    public synchronized void setTransacted(boolean value) {
        this.setControlProperty(TransactedKey, value);
    }

    public boolean isTransacted() {
        return (Boolean)this.getControlProperty(TransactedKey);
    }

    public synchronized void setSendType(JMSControl.DestinationType value) {
        this.setControlProperty(SendTypeKey, (Object)value);
    }

    public JMSControl.DestinationType getSendType() {
        return (JMSControl.DestinationType)((Object)this.getControlProperty(SendTypeKey));
    }

    public synchronized void setJndiConnectionFactory(String value) {
        this.setControlProperty(JndiConnectionFactoryKey, value);
    }

    public String getJndiConnectionFactory() {
        return (String)this.getControlProperty(JndiConnectionFactoryKey);
    }

    public synchronized void setSendCorrelationProperty(String value) {
        this.setControlProperty(SendCorrelationPropertyKey, value);
    }

    public String getSendCorrelationProperty() {
        return (String)this.getControlProperty(SendCorrelationPropertyKey);
    }

    public synchronized void setSendJndiName(String value) {
        this.setControlProperty(SendJndiNameKey, value);
    }

    public String getSendJndiName() {
        return (String)this.getControlProperty(SendJndiNameKey);
    }

    protected Map getPropertyMapCache() {
        return _annotCache;
    }

    static {
        _methodParamMap = new HashMap();
        try {
            _setPropertyMethod = JMSControl.class.getMethod("setProperty", String.class, Object.class);
            _methodParamMap.put(_setPropertyMethod, new String[]{"name", "value"});
            _setPropertiesMethod = JMSControl.class.getMethod("setProperties", Map.class);
            _methodParamMap.put(_setPropertiesMethod, new String[]{"properties"});
            _setHeaderMethod = JMSControl.class.getMethod("setHeader", JMSControl.HeaderType.class, Object.class);
            _methodParamMap.put(_setHeaderMethod, new String[]{"type", "value"});
            _setHeadersMethod = JMSControl.class.getMethod("setHeaders", Map.class);
            _methodParamMap.put(_setHeadersMethod, new String[]{"headers"});
            _getDestinationMethod = JMSControl.class.getMethod("getDestination", new Class[0]);
            _methodParamMap.put(_getDestinationMethod, new String[0]);
            _getConnectionMethod = JMSControl.class.getMethod("getConnection", new Class[0]);
            _methodParamMap.put(_getConnectionMethod, new String[0]);
            _getSessionMethod = JMSControl.class.getMethod("getSession", new Class[0]);
            _methodParamMap.put(_getSessionMethod, new String[0]);
        }
        catch (NoSuchMethodException nsme) {
            throw new ExceptionInInitializerError(nsme);
        }
        Class controlIntf = ControlBean.getMostDerivedInterface(JMSControl.class);
        Version versionPresent = controlIntf.getAnnotation(Version.class);
        VersionRequired versionRequired = JMSControlBean.class.getAnnotation(VersionRequired.class);
        ControlBean.enforceVersionRequired((String)"org.controlhaus.jms.JMSControl", (Version)versionPresent, (VersionRequired)versionRequired);
        ControlImplementationKey = new PropertyKey(BaseProperties.class, "controlImplementation");
        JndiProviderURLKey = new PropertyKey(JMSControl.Destination.class, "jndiProviderURL");
        JndiContextFactoryKey = new PropertyKey(JMSControl.Destination.class, "jndiContextFactory");
        AcknowledgeModeKey = new PropertyKey(JMSControl.Destination.class, "acknowledgeMode");
        TransactedKey = new PropertyKey(JMSControl.Destination.class, "transacted");
        SendTypeKey = new PropertyKey(JMSControl.Destination.class, "sendType");
        JndiConnectionFactoryKey = new PropertyKey(JMSControl.Destination.class, "jndiConnectionFactory");
        SendCorrelationPropertyKey = new PropertyKey(JMSControl.Destination.class, "sendCorrelationProperty");
        SendJndiNameKey = new PropertyKey(JMSControl.Destination.class, "sendJndiName");
        _annotCache = new HashMap();
    }
}

