/*
 * Decompiled with CFR 0.152.
 */
package org.controlhaus.jndi.impl;

import java.util.Hashtable;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import org.apache.beehive.controls.api.ControlException;
import org.apache.beehive.controls.api.bean.ControlImplementation;
import org.apache.beehive.controls.api.context.Context;
import org.apache.beehive.controls.api.context.ControlBeanContext;
import org.controlhaus.jndi.JndiControl;

@ControlImplementation
public class JndiControlImpl
implements JndiControl {
    @Context
    ControlBeanContext _context;
    private transient InitialContext _initialContext;

    public Object getResource(String resource, Class resourceClass) throws ControlException {
        try {
            InitialContext cntxt = this.getInitialContext();
            Object obj = cntxt.lookup(resource);
            if (resourceClass != null && !resourceClass.isInstance(obj)) {
                throw new ControlException("JNDI resource '" + resource + "' is not an instance of '" + resourceClass.getName() + "'");
            }
            return obj;
        }
        catch (NamingException e) {
            throw new ControlException("Cannot load JNDI resource '" + resource + "'", (Throwable)e);
        }
    }

    public InitialContext getInitialContext() throws ControlException {
        if (this._initialContext != null) {
            return this._initialContext;
        }
        JndiControl.Properties props = (JndiControl.Properties)this._context.getControlPropertySet(JndiControl.Properties.class);
        String url = props.url();
        String factory = props.factory();
        if (url == null && factory == null) {
            try {
                return new InitialContext();
            }
            catch (NamingException e) {
                throw new ControlException("Cannot get default JNDI initial context", (Throwable)e);
            }
        }
        if (url == null || factory == null) {
            throw new ControlException("Both the provider-url and jndi factory need to be provided");
        }
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", factory);
        env.put("java.naming.provider.url", url);
        try {
            this._initialContext = new InitialContext(env);
            return this._initialContext;
        }
        catch (NamingException e) {
            throw new ControlException("Cannot get JNDI initial context at provider '" + url + "' with factory '" + factory + "'", (Throwable)e);
        }
    }
}

