/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.db.operation;

import de.akquinet.jbosscc.needle.db.operation.AbstractDBOperation;
import de.akquinet.jbosscc.needle.db.operation.JdbcConfiguration;
import java.sql.SQLException;
import java.sql.Statement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExecuteScriptOperation
extends AbstractDBOperation {
    private static final Logger LOG = LoggerFactory.getLogger(ExecuteScriptOperation.class);
    private static final String BEFORE_SCRIPT_NAME = "before.sql";
    private static final String AFTER_SCRIPT_NAME = "after.sql";

    public ExecuteScriptOperation(JdbcConfiguration jdbcConfiguration) {
        super(jdbcConfiguration);
    }

    @Override
    public void setUpOperation() throws SQLException {
        this.execute(BEFORE_SCRIPT_NAME);
    }

    @Override
    public void tearDownOperation() throws SQLException {
        this.execute(AFTER_SCRIPT_NAME);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void execute(String filename) {
        Statement statement = null;
        try {
            statement = this.getConnection().createStatement();
            this.executeScript(filename, statement);
            this.commit();
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                this.rollback();
            }
            catch (SQLException e1) {
                LOG.error(e1.getMessage(), (Throwable)e1);
            }
        }
        finally {
            try {
                if (statement != null) {
                    statement.close();
                }
                this.commit();
                this.closeConnection();
            }
            catch (SQLException e) {
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

