/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.db.operation.hsql;

import de.akquinet.jbosscc.needle.db.operation.AbstractDBOperation;
import de.akquinet.jbosscc.needle.db.operation.JdbcConfiguration;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HSQLDeleteOperation
extends AbstractDBOperation {
    private static final Logger LOG = LoggerFactory.getLogger(HSQLDeleteOperation.class);

    public HSQLDeleteOperation(JdbcConfiguration configuration) {
        super(configuration);
    }

    @Override
    public void setUpOperation() throws SQLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void tearDownOperation() throws SQLException {
        Statement statement = null;
        try {
            Connection connection = this.getConnection();
            statement = connection.createStatement();
            this.disableReferentialIntegrity(statement);
            List<String> tableNames = this.getTableNames(this.getConnection());
            this.deleteContent(tableNames, statement);
        }
        catch (SQLException e) {
            LOG.error(e.getMessage(), (Throwable)e);
            try {
                this.rollback();
            }
            catch (SQLException e1) {
                LOG.error(e1.getMessage(), (Throwable)e1);
            }
        }
        finally {
            try {
                this.enableReferentialIntegrity(statement);
                if (statement != null) {
                    statement.close();
                }
                this.commit();
                this.closeConnection();
            }
            catch (Exception e) {
                this.rollback();
                LOG.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    protected void disableReferentialIntegrity(Statement statement) throws SQLException {
        this.setReferentialIntegrity(false, statement);
    }

    protected void enableReferentialIntegrity(Statement statement) throws SQLException {
        this.setReferentialIntegrity(true, statement);
    }

    private void setReferentialIntegrity(boolean enable, Statement statement) throws SQLException {
        int databaseMajorVersion = statement.getConnection().getMetaData().getDatabaseMajorVersion();
        String referentialIntegrity = enable ? "TRUE" : "FALSE";
        String command = databaseMajorVersion < 2 ? "SET REFERENTIAL_INTEGRITY " : "SET DATABASE REFERENTIAL INTEGRITY ";
        this.getConnection().prepareStatement(command + referentialIntegrity).execute();
    }

    protected void deleteContent(List<String> tables, Statement statement) throws SQLException {
        ArrayList<String> tempTables = new ArrayList<String>(tables);
        while (!tempTables.isEmpty()) {
            int sizeBefore = tempTables.size();
            ListIterator<String> iterator = tempTables.listIterator();
            while (iterator.hasNext()) {
                String table = iterator.next();
                try {
                    statement.executeUpdate("DELETE FROM " + table);
                    iterator.remove();
                }
                catch (SQLException exc) {
                    LOG.warn("Ignored exception: " + exc.getMessage() + ". WILL RETRY.");
                }
            }
            if (tempTables.size() == sizeBefore) {
                throw new AssertionError((Object)("unable to clean tables " + tempTables));
            }
        }
    }
}

