/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.db.testdata;

import de.akquinet.jbosscc.needle.db.testdata.TestdataBuilder;
import de.akquinet.jbosscc.needle.db.transaction.TransactionHelper;
import javax.persistence.EntityManager;

public abstract class AbstractTestdataBuilder<T>
implements TestdataBuilder<T> {
    private static int count = 0;
    private EntityManager entityManager;
    private TransactionHelper transactionHelper;

    public AbstractTestdataBuilder(EntityManager entityManager) {
        this.entityManager = entityManager;
        this.transactionHelper = new TransactionHelper(entityManager);
    }

    public AbstractTestdataBuilder() {
    }

    protected final EntityManager getEntityManager() {
        return this.entityManager;
    }

    protected final boolean hasEntityManager() {
        return this.entityManager != null;
    }

    protected final void ensureEntityManager() {
        if (this.entityManager == null) {
            throw new IllegalStateException("cannot persist w/o entity manager!");
        }
    }

    @Override
    public final T buildAndSave() {
        this.ensureEntityManager();
        try {
            return this.transactionHelper.saveObject(this.build());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    protected final int getId() {
        return count++;
    }
}

