/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.mock;

import de.akquinet.jbosscc.needle.NeedleContext;
import de.akquinet.jbosscc.needle.annotation.Mock;
import de.akquinet.jbosscc.needle.injection.InjectionConfiguration;
import de.akquinet.jbosscc.needle.reflection.ReflectionUtil;
import java.lang.reflect.Field;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockAnnotationProcessor {
    private static final Logger LOG = LoggerFactory.getLogger(MockAnnotationProcessor.class);

    public void process(NeedleContext context, InjectionConfiguration configuration) {
        Object mockProvider = configuration.getMockProvider();
        List<Field> fields = context.getAnnotatedTestcaseFields(Mock.class);
        for (Field field : fields) {
            Object mock = mockProvider.createMockComponent(field.getType());
            try {
                ReflectionUtil.setField(field, context.getTest(), mock);
            }
            catch (Exception e) {
                LOG.warn("could not assign mock obejct " + mock, (Throwable)e);
            }
        }
    }
}

