/*
 * Decompiled with CFR 0.152.
 */
package de.akquinet.jbosscc.needle.postconstruct;

import de.akquinet.jbosscc.needle.ObjectUnderTestInstantiationException;
import de.akquinet.jbosscc.needle.annotation.ObjectUnderTest;
import de.akquinet.jbosscc.needle.reflection.ReflectionUtil;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class PostConstructProcessor {
    private final Set<Class<?>> postConstructAnnotations;

    public PostConstructProcessor(Set<Class<?>> postConstructAnnotations) {
        this.postConstructAnnotations = new HashSet(postConstructAnnotations);
    }

    public void process(ObjectUnderTest objectUnderTestAnnotation, Object instance) throws ObjectUnderTestInstantiationException {
        if (objectUnderTestAnnotation != null && objectUnderTestAnnotation.postConstruct()) {
            this.process(instance);
        }
    }

    private void process(Object instance) throws ObjectUnderTestInstantiationException {
        List<Method> postConstructMethods = this.getPostConstructMethods(instance);
        for (Method method : postConstructMethods) {
            try {
                ReflectionUtil.invokeMethod(method, instance, new Object[0]);
            }
            catch (Exception e) {
                throw new ObjectUnderTestInstantiationException("error executing postConstruction method '" + method.getName() + "'", e);
            }
        }
    }

    private List<Method> getPostConstructMethods(Object instance) {
        ArrayList<Method> postConstructMethods = new ArrayList<Method>();
        for (Class<?> postConstructAnnotation : this.postConstructAnnotations) {
            for (Method method : ReflectionUtil.getMethods(instance.getClass())) {
                if (!method.isAnnotationPresent(postConstructAnnotation)) continue;
                postConstructMethods.add(method);
            }
        }
        return postConstructMethods;
    }
}

