/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.DefaultQueryMatcher;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.QueryOperator;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.Json;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

class Projection {
    private final Document fields;
    private final String idField;
    private final boolean onlyExclusions;

    Projection(Document fields, String idField) {
        Projection.validateFields(fields);
        this.fields = fields;
        this.idField = idField;
        this.onlyExclusions = this.onlyExclusions(fields);
    }

    Document projectDocument(Document document) {
        if (document == null) {
            return null;
        }
        Document newDocument = new Document();
        if (!this.fields.containsKey(this.idField)) {
            newDocument.put(this.idField, document.get(this.idField));
        }
        if (this.onlyExclusions) {
            newDocument = document.cloneDeeply();
        }
        for (Map.Entry<String, Object> entry : this.fields.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            Projection.projectField(document, newDocument, key, value);
        }
        return newDocument;
    }

    private static void validateFields(Document fields) {
        for (String key : fields.keySet()) {
            Utils.validateKey(key);
            for (String otherKey : fields.keySet()) {
                String pathPrefix;
                if (key.equals(otherKey) || otherKey.length() < key.length() || (pathPrefix = Utils.getShorterPathIfPrefix(key, otherKey)) == null) continue;
                List<String> shorterPathFragments = Utils.splitPath(key);
                List<String> longerPathFragments = Utils.splitPath(otherKey);
                String remainingPortion = Utils.joinPath(longerPathFragments.subList(shorterPathFragments.size() - 1, longerPathFragments.size()));
                throw new MongoServerError(31249, "Path collision at " + otherKey + " remaining portion " + remainingPortion);
            }
        }
    }

    private boolean onlyExclusions(Document fields) {
        Map nonIdInclusionsAndExclusions = fields.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals(this.idField) || Utils.isTrue(entry.getValue())).collect(Collectors.groupingBy(entry -> Type.fromValue(entry.getValue()), Collectors.mapping(Map.Entry::getKey, Collectors.toList())));
        List inclusions = nonIdInclusionsAndExclusions.getOrDefault((Object)Type.INCLUSIONS, Collections.emptyList());
        List exclusions = nonIdInclusionsAndExclusions.getOrDefault((Object)Type.EXCLUSIONS, Collections.emptyList());
        if (!inclusions.isEmpty() && !exclusions.isEmpty()) {
            List includedFields = nonIdInclusionsAndExclusions.get((Object)Type.INCLUSIONS);
            throw new MongoServerError(31253, "Cannot do inclusion on field " + (String)includedFields.get(0) + " in exclusion projection");
        }
        return inclusions.isEmpty();
    }

    private static void projectField(Document document, Document newDocument, String key, Object projectionValue) {
        if (key.contains(".")) {
            List<String> pathFragments = Utils.splitPath(key);
            String mainKey = pathFragments.get(0);
            String subKey = Utils.joinTail(pathFragments);
            Object object = document.get(mainKey);
            if (object instanceof Document) {
                Document newsubDocument = (Document)newDocument.computeIfAbsent(mainKey, k -> new Document());
                Projection.projectField((Document)object, newsubDocument, subKey, projectionValue);
            } else if (object instanceof List) {
                List values = (List)object;
                List newprojectedValues = (List)newDocument.computeIfAbsent(mainKey, k -> new ArrayList());
                if ("$".equals(subKey) && !values.isEmpty()) {
                    Object firstValue = values.get(0);
                    if (firstValue instanceof Document) {
                        newprojectedValues.add(firstValue);
                    }
                } else {
                    if (newprojectedValues.isEmpty()) {
                        for (Object value : values) {
                            if (!(value instanceof Document)) continue;
                            newprojectedValues.add(new Document());
                        }
                    }
                    int idx = 0;
                    for (Object value : values) {
                        if (value instanceof Document) {
                            Document newprojectedDocument = (Document)newprojectedValues.get(idx);
                            Projection.projectField((Document)value, newprojectedDocument, subKey, projectionValue);
                            ++idx;
                            continue;
                        }
                        if (Utils.isTrue(projectionValue)) continue;
                        ++idx;
                    }
                }
            }
        } else {
            Object value = document.getOrMissing(key);
            if (projectionValue instanceof Document) {
                Document projectionDocument = (Document)projectionValue;
                if (projectionDocument.keySet().equals(Set.of(QueryOperator.ELEM_MATCH.getValue()))) {
                    Document elemMatch = (Document)projectionDocument.get(QueryOperator.ELEM_MATCH.getValue());
                    Projection.projectElemMatch(newDocument, elemMatch, key, value);
                } else if (projectionDocument.keySet().equals(Set.of("$slice"))) {
                    Object slice = projectionDocument.get("$slice");
                    Projection.projectSlice(newDocument, slice, key, value);
                }
            } else if (Utils.isTrue(projectionValue)) {
                if (!(value instanceof Missing)) {
                    newDocument.put(key, value);
                }
            } else {
                newDocument.remove(key);
            }
        }
    }

    private static void projectElemMatch(Document newDocument, Document elemMatch, String key, Object value) {
        DefaultQueryMatcher queryMatcher = new DefaultQueryMatcher();
        if (value instanceof List) {
            ((List)value).stream().filter(sourceObject -> sourceObject instanceof Document).filter(sourceObject -> queryMatcher.matches((Document)sourceObject, elemMatch)).findFirst().ifPresent(v -> newDocument.put(key, (Object)List.of(v)));
        }
    }

    private static void projectSlice(Document newDocument, Object slice, String key, Object value) {
        if (!(value instanceof List)) {
            newDocument.put(key, value);
            return;
        }
        List values = (List)value;
        int fromIndex = 0;
        int toIndex = values.size();
        if (slice instanceof Integer) {
            int num = (Integer)slice;
            if (num < 0) {
                fromIndex = values.size() + num;
            } else {
                toIndex = num;
            }
        } else if (slice instanceof List) {
            int limit;
            List sliceParams = (List)slice;
            if (sliceParams.size() != 2) {
                throw new MongoServerError(28724, "First argument to $slice must be an array, but is of type: int");
            }
            if (!(sliceParams.get(0) instanceof Number)) {
                throw new MongoServerError(28724, "First argument to $slice must be an array, but is of type: " + Utils.describeType(sliceParams.get(0)));
            }
            if (!(sliceParams.get(1) instanceof Number)) {
                throw new MongoServerError(28724, "First argument to $slice must be an array, but is of type: int");
            }
            fromIndex = ((Number)sliceParams.get(0)).intValue();
            if (fromIndex < 0) {
                fromIndex += values.size();
            }
            if ((limit = ((Number)sliceParams.get(1)).intValue()) <= 0) {
                throw new MongoServerError(28724, "First argument to $slice must be an array, but is of type: int");
            }
            toIndex = fromIndex + limit;
        } else {
            String sliceJson = Json.toJsonValue(slice);
            throw new MongoServerError(28667, "Invalid $slice syntax. The given syntax { $slice: " + sliceJson + " } did not match the find() syntax because :: Location31273: $slice only supports numbers and [skip, limit] arrays :: The given syntax did not match the expression $slice syntax. :: caused by :: Expression $slice takes at least 2 arguments, and at most 3, but 1 were passed in.");
        }
        List slicedValue = values.subList(Math.max(0, fromIndex), Math.min(values.size(), toIndex));
        newDocument.put(key, (Object)slicedValue);
    }

    private static enum Type {
        INCLUSIONS,
        EXCLUSIONS;


        private static Type fromValue(Object value) {
            if (Utils.isTrue(value)) {
                return INCLUSIONS;
            }
            return EXCLUSIONS;
        }
    }
}

