/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.backend.aggregation.Expression;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.Accumulator;
import de.bwaldvogel.mongo.backend.aggregation.accumulator.SumAccumulator;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.Json;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class BucketStage
implements AggregationStage {
    private final Object groupByExpression;
    private final List<?> boundaries;
    private final Object defaultValue;
    private final Document output;

    public BucketStage(Document document) {
        this.groupByExpression = this.validateGroupBy(document.get("groupBy"));
        this.boundaries = this.getAndValidateBoundaries(document.get("boundaries"));
        this.defaultValue = this.getAndValidateDefault(document.getOrMissing("default"));
        this.output = this.getAndValidateOutput(document.get("output"));
    }

    @Override
    public String name() {
        return "$bucket";
    }

    private void validateValuePresent(Object value) {
        if (value == null) {
            throw new MongoServerError(40198, "$bucket requires 'groupBy' and 'boundaries' to be specified.");
        }
    }

    private Object validateGroupBy(Object groupBy) {
        this.validateValuePresent(groupBy);
        if (!(groupBy instanceof String) && !(groupBy instanceof Document)) {
            String value = Json.toJsonValue(groupBy);
            throw new MongoServerError(40202, "The $bucket 'groupBy' field must be defined as a $-prefixed path or an expression, but found: " + value + ".");
        }
        return groupBy;
    }

    private List<?> getAndValidateBoundaries(Object boundaries) {
        this.validateValuePresent(boundaries);
        if (!(boundaries instanceof List)) {
            String type = Utils.describeType(boundaries);
            throw new MongoServerError(40200, "The $bucket 'boundaries' field must be an array, but found type: " + type + ".");
        }
        List boundaryValues = (List)boundaries;
        if (boundaryValues.size() < 2) {
            throw new MongoServerError(40192, "The $bucket 'boundaries' field must have at least 2 values, but found " + boundaryValues.size() + " value(s).");
        }
        for (int i = 1; i < boundaryValues.size(); ++i) {
            Object value1 = boundaryValues.get(i - 1);
            Object value2 = boundaryValues.get(i);
            this.validateTypesAreCompatible(value1, value2);
            if (BucketStage.compare(value1, value2) < 0) continue;
            int index1 = i - 1;
            int index2 = i;
            throw new MongoServerError(40194, "The 'boundaries' option to $bucket must be sorted, but elements " + index1 + " and " + index2 + " are not in ascending order (" + value1 + " is not less than " + value2 + ").");
        }
        return boundaryValues;
    }

    private Object getAndValidateDefault(Object defaultValue) {
        Assert.notEmpty(this.boundaries);
        if (BucketStage.compare(defaultValue, this.boundaries.get(0)) >= 0 && BucketStage.compare(defaultValue, CollectionUtils.getLastElement(this.boundaries)) < 0) {
            throw new MongoServerError(40199, "The $bucket 'default' field must be less than the lowest boundary or greater than or equal to the highest boundary.");
        }
        return defaultValue;
    }

    private void validateTypesAreCompatible(Object value1, Object value2) {
        String type2;
        if (value1 instanceof Number && value2 instanceof Number) {
            return;
        }
        String type1 = Utils.describeType(value1);
        if (!type1.equals(type2 = Utils.describeType(value2))) {
            throw new MongoServerError(40193, "All values in the the 'boundaries' option to $bucket must have the same type. Found conflicting types " + type1 + " and " + type2 + ".");
        }
    }

    private Document getAndValidateOutput(Object output) {
        if (output == null) {
            return null;
        }
        if (!(output instanceof Document)) {
            throw new MongoServerError(40196, "The $bucket 'output' field must be an object, but found type: " + Utils.describeType(output) + ".");
        }
        return (Document)output;
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        TreeMap accumulatorsPerBucket = new TreeMap(ValueComparator.asc());
        stream.forEach(document -> {
            Object key = Expression.evaluateDocument(this.groupByExpression, document);
            Object bucket = this.findBucket(key);
            List accumulators = accumulatorsPerBucket.computeIfAbsent(bucket, k -> this.getAccumulators());
            for (Accumulator accumulator : accumulators) {
                Object expression = accumulator.getExpression();
                accumulator.aggregate(Expression.evaluateDocument(expression, document));
            }
        });
        ArrayList<Document> result = new ArrayList<Document>();
        for (Map.Entry entry : accumulatorsPerBucket.entrySet()) {
            Document groupResult = new Document();
            groupResult.put("_id", entry.getKey());
            for (Accumulator accumulator : (List)entry.getValue()) {
                groupResult.put(accumulator.getField(), accumulator.getResult());
            }
            result.add(groupResult);
        }
        return result.stream();
    }

    private List<Accumulator> getAccumulators() {
        if (this.output == null) {
            return List.of(new SumAccumulator("count", new Document("$sum", 1)));
        }
        return Accumulator.parse(this.output).values().stream().map(Supplier::get).collect(Collectors.toList());
    }

    private Object findBucket(Object key) {
        if (BucketStage.compare(key, this.boundaries.get(0)) < 0) {
            return this.getDefaultValue();
        }
        for (int i = 1; i < this.boundaries.size(); ++i) {
            Object boundary = this.boundaries.get(i);
            if (BucketStage.compare(key, boundary) >= 0) continue;
            return this.boundaries.get(i - 1);
        }
        return this.getDefaultValue();
    }

    private static int compare(Object a, Object b) {
        return ValueComparator.asc().compare(a, b);
    }

    private Object getDefaultValue() {
        if (this.defaultValue instanceof Missing) {
            throw new MongoServerError(40066, "$switch could not find a matching branch for an input, and no default was specified.");
        }
        return this.defaultValue;
    }
}

