/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend;

import de.bwaldvogel.mongo.backend.Assert;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.bson.Json;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class KeyValue
implements Serializable,
Iterable<Object> {
    private static final long serialVersionUID = 1L;
    private final List<Object> values;

    public KeyValue(Object ... values) {
        this(Arrays.asList(values));
    }

    public KeyValue(Collection<?> values) {
        Assert.notEmpty(values);
        this.values = new ArrayList(values);
    }

    public int size() {
        return this.values.size();
    }

    public Object get(int index) {
        return this.values.get(index);
    }

    @Override
    public Iterator<Object> iterator() {
        return this.values.iterator();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        KeyValue keyValue = (KeyValue)o;
        return Objects.equals(this.values, keyValue.values);
    }

    public int hashCode() {
        return Objects.hash(this.values);
    }

    public String toString() {
        return this.values.stream().map(value -> ": " + Json.toCompactJsonValue(value)).collect(Collectors.joining(", ", "{ ", " }"));
    }

    public Stream<Object> stream() {
        return this.values.stream();
    }

    public KeyValue normalized() {
        return new KeyValue(this.values.stream().map(Utils::normalizeValue).collect(Collectors.toList()));
    }
}

