/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation;

import de.bwaldvogel.mongo.backend.CollectionUtils;
import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.ValueComparator;
import de.bwaldvogel.mongo.backend.aggregation.Expression;
import de.bwaldvogel.mongo.backend.aggregation.Range;
import de.bwaldvogel.mongo.backend.aggregation.TwoNumericParameters;
import de.bwaldvogel.mongo.backend.aggregation.TwoParameters;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.bson.ObjectId;
import de.bwaldvogel.mongo.exception.ErrorCode;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import java.util.function.IntPredicate;

interface ExpressionTraits {
    public String name();

    default public Object requireSingleValue(List<?> list) {
        this.requireCollectionInSize(list, 1);
        return CollectionUtils.getSingleElement(list);
    }

    default public String requireSingleStringValue(List<?> expressionValue) {
        Object value = this.requireSingleValue(expressionValue);
        if (!(value instanceof String)) {
            throw new MongoServerError(ErrorCode._34471, this.name() + " requires a string argument, found: " + Utils.describeType(value));
        }
        return (String)value;
    }

    default public Number evaluateNumericValue(List<?> expressionValue, Function<Double, ? extends Number> function) {
        Object value = this.requireSingleValue(expressionValue);
        if (Missing.isNullOrMissing(value)) {
            return null;
        }
        if (!(value instanceof Number)) {
            throw new MongoServerError(28765, this.name() + " only supports numeric types, not " + Utils.describeType(value));
        }
        Number number = (Number)value;
        if (Double.isNaN(number.doubleValue())) {
            return number;
        }
        return function.apply(number.doubleValue());
    }

    default public int evaluateComparison(List<?> expressionValue) {
        TwoParameters parameters = this.requireTwoParameters(expressionValue);
        return ValueComparator.ascWithoutListHandling().compare(parameters.getFirst(), parameters.getSecond());
    }

    default public boolean evaluateComparison(List<?> expressionValue, IntPredicate comparison) {
        int comparisonResult = this.evaluateComparison(expressionValue);
        return comparison.test(comparisonResult);
    }

    default public <T> T evaluateDateTime(List<?> expressionValue, Function<ZonedDateTime, T> dateFunction, Document document) {
        Object value = this.requireSingleValue(expressionValue);
        if (Missing.isNullOrMissing(value)) {
            return null;
        }
        ZonedDateTime zonedDateTime = this.getZonedDateTime(value, document);
        return dateFunction.apply(zonedDateTime);
    }

    default public <T> T evaluateDate(List<?> expressionValue, Function<LocalDate, T> dateFunction, Document document) {
        return (T)this.evaluateDateTime(expressionValue, zonedDateTime -> dateFunction.apply(zonedDateTime.toLocalDate()), document);
    }

    default public <T> T evaluateTime(List<?> expressionValue, Function<LocalTime, T> timeFunction, Document document) {
        return (T)this.evaluateDateTime(expressionValue, zonedDateTime -> timeFunction.apply(zonedDateTime.toLocalTime()), document);
    }

    default public void requireCollectionInSize(List<?> value, int expectedCollectionSize) {
        if (value.size() != expectedCollectionSize) {
            throw new MongoServerError(16020, "Expression " + this.name() + " takes exactly " + expectedCollectionSize + " arguments. " + value.size() + " were passed in.");
        }
    }

    default public TwoParameters requireTwoParameters(List<?> parameters) {
        this.requireCollectionInSize(parameters, 2);
        return new TwoParameters(parameters.get(0), parameters.get(1));
    }

    default public TwoNumericParameters requireTwoNumericParameters(List<?> value, int errorCode) {
        TwoParameters parameters = this.requireTwoParameters(value);
        Object one = parameters.getFirst();
        Object other = parameters.getSecond();
        if (parameters.isAnyNull()) {
            return null;
        }
        if (!(one instanceof Number) || !(other instanceof Number)) {
            throw new MongoServerError(errorCode, this.name() + " only supports numeric types, not " + Utils.describeType(one) + " and " + Utils.describeType(other));
        }
        return new TwoNumericParameters((Number)one, (Number)other);
    }

    default public ZonedDateTime getZonedDateTime(Object value, Document document) {
        ZoneId timezone = ZoneId.systemDefault();
        if (value instanceof Document) {
            Document valueAsDocument = (Document)value;
            if (!valueAsDocument.containsKey("date")) {
                throw new MongoServerError(40539, "missing 'date' argument to " + this.name() + ", provided: " + String.valueOf(value));
            }
            value = Expression.evaluate(valueAsDocument.get("date"), document);
            Object timezoneExpression = Expression.evaluate(valueAsDocument.get("timezone"), document);
            if (timezoneExpression != null) {
                timezone = ZoneId.of(timezoneExpression.toString());
            }
        }
        if (!(value instanceof Instant)) {
            throw new MongoServerError(16006, "can't convert from " + Utils.describeType(value) + " to Date");
        }
        Instant instant = (Instant)value;
        return ZonedDateTime.ofInstant(instant, timezone);
    }

    default public int requireIntegral(Object value, String name) {
        if (!(value instanceof Number)) {
            throw new MongoServerError(40096, this.name() + " requires an integral " + name + ", found a value of type: " + Utils.describeType(value) + ", with value: \"" + String.valueOf(value) + "\"");
        }
        Number number = (Number)value;
        int intValue = number.intValue();
        if (intValue < 0) {
            throw new MongoServerError(40097, this.name() + " requires a nonnegative " + name + ", found: " + intValue);
        }
        return intValue;
    }

    default public Object assertTwoToFourArguments(List<?> expressionValue) {
        if (expressionValue.size() < 2 || expressionValue.size() > 4) {
            throw new MongoServerError(28667, "Expression " + this.name() + " takes at least 2 arguments, and at most 4, but " + expressionValue.size() + " were passed in.");
        }
        Object first = expressionValue.get(0);
        if (Missing.isNullOrMissing(first)) {
            return null;
        }
        return first;
    }

    default public <T> Object evaluateIndexOf(List<?> expressionValue, Function<String, List<T>> toList, int errorCodeFirstParameterTypeMismatch, int errorCodeSecondParameterTypeMismatch) {
        Object first = this.assertTwoToFourArguments(expressionValue);
        if (first == null) {
            return null;
        }
        if (!(first instanceof String)) {
            throw new MongoServerError(errorCodeFirstParameterTypeMismatch, this.name() + " requires a string as the first argument, found: " + Utils.describeType(first));
        }
        List<T> elementsToSearchIn = toList.apply((String)first);
        Object searchValue = expressionValue.get(1);
        if (!(searchValue instanceof String)) {
            throw new MongoServerError(errorCodeSecondParameterTypeMismatch, this.name() + " requires a string as the second argument, found: " + Utils.describeType(searchValue));
        }
        List<T> search = toList.apply((String)searchValue);
        Range range = this.indexOf(expressionValue, elementsToSearchIn.size());
        int index = Collections.indexOfSubList(elementsToSearchIn = elementsToSearchIn.subList(range.getStart(), range.getEnd()), search);
        if (index >= 0) {
            return index + range.getStart();
        }
        return index;
    }

    default public Range indexOf(List<?> expressionValue, int size) {
        int start = 0;
        if (expressionValue.size() >= 3) {
            Object startValue = expressionValue.get(2);
            start = this.requireIntegral(startValue, "starting index");
            start = Math.min(start, size);
        }
        int end = size;
        if (expressionValue.size() >= 4) {
            Object endValue = expressionValue.get(3);
            end = this.requireIntegral(endValue, "ending index");
            end = Math.min(Math.max(start, end), size);
        }
        return new Range(start, end);
    }

    default public Collection<?> requireArray(int errorCode, Object value) {
        if (!(value instanceof Collection)) {
            throw new MongoServerError(errorCode, "The argument to " + this.name() + " must be an array, but was of type: " + Utils.describeType(value));
        }
        return (Collection)value;
    }

    default public Document requireDocument(Object expressionValue, int errorCode) {
        if (!(expressionValue instanceof Document)) {
            throw new MongoServerError(errorCode, this.name() + " only supports an object as its argument");
        }
        return (Document)expressionValue;
    }

    default public String evaluateString(List<?> expressionValue, Function<String, String> function) {
        Object value = this.requireSingleValue(expressionValue);
        if ((value = this.convertToString(value)) == null) {
            return null;
        }
        return function.apply((String)value);
    }

    default public String convertToString(Object value) {
        if (Missing.isNullOrMissing(value)) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        if (value instanceof Number) {
            return value.toString();
        }
        if (value instanceof ObjectId) {
            return ((ObjectId)value).getHexData();
        }
        throw new MongoServerError(16007, "can't convert from BSON type " + Utils.describeType(value) + " to String");
    }
}

