/*
 * Decompiled with CFR 0.152.
 */
package de.bwaldvogel.mongo.backend.aggregation.stage;

import de.bwaldvogel.mongo.backend.Missing;
import de.bwaldvogel.mongo.backend.Utils;
import de.bwaldvogel.mongo.backend.aggregation.Expression;
import de.bwaldvogel.mongo.backend.aggregation.stage.AggregationStage;
import de.bwaldvogel.mongo.bson.Document;
import de.bwaldvogel.mongo.exception.BadValueException;
import de.bwaldvogel.mongo.exception.ConversionFailureException;
import de.bwaldvogel.mongo.exception.ErrorCode;
import de.bwaldvogel.mongo.exception.FailedToOptimizePipelineError;
import de.bwaldvogel.mongo.exception.MongoServerError;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class ProjectStage
implements AggregationStage {
    private final Document projection;
    private final boolean hasInclusions;

    public ProjectStage(Object projection) {
        if (!(projection instanceof Document)) {
            throw new MongoServerError(15969, "$project specification must be an object");
        }
        Document projectionSpecification = (Document)projection;
        if (projectionSpecification.isEmpty()) {
            throw new MongoServerError(40177, "specification must have at least one field");
        }
        this.projection = projectionSpecification;
        this.hasInclusions = ProjectStage.hasInclusions(projectionSpecification);
        this.validateProjection();
    }

    @Override
    public String name() {
        return "$project";
    }

    private static boolean hasInclusions(Document projection) {
        return projection.values().stream().anyMatch(Utils::isTrue);
    }

    @Override
    public Stream<Document> apply(Stream<Document> stream) {
        return stream.map(this::projectDocument);
    }

    Document projectDocument(Document document) {
        try {
            Document result;
            if (this.hasInclusions) {
                result = new Document();
                if (!this.projection.containsKey("_id")) {
                    Utils.copySubdocumentValue(document, result, "_id");
                }
            } else {
                result = document.cloneDeeply();
            }
            for (Map.Entry<String, Object> entry : this.projection.entrySet()) {
                String field = entry.getKey();
                Object projectionValue = entry.getValue();
                if (ProjectStage.isNumberOrBoolean(projectionValue)) {
                    if (Utils.isTrue(projectionValue)) {
                        Utils.copySubdocumentValue(document, result, field);
                        continue;
                    }
                    Utils.removeSubdocumentValue(result, field);
                    continue;
                }
                if (projectionValue instanceof List) {
                    List resolvedProjectionValues = ((List)projectionValue).stream().map(value -> Expression.evaluateDocument(value, document)).collect(Collectors.toList());
                    result.put(field, (Object)resolvedProjectionValues);
                    continue;
                }
                if (projectionValue == null) {
                    result.put(field, (Object)null);
                    continue;
                }
                Object value2 = Expression.evaluateDocument(projectionValue, document);
                if (value2 instanceof Missing) continue;
                result.put(field, value2);
            }
            return result;
        }
        catch (BadValueException | ConversionFailureException | FailedToOptimizePipelineError e) {
            throw e;
        }
        catch (MongoServerError e) {
            if (e.hasCode(ErrorCode._34471, ErrorCode._40390)) {
                throw e;
            }
            throw new InvalidProjectException(e);
        }
    }

    private void validateProjection() {
        if (this.hasInclusions) {
            this.projection.entrySet().stream().filter(entry -> !((String)entry.getKey()).equals("_id")).filter(entry -> ProjectStage.isNumberOrBoolean(entry.getValue())).filter(entry -> !Utils.isTrue(entry.getValue())).findFirst().ifPresent(nonIdExclusion -> {
                throw new MongoServerError(31254, "Invalid $project :: caused by :: Cannot do exclusion on field " + (String)nonIdExclusion.getKey() + " in inclusion projection");
            });
        }
    }

    private static boolean isNumberOrBoolean(Object projectionValue) {
        return projectionValue instanceof Number || projectionValue instanceof Boolean;
    }

    public static class InvalidProjectException
    extends MongoServerError {
        private static final long serialVersionUID = 1L;
        private static final String MESSAGE_PREFIX = "Invalid $project :: caused by :: ";

        private InvalidProjectException(MongoServerError cause) {
            super(cause.getCode(), cause.getCodeName(), MESSAGE_PREFIX + cause.getMessageWithoutErrorCode(), cause);
        }
    }
}

