/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.cxf.soaprawclient;

import de.codecentric.cxf.common.BootStarterCxfException;
import de.codecentric.cxf.common.XmlUtils;
import de.codecentric.cxf.soaprawclient.SoapRawClientResponse;
import java.io.InputStream;
import java.nio.charset.Charset;
import org.apache.http.Consts;
import org.apache.http.HttpResponse;
import org.apache.http.client.fluent.Request;
import org.apache.http.client.fluent.Response;
import org.apache.http.entity.ContentType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class SoapRawClient {
    private static final Logger LOGGER = LoggerFactory.getLogger(SoapRawClient.class);
    private String soapAction;
    private String soapServiceUrl;

    public <T> SoapRawClient(String soapServiceUrl, Class<T> jaxWsServiceInterfaceClass) throws BootStarterCxfException {
        this.soapAction = XmlUtils.getSoapActionFromJaxWsServiceInterface(jaxWsServiceInterfaceClass);
        this.soapServiceUrl = soapServiceUrl;
    }

    private SoapRawClient() {
    }

    public SoapRawClientResponse callSoapService(InputStream xmlFile) throws BootStarterCxfException {
        SoapRawClientResponse easyRawSoapResponse = new SoapRawClientResponse();
        LOGGER.debug("Calling SoapService with POST on Apache HTTP-Client and configured URL: {}", (Object)this.soapServiceUrl);
        try {
            Response httpResponseContainer = Request.Post((String)this.soapServiceUrl).bodyStream(xmlFile, this.contentTypeTextXmlUtf8()).addHeader("SOAPAction", "\"" + this.soapAction + "\"").execute();
            HttpResponse httpResponse = httpResponseContainer.returnResponse();
            easyRawSoapResponse.setHttpStatusCode(httpResponse.getStatusLine().getStatusCode());
            easyRawSoapResponse.setHttpResponseBody(XmlUtils.parseFileStream2Document(httpResponse.getEntity().getContent()));
        }
        catch (Exception exception) {
            throw new BootStarterCxfException("Some Error accured while trying to Call SoapService for test: " + exception.getMessage());
        }
        return easyRawSoapResponse;
    }

    private ContentType contentTypeTextXmlUtf8() {
        return ContentType.create((String)ContentType.TEXT_XML.getMimeType(), (Charset)Consts.UTF_8);
    }
}

