/*
 * Decompiled with CFR 0.152.
 */
package de.codecentric.boot.admin.server.ui.config;

import java.time.Duration;
import java.time.temporal.ChronoUnit;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.convert.DurationUnit;
import org.springframework.http.CacheControl;

@ConfigurationProperties(value="spring.boot.admin.ui")
public class AdminServerUiProperties {
    private static final String[] CLASSPATH_RESOURCE_LOCATIONS = new String[]{"classpath:/META-INF/spring-boot-admin-server-ui/"};
    private static final String[] CLASSPATH_EXTENSION_RESOURCE_LOCATIONS = new String[]{"classpath:/META-INF/spring-boot-admin-server-ui/extensions/"};
    private String[] resourceLocations = CLASSPATH_RESOURCE_LOCATIONS;
    private String[] extensionResourceLocations = CLASSPATH_EXTENSION_RESOURCE_LOCATIONS;
    private String templateLocation = CLASSPATH_RESOURCE_LOCATIONS[0];
    private String title = "Spring Boot Admin";
    private String brand = "<img src=\"assets/img/icon-spring-boot-admin.svg\"><span>Spring Boot Admin</span>";
    @Nullable
    private String publicUrl = null;
    private boolean cacheTemplates = true;
    private final Cache cache = new Cache();

    public String[] getResourceLocations() {
        return this.resourceLocations;
    }

    public String[] getExtensionResourceLocations() {
        return this.extensionResourceLocations;
    }

    public String getTemplateLocation() {
        return this.templateLocation;
    }

    public String getTitle() {
        return this.title;
    }

    public String getBrand() {
        return this.brand;
    }

    @Nullable
    public String getPublicUrl() {
        return this.publicUrl;
    }

    public boolean isCacheTemplates() {
        return this.cacheTemplates;
    }

    public Cache getCache() {
        return this.cache;
    }

    public void setResourceLocations(String[] resourceLocations) {
        this.resourceLocations = resourceLocations;
    }

    public void setExtensionResourceLocations(String[] extensionResourceLocations) {
        this.extensionResourceLocations = extensionResourceLocations;
    }

    public void setTemplateLocation(String templateLocation) {
        this.templateLocation = templateLocation;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setBrand(String brand) {
        this.brand = brand;
    }

    public void setPublicUrl(@Nullable String publicUrl) {
        this.publicUrl = publicUrl;
    }

    public void setCacheTemplates(boolean cacheTemplates) {
        this.cacheTemplates = cacheTemplates;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AdminServerUiProperties)) {
            return false;
        }
        AdminServerUiProperties other = (AdminServerUiProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.deepEquals(this.getResourceLocations(), other.getResourceLocations())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getExtensionResourceLocations(), other.getExtensionResourceLocations())) {
            return false;
        }
        String this$templateLocation = this.getTemplateLocation();
        String other$templateLocation = other.getTemplateLocation();
        if (this$templateLocation == null ? other$templateLocation != null : !this$templateLocation.equals(other$templateLocation)) {
            return false;
        }
        String this$title = this.getTitle();
        String other$title = other.getTitle();
        if (this$title == null ? other$title != null : !this$title.equals(other$title)) {
            return false;
        }
        String this$brand = this.getBrand();
        String other$brand = other.getBrand();
        if (this$brand == null ? other$brand != null : !this$brand.equals(other$brand)) {
            return false;
        }
        String this$publicUrl = this.getPublicUrl();
        String other$publicUrl = other.getPublicUrl();
        if (this$publicUrl == null ? other$publicUrl != null : !this$publicUrl.equals(other$publicUrl)) {
            return false;
        }
        if (this.isCacheTemplates() != other.isCacheTemplates()) {
            return false;
        }
        Cache this$cache = this.getCache();
        Cache other$cache = other.getCache();
        return !(this$cache == null ? other$cache != null : !((Object)this$cache).equals(other$cache));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AdminServerUiProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.deepHashCode(this.getResourceLocations());
        result = result * 59 + Arrays.deepHashCode(this.getExtensionResourceLocations());
        String $templateLocation = this.getTemplateLocation();
        result = result * 59 + ($templateLocation == null ? 43 : $templateLocation.hashCode());
        String $title = this.getTitle();
        result = result * 59 + ($title == null ? 43 : $title.hashCode());
        String $brand = this.getBrand();
        result = result * 59 + ($brand == null ? 43 : $brand.hashCode());
        String $publicUrl = this.getPublicUrl();
        result = result * 59 + ($publicUrl == null ? 43 : $publicUrl.hashCode());
        result = result * 59 + (this.isCacheTemplates() ? 79 : 97);
        Cache $cache = this.getCache();
        result = result * 59 + ($cache == null ? 43 : ((Object)$cache).hashCode());
        return result;
    }

    public String toString() {
        return "AdminServerUiProperties(resourceLocations=" + Arrays.deepToString(this.getResourceLocations()) + ", extensionResourceLocations=" + Arrays.deepToString(this.getExtensionResourceLocations()) + ", templateLocation=" + this.getTemplateLocation() + ", title=" + this.getTitle() + ", brand=" + this.getBrand() + ", publicUrl=" + this.getPublicUrl() + ", cacheTemplates=" + this.isCacheTemplates() + ", cache=" + this.getCache() + ")";
    }

    public static class Cache {
        @Nullable
        @DurationUnit(value=ChronoUnit.SECONDS)
        private Duration maxAge = Duration.ofSeconds(3600L);
        private Boolean noCache = false;
        private Boolean noStore = false;

        public CacheControl toCacheControl() {
            if (Boolean.TRUE.equals(this.noStore)) {
                return CacheControl.noStore();
            }
            if (Boolean.TRUE.equals(this.noCache)) {
                return CacheControl.noCache();
            }
            if (this.maxAge != null) {
                return CacheControl.maxAge((long)this.maxAge.getSeconds(), (TimeUnit)TimeUnit.SECONDS);
            }
            return CacheControl.empty();
        }

        @Nullable
        public Duration getMaxAge() {
            return this.maxAge;
        }

        public Boolean getNoCache() {
            return this.noCache;
        }

        public Boolean getNoStore() {
            return this.noStore;
        }

        public void setMaxAge(@Nullable Duration maxAge) {
            this.maxAge = maxAge;
        }

        public void setNoCache(Boolean noCache) {
            this.noCache = noCache;
        }

        public void setNoStore(Boolean noStore) {
            this.noStore = noStore;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Cache)) {
                return false;
            }
            Cache other = (Cache)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Duration this$maxAge = this.getMaxAge();
            Duration other$maxAge = other.getMaxAge();
            if (this$maxAge == null ? other$maxAge != null : !((Object)this$maxAge).equals(other$maxAge)) {
                return false;
            }
            Boolean this$noCache = this.getNoCache();
            Boolean other$noCache = other.getNoCache();
            if (this$noCache == null ? other$noCache != null : !((Object)this$noCache).equals(other$noCache)) {
                return false;
            }
            Boolean this$noStore = this.getNoStore();
            Boolean other$noStore = other.getNoStore();
            return !(this$noStore == null ? other$noStore != null : !((Object)this$noStore).equals(other$noStore));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Cache;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Duration $maxAge = this.getMaxAge();
            result = result * 59 + ($maxAge == null ? 43 : ((Object)$maxAge).hashCode());
            Boolean $noCache = this.getNoCache();
            result = result * 59 + ($noCache == null ? 43 : ((Object)$noCache).hashCode());
            Boolean $noStore = this.getNoStore();
            result = result * 59 + ($noStore == null ? 43 : ((Object)$noStore).hashCode());
            return result;
        }

        public String toString() {
            return "AdminServerUiProperties.Cache(maxAge=" + this.getMaxAge() + ", noCache=" + this.getNoCache() + ", noStore=" + this.getNoStore() + ")";
        }
    }
}

