/*
 * Decompiled with CFR 0.152.
 */
package de.ipb_halle.molecularfaces.component.molplugin;

import de.ipb_halle.molecularfaces.component.molplugin.MolPluginCore;
import de.ipb_halle.molecularfaces.component.molplugin.MolPluginRenderer;
import de.ipb_halle.molecularfaces.util.WebXml;
import de.ipb_halle.molecularfaces.util.WebXmlImpl;
import java.io.IOException;
import java.util.Formatter;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.FacesRenderer;

@FacesRenderer(rendererType="molecularfaces.MarvinJSRenderer", componentFamily="molecularfaces.MolPluginFamily")
public class MarvinJSRenderer
extends MolPluginRenderer {
    public static final String RENDERER_TYPE = "molecularfaces.MarvinJSRenderer";
    private String loaderJSVar = "molecularfaces.marvinJSLoaderInstance";
    private WebXml webXml = new WebXmlImpl();

    public void encodeBegin(FacesContext context, UIComponent component) throws IOException {
        MolPluginCore plugin = (MolPluginCore)component;
        if (!plugin.isRendered()) {
            return;
        }
        ResponseWriter writer = context.getResponseWriter();
        writer.startElement("div", (UIComponent)plugin);
        writer.writeAttribute("id", (Object)plugin.getClientId(), null);
        writer.writeAttribute("style", (Object)MarvinJSRenderer.generateDivStyle(plugin), null);
        if (plugin.isReadonly()) {
            this.encodeViewer(context, writer, plugin);
        } else {
            this.encodeEditor(context, writer, plugin);
        }
        writer.endElement("div");
    }

    private void encodeViewer(FacesContext context, ResponseWriter writer, MolPluginCore plugin) throws IOException {
        String clientId = plugin.getClientId();
        String hiddenInputId = clientId + "_Input";
        String divId = clientId + "_MarvinJSViewer";
        this.encodeViewerHTML(context, writer, plugin, divId, hiddenInputId);
        this.encodeViewerJS(context, writer, plugin, divId, hiddenInputId);
    }

    private void encodeViewerHTML(FacesContext context, ResponseWriter writer, MolPluginCore plugin, String divId, String hiddenInputId) throws IOException {
        writer.startElement("div", (UIComponent)plugin);
        writer.writeAttribute("id", (Object)divId, null);
        writer.writeAttribute("style", (Object)MarvinJSRenderer.generateDivStyle(plugin), null);
        writer.endElement("div");
        writer.startElement("input", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)hiddenInputId, null);
        writer.writeAttribute("value", (Object)this.getValueAsString(context, plugin), "value");
        writer.endElement("input");
    }

    private void encodeViewerJS(FacesContext context, ResponseWriter writer, MolPluginCore plugin, String divId, String hiddenInputId) throws IOException {
        writer.startElement("script", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String installPath = this.webXml.getContextParam("de.ipb_halle.molecularfaces.MARVINJS_BASE_URL", context, "");
        StringBuilder sb = new StringBuilder(512 + installPath.length());
        sb.append((CharSequence)plugin.encodeLoadExtResources(this.loaderJSVar));
        Formatter fmt = new Formatter(sb);
        String widgetVar = plugin.getWidgetVar();
        if (widgetVar != null && !widgetVar.isEmpty()) {
            fmt.format("var %s = ", widgetVar);
        }
        fmt.format("%s.status().then(() => {", this.loaderJSVar);
        fmt.format("return molecularfaces.MarvinJSViewer.newViewer(\"%s\", document.getElementById(\"%s\").getAttribute(\"value\"), \"%s\", %d, %d, \"%s\");", divId, hiddenInputId, installPath, plugin.getHeight(), plugin.getWidth(), plugin.getFormat());
        fmt.close();
        sb.append("});");
        writer.writeText((Object)sb, null);
        writer.endElement("script");
    }

    private void encodeEditor(FacesContext context, ResponseWriter writer, MolPluginCore plugin) throws IOException {
        String clientId = plugin.getClientId();
        String hiddenInputId = clientId + "_Input";
        String iframeId = clientId + "_MarvinJSEditor";
        this.encodeEditorHTML(context, writer, plugin, iframeId, hiddenInputId);
        this.encodeEditorJS(context, writer, plugin, iframeId, hiddenInputId);
    }

    private void encodeEditorHTML(FacesContext context, ResponseWriter writer, MolPluginCore plugin, String iframeId, String hiddenInputId) throws IOException {
        String installPath = this.webXml.getContextParam("de.ipb_halle.molecularfaces.MARVINJS_BASE_URL", context, "");
        String embed = this.webXml.getContextParam("de.ipb_halle.molecularfaces.MARVINJS_WEBSERVICES", context, "").equals("true") ? "/editorws.html" : "/editor.html";
        writer.startElement("iframe", (UIComponent)plugin);
        writer.writeAttribute("id", (Object)iframeId, null);
        writer.writeAttribute("src", (Object)(installPath + embed), null);
        writer.writeAttribute("style", (Object)("height:" + plugin.getHeight() + "px;width:" + plugin.getWidth() + "px;"), null);
        writer.endElement("iframe");
        writer.startElement("input", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"hidden", null);
        writer.writeAttribute("id", (Object)hiddenInputId, null);
        writer.writeAttribute("name", (Object)plugin.getClientId(), null);
        writer.writeAttribute("value", (Object)this.getValueAsString(context, plugin), "value");
        writer.endElement("input");
    }

    private void encodeEditorJS(FacesContext context, ResponseWriter writer, MolPluginCore plugin, String iframeId, String hiddenInputId) throws IOException {
        writer.startElement("script", (UIComponent)plugin);
        writer.writeAttribute("type", (Object)"text/javascript", null);
        String installPath = this.webXml.getContextParam("de.ipb_halle.molecularfaces.MARVINJS_BASE_URL", context, "");
        String license = this.webXml.getContextParam("de.ipb_halle.molecularfaces.MARVINJS_LICENSE_URL", context, "");
        StringBuilder sb = new StringBuilder(512 + installPath.length() + license.length());
        sb.append((CharSequence)plugin.encodeLoadExtResources(this.loaderJSVar));
        Formatter fmt = new Formatter(sb);
        String widgetVar = plugin.getWidgetVar();
        if (widgetVar != null && !widgetVar.isEmpty()) {
            fmt.format("var %s = ", widgetVar);
        }
        fmt.format("%s.status().then(() => {", this.loaderJSVar);
        fmt.format("return molecularfaces.MarvinJSEditor.newEditor(\"%s\", document.getElementById(\"%s\").getAttribute(\"value\"), \"%s\", \"%s\", %d, %d, \"%s\")", iframeId, hiddenInputId, installPath, license, plugin.getHeight(), plugin.getWidth(), plugin.getFormat());
        fmt.format(".then((editor) => editor.addChangeListener((mol) => { document.getElementById(\"%s\").setAttribute(\"value\", mol); }));", hiddenInputId);
        fmt.close();
        sb.append("});");
        writer.writeText((Object)sb, null);
        writer.endElement("script");
    }
}

