/*
 * Decompiled with CFR 0.152.
 */
package de.ipb_halle.molecularfaces.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.faces.component.UIComponent;
import javax.faces.component.UIOutput;
import javax.faces.component.UIViewRoot;
import javax.faces.component.html.HtmlBody;
import javax.faces.context.FacesContext;
import javax.faces.event.AbortProcessingException;
import javax.faces.event.ComponentSystemEvent;
import javax.faces.event.ComponentSystemEventListener;
import javax.faces.event.PostAddToViewEvent;

public class ResourceLoader
implements ComponentSystemEventListener,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final String RESOURCES_LIBRARY_NAME = "molecularfaces";
    public static final String JAVASCRIPT_FACET_NAME = "molecularfaces.resourceloader.javascript";
    public static final String STYLESHEET_FACET_NAME = "molecularfaces.resourceloader.stylesheet";
    public static final String JAVASCRIPT = "javax.faces.resource.Script";
    public static final String STYLESHEET = "javax.faces.resource.Stylesheet";
    private final UIComponent component;
    private Set<String> scriptResourcesToLoadInHead = new HashSet<String>();
    private Set<String> scriptResourcesToLoadInBodyAtTop = new HashSet<String>();
    private Set<String> scriptsExtToLoadInHead = new HashSet<String>();
    private Set<String> scriptsExtToLoadInBodyAtTop = new HashSet<String>();
    private Set<String> cssResourcesToLoad = new HashSet<String>();
    private Set<String> cssExtToLoad = new HashSet<String>();

    public ResourceLoader(UIComponent component) {
        this.component = component;
        component.subscribeToEvent(PostAddToViewEvent.class, (ComponentSystemEventListener)this);
    }

    public void processEvent(ComponentSystemEvent event) throws AbortProcessingException {
        if (event instanceof PostAddToViewEvent) {
            FacesContext context = FacesContext.getCurrentInstance();
            this.loadScriptResources(context);
            this.loadCssResources(context);
        }
    }

    public void addScriptResourceToHead(String resource) {
        this.scriptResourcesToLoadInHead.add(resource);
    }

    public Set<String> getScriptResourcesToLoadInHead() {
        return Collections.unmodifiableSet(this.scriptResourcesToLoadInHead);
    }

    public void addScriptResourceToBodyAtTop(String resource) {
        this.scriptResourcesToLoadInBodyAtTop.add(resource);
    }

    public Set<String> getScriptResourcesToLoadInBodyAtTop() {
        return Collections.unmodifiableSet(this.scriptResourcesToLoadInBodyAtTop);
    }

    public void addScriptExtToHead(String src) {
        this.scriptsExtToLoadInHead.add(src);
    }

    public Set<String> getScriptsExtToLoadInHead() {
        return Collections.unmodifiableSet(this.scriptsExtToLoadInHead);
    }

    public void addScriptExtToBodyAtTop(String src) {
        this.scriptsExtToLoadInBodyAtTop.add(src);
    }

    public Set<String> getScriptsExtToLoadInBodyAtTop() {
        return Collections.unmodifiableSet(this.scriptsExtToLoadInBodyAtTop);
    }

    public void addCssResource(String resource) {
        this.cssResourcesToLoad.add(resource);
    }

    public Set<String> getCssResourcesToLoad() {
        return Collections.unmodifiableSet(this.cssResourcesToLoad);
    }

    public void addCssExt(String href) {
        this.cssExtToLoad.add(href);
    }

    public Set<String> getCssExtToLoad() {
        return Collections.unmodifiableSet(this.cssExtToLoad);
    }

    public void addScriptResourceAsFacetComponent(String resource) {
        UIComponent resourceComponent = this.createResourceComponent(resource, JAVASCRIPT);
        resourceComponent.getAttributes().put("external", Boolean.FALSE);
        this.addComponentToResourceContainerInFacet(resourceComponent, JAVASCRIPT_FACET_NAME, this.component.getFacets());
    }

    public void addScriptExtAsFacetComponent(String src) {
        UIComponent resourceComponent = this.createResourceComponent(src, JAVASCRIPT);
        resourceComponent.getAttributes().put("external", Boolean.TRUE);
        this.addComponentToResourceContainerInFacet(resourceComponent, JAVASCRIPT_FACET_NAME, this.component.getFacets());
    }

    public void addCssResourceAsFacetComponent(String resource) {
        UIComponent resourceComponent = this.createResourceComponent(resource, STYLESHEET);
        resourceComponent.getAttributes().put("external", Boolean.FALSE);
        this.addComponentToResourceContainerInFacet(resourceComponent, STYLESHEET_FACET_NAME, this.component.getFacets());
    }

    public void addCssExtAsFacetComponent(String href) {
        UIComponent resourceComponent = this.createResourceComponent(href, STYLESHEET);
        resourceComponent.getAttributes().put("external", Boolean.TRUE);
        this.addComponentToResourceContainerInFacet(resourceComponent, STYLESHEET_FACET_NAME, this.component.getFacets());
    }

    private void loadScriptResources(FacesContext context) {
        UIComponent component;
        for (String resource : this.scriptResourcesToLoadInHead) {
            component = this.createResourceComponent(resource, JAVASCRIPT);
            this.addComponentToHead(component, context);
        }
        this.scriptResourcesToLoadInHead.clear();
        for (String resource : this.scriptResourcesToLoadInBodyAtTop) {
            component = this.createResourceComponent(resource, JAVASCRIPT);
            this.addComponentToBodyAtTop(component, context);
        }
        this.scriptResourcesToLoadInBodyAtTop.clear();
    }

    private void loadCssResources(FacesContext context) {
        for (String resource : this.cssResourcesToLoad) {
            UIComponent component = this.createResourceComponent(resource, STYLESHEET);
            this.addComponentToHead(component, context);
        }
        this.cssResourcesToLoad.clear();
    }

    private UIComponent createResourceComponent(String resourceName, String rendererType) {
        UIOutput resourceComponent = new UIOutput();
        resourceComponent.setRendererType(rendererType);
        resourceComponent.getAttributes().put("library", RESOURCES_LIBRARY_NAME);
        resourceComponent.getAttributes().put("name", resourceName);
        return resourceComponent;
    }

    private void addComponentToHead(UIComponent componentToAdd, FacesContext context) {
        context.getViewRoot().addComponentResource(context, componentToAdd, "head");
    }

    private void addComponentToBodyAtTop(UIComponent componentToAdd, FacesContext context) {
        UIComponent body = this.findBodyComponent(context);
        if (body != null) {
            body.getChildren().add(0, componentToAdd);
        }
    }

    private UIComponent findBodyComponent(FacesContext context) {
        UIViewRoot root = context.getViewRoot();
        for (UIComponent component : root.getChildren()) {
            if (!(component instanceof HtmlBody)) continue;
            return component;
        }
        return null;
    }

    private void addComponentToResourceContainerInFacet(UIComponent component, String facetName, Map<String, UIComponent> facets) {
        UIComponent container = facets.computeIfAbsent(facetName, k -> FacesContext.getCurrentInstance().getApplication().createComponent("javax.faces.ComponentResourceContainer"));
        container.getChildren().add(component);
    }

    public StringBuilder encodeLoadExtResources(String loaderJSVar) {
        StringBuilder sb = new StringBuilder(256);
        Formatter fmt = new Formatter(sb);
        for (String script : this.scriptsExtToLoadInHead) {
            fmt.format(".addScriptToHead(\"%s\")", script);
        }
        for (String script : this.scriptsExtToLoadInBodyAtTop) {
            fmt.format(".addScriptToBodyAtTop(\"%s\")", script);
        }
        for (String href : this.cssExtToLoad) {
            fmt.format(".addCssToHead(\"%s\")", href);
        }
        fmt.close();
        if (sb.length() > 0) {
            sb.insert(0, loaderJSVar);
            sb.append(";");
        }
        return sb;
    }
}

